/*
 * Decompiled with CFR 0.152.
 */
package checkers;

import checkers.controller.GameController;
import checkers.model.Board;
import checkers.model.CheckersGame;
import checkers.model.Rules;
import checkers.view.CheckerGUI;
import checkers.view.Firstscreen;
import checkers.view.NetworkView;
import checkers.view.Secondscreen;

class PlayCheckers {
    PlayCheckers() {
    }

    public static void main(String[] stringArray) {
        Board board = new Board();
        Rules.getInstance().setBoard(board);
        CheckersGame checkersGame = new CheckersGame(board);
        checkersGame.selectColors();
        GameController gameController = new GameController(checkersGame);
        CheckerGUI checkerGUI = new CheckerGUI(gameController, board);
        checkersGame.addObserver(checkerGUI);
        board.addObserver(checkerGUI);
        NetworkView networkView = new NetworkView(checkersGame, board, checkersGame.getPlayerColor(0));
        networkView.addActionListener(gameController);
        Firstscreen firstscreen = new Firstscreen(gameController);
        Secondscreen secondscreen = new Secondscreen(gameController, firstscreen, checkerGUI, networkView);
        firstscreen.setSecondScreen(secondscreen);
        firstscreen.setVisible(true);
    }
}

