/*
 * Decompiled with CFR 0.152.
 */
package checkers.controller;

import checkers.CheckersConstants;
import checkers.model.CheckersGame;
import checkers.model.NetPacket;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class GameController
implements ActionListener,
CheckersConstants,
WindowListener {
    private CheckersGame game;

    public GameController(CheckersGame checkersGame) {
        this.game = checkersGame;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("accept")) {
            this.pressAcceptDraw();
        } else if (actionEvent.getActionCommand().equals("draw")) {
            this.pressDraw();
        } else if (actionEvent.getActionCommand().equals("resign")) {
            this.pressQuit();
        } else if (actionEvent.getActionCommand().equals("player1set")) {
            this.setPlayerName(0, ((NetPacket)actionEvent.getSource()).getPlayer1());
            this.game.setPlayer1Color(((NetPacket)actionEvent.getSource()).getPlayer1Color());
            this.startGame();
        } else if (actionEvent.getActionCommand().equals("player2set")) {
            this.setPlayerName(1, ((NetPacket)actionEvent.getSource()).getPlayer2());
            this.startGame();
        } else {
            try {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                if (n <= 32 && n >= 0) {
                    this.selectSpace(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Invalid ActionEvent");
            }
        }
    }

    public void selectSpace(int n) {
        this.game.selectSpace(n);
    }

    public void pressQuit() {
        this.game.endInQuit(this.game.getCurrentTurn());
    }

    public void pressDraw() {
        this.game.offerDraw();
    }

    public void pressAcceptDraw() {
        this.game.endInDraw(this.game.getCurrentTurn());
    }

    public void setPlayerName(int n, String string) {
        this.game.setPlayerName(n, string);
    }

    public void showEndGame(String string) {
        this.game.endGame(string);
    }

    public void endGameAccepted() {
    }

    public void startGame() {
        this.game.startGame();
    }

    public void setPlayer(int n) {
        this.game.setPlayerNum(n);
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.game.isGameActive()) {
            this.pressQuit();
        }
        System.exit(0);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

