/*
 * Decompiled with CFR 0.152.
 */
package checkers.model;

import checkers.CheckersConstants;
import checkers.model.Move;
import checkers.model.Piece;
import java.util.Observable;
import java.util.Vector;

public class Board
extends Observable
implements CheckersConstants {
    private static final int NUM_PIECES = 12;
    private Piece[] pieces = new Piece[32];

    public Board() {
        for (int i = 0; i < 12; ++i) {
            this.pieces[i] = new Piece(1, 0);
            this.pieces[32 - i - 1] = new Piece(0, 0);
        }
    }

    public boolean movePiece(Move move) {
        boolean bl = false;
        if (!this.occupied(move.endLocation())) {
            this.pieces[move.endLocation()] = this.pieces[move.startLocation()];
            this.pieces[move.startLocation()] = null;
            bl = true;
            this.setChanged();
            this.notifyObservers();
        }
        return bl;
    }

    public boolean occupied(int n) {
        boolean bl = false;
        if (n >= 0 && n < 32 && this.pieces[n] != null) {
            bl = true;
        }
        return bl;
    }

    public void removePiece(int n) {
        this.pieces[n] = null;
    }

    public void kingPiece(int n) {
        if (this.occupied(n)) {
            this.pieces[n].setType(1);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public int colorAt(int n) {
        int n2 = -1;
        if (this.occupied(n)) {
            n2 = this.pieces[n].getColor();
        }
        return n2;
    }

    public Piece getPieceAt(int n) {
        Piece piece = null;
        if (n >= 0 && n < 32 && this.occupied(n)) {
            piece = this.pieces[n];
        }
        return piece;
    }

    public boolean hasPieceOf(int n) {
        boolean bl = false;
        for (int i = 1; i < this.pieces.length; ++i) {
            if (!this.occupied(i) || this.pieces[i].getColor() != n) continue;
            bl = true;
            i = this.pieces.length;
        }
        return bl;
    }

    public int sizeOf() {
        return this.pieces.length;
    }

    public Vector getPieces(int n) {
        Vector<Piece> vector = new Vector<Piece>();
        for (int i = 0; i < this.pieces.length; ++i) {
            if (!this.occupied(i) || this.pieces[i].getColor() != n) continue;
            vector.add(this.pieces[i]);
        }
        return vector;
    }
}

