/*
 * Decompiled with CFR 0.152.
 */
package checkers.model;

import checkers.CheckersConstants;
import checkers.model.Board;
import checkers.model.ForceJumpValidator;
import checkers.model.Move;
import checkers.model.Piece;
import checkers.model.Rules;
import java.util.Observable;

public class CheckersGame
extends Observable
implements CheckersConstants {
    private int numPlayers;
    private String[] playerNames;
    private int[] playerColors;
    private int currentTurn;
    private boolean gameActive;
    private Board theBoard;
    private String message;
    private int selectedIndex;
    private int playerNum = -1;

    public CheckersGame(Board board) {
        this.theBoard = board;
        this.currentTurn = 0;
        this.gameActive = false;
        this.selectedIndex = -1;
        this.numPlayers = 2;
        this.playerNames = new String[this.numPlayers];
        this.playerNames[0] = "Player1";
        this.playerNames[1] = "Player2";
        this.playerColors = new int[this.numPlayers];
        this.selectColors();
    }

    public void endTurn() {
        this.currentTurn = (3 - this.currentTurn) % 2;
        this.checkEnd();
        this.setChanged();
        this.notifyObservers();
    }

    public void endGame(Object object) {
        this.gameActive = false;
        this.setChanged();
        this.notifyObservers(object);
    }

    public void endInDraw(int n) {
        this.message = "Draw accepted. Game over.";
        this.endGame("accept");
    }

    public void endInQuit(int n) {
        this.message = this.playerNames[n] + " has resigned from the game.";
        this.endGame("resign");
    }

    public void selectColors() {
        this.playerColors[0] = (int)(Math.random() * 100.0 % 2.0);
        this.playerColors[1] = (3 - this.playerColors[0]) % 2;
    }

    public void startGame() {
        this.gameActive = true;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean selectSpace(int n) {
        boolean bl = false;
        if (this.gameActive) {
            if (this.theBoard.occupied(this.selectedIndex)) {
                Move move = new Move(this.selectedIndex, n);
                this.movePiece(move);
                this.selectedIndex = -1;
                bl = true;
            } else if (this.theBoard.occupied(n) && this.theBoard.getPieceAt(n).getColor() == this.getPlayerColor(this.currentTurn)) {
                this.selectedIndex = n;
                bl = true;
            }
            this.setChanged();
            this.notifyObservers();
        }
        return bl;
    }

    private void movePiece(Move move) {
        if (move.validate()) {
            this.setChanged();
            this.notifyObservers(move);
            boolean bl = move.isJump();
            this.theBoard.movePiece(move);
            if ((move.endLocation() < 4 || move.endLocation() > 27) && this.theBoard.getPieceAt(move.endLocation()).getType() == 0) {
                this.theBoard.kingPiece(move.endLocation());
            }
            if (bl) {
                this.theBoard.removePiece(move.getJumpIndex());
                if (Rules.getInstance() instanceof ForceJumpValidator) {
                    if (!((ForceJumpValidator)Rules.getInstance()).pieceHasForceJumps(move.endLocation())) {
                        this.endTurn();
                    }
                } else {
                    this.endTurn();
                }
            } else {
                this.endTurn();
            }
        }
    }

    private void checkEnd() {
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            Piece piece = this.theBoard.getPieceAt(i);
            if (piece == null || piece.getColor() != this.getPlayerColor(this.currentTurn)) continue;
            ++n;
        }
        if (n == 0) {
            this.gameActive = false;
        }
    }

    public void offerDraw() {
        this.setChanged();
        this.notifyObservers("draw");
    }

    public String getPlayerName(int n) {
        return this.playerNames[n];
    }

    public void setPlayerName(int n, String string) {
        this.playerNames[n] = string;
        this.setChanged();
        this.notifyObservers();
    }

    public int getPlayerColor(int n) {
        return this.playerColors[n];
    }

    public void setPlayer1Color(int n) {
        this.playerColors[0] = n;
        this.playerColors[1] = (3 - n) % 2;
    }

    public int getCurrentTurn() {
        return this.currentTurn;
    }

    public boolean isGameActive() {
        return this.gameActive;
    }

    public String getMessage() {
        return this.message;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public int getPlayerNum() {
        return this.playerNum;
    }

    public void setPlayerNum(int n) {
        this.playerNum = n;
    }
}

