/*
 * Decompiled with CFR 0.152.
 */
package checkers.model;

import checkers.CheckersConstants;
import checkers.model.Move;
import checkers.model.Piece;
import checkers.model.Rules;
import java.util.LinkedList;
import java.util.ListIterator;

public class ForceJumpValidator
extends Rules
implements CheckersConstants {
    private LinkedList myForceStarts;
    private LinkedList myForceEnds;

    public boolean validateMove(Move move) {
        boolean bl = false;
        this.myForceStarts = new LinkedList();
        this.myForceEnds = new LinkedList();
        bl = this.containsForceJump(move.startLocation()) ? this.isForceJump(move) : super.validateMove(move);
        return bl;
    }

    private boolean isForceJump(Move move) {
        boolean bl = false;
        int n = move.startLocation();
        int n2 = move.endLocation();
        int n3 = this.myForceStarts.indexOf(new Integer(n));
        if (n3 != -1) {
            bl = this.checkForceJump(n, n2, n3);
        }
        return bl;
    }

    private boolean containsForceJump(int n) {
        boolean bl = false;
        int n2 = this.myBoard.getPieceAt(n).getColor();
        for (int i = 0; i < this.myBoard.sizeOf(); ++i) {
            if (this.myBoard.getPieceAt(i) == null || this.myBoard.getPieceAt(i).getColor() != n2) continue;
            this.pieceHasForceJumps(i);
        }
        bl = this.myForceStarts.size() > 0;
        return bl;
    }

    public boolean pieceHasForceJumps(int n) {
        boolean bl = false;
        Piece piece = this.myBoard.getPieceAt(n);
        if (piece.getColor() == 1 || piece.getColor() == 0 && piece.getType() == 1) {
            if (!this.myBoard.occupied(n + 7) && super.isJump(n, n + 7)) {
                this.myForceStarts.add(new Integer(n));
                this.myForceEnds.add(new Integer(n + 7));
                bl = true;
            }
            if (!this.myBoard.occupied(n + 9) && super.isJump(n, n + 9)) {
                this.myForceStarts.add(new Integer(n));
                this.myForceEnds.add(new Integer(n + 9));
                bl = true;
            }
        }
        if (piece.getColor() == 0 || piece.getColor() == 1 && piece.getColor() == 1) {
            if (!this.myBoard.occupied(n - 7) && super.isJump(n, n - 7)) {
                this.myForceStarts.add(new Integer(n));
                this.myForceEnds.add(new Integer(n - 7));
                bl = true;
            }
            if (!this.myBoard.occupied(n - 9) && super.isJump(n, n - 9)) {
                this.myForceStarts.add(new Integer(n));
                this.myForceEnds.add(new Integer(n - 9));
                bl = true;
            }
        }
        return bl;
    }

    private boolean checkForceJump(int n, int n2, int n3) {
        boolean bl = false;
        ListIterator listIterator = this.myForceStarts.listIterator(n3);
        ListIterator listIterator2 = this.myForceEnds.listIterator(n3);
        while (listIterator.hasNext() && !bl) {
            Integer n4 = (Integer)listIterator.next();
            Integer n5 = (Integer)listIterator2.next();
            bl = n4.equals(new Integer(n)) && n5.equals(new Integer(n2));
        }
        return bl;
    }
}

