/*
 * Decompiled with CFR 0.152.
 */
package checkers.model;

import checkers.CheckersConstants;
import checkers.model.Board;
import checkers.model.ForceJumpValidator;
import checkers.model.Move;

public class Rules
implements CheckersConstants {
    protected Board myBoard;
    protected int myJumpIndex;
    protected static Rules myInstance = null;

    protected Rules() {
    }

    public static Rules getInstance() {
        if (myInstance == null) {
            myInstance = new ForceJumpValidator();
        }
        return myInstance;
    }

    public void setBoard(Board board) {
        this.myBoard = board;
    }

    public boolean validateMove(Move move) {
        boolean bl = false;
        int n = move.startLocation();
        int n2 = move.endLocation();
        if (!this.myBoard.occupied(n2) && !(bl = this.isAdjacent(n, n2))) {
            bl = this.isJump(n, n2);
        }
        return bl;
    }

    private boolean isAdjacent(int n, int n2) {
        boolean bl = false;
        int n3 = n / 4;
        int n4 = n2 / 4;
        if (Math.abs(n3 - n4) == 1 && this.isValidDirection(n3, n4, n)) {
            int n5 = n2 - n;
            bl = n3 % 2 == 0 ? this.adjacentEvenRowMove(n3, n4, n5) : this.adjacentOddRowMove(n3, n4, n5);
        }
        return bl;
    }

    public boolean isJump(int n, int n2) {
        boolean bl = false;
        int n3 = n / 4;
        int n4 = n2 / 4;
        if (Math.abs(n3 - n4) == 2 && n2 >= 0 && n2 < this.myBoard.sizeOf() && this.isValidDirection(n3, n4, n)) {
            int n5 = n2 - n;
            bl = n3 % 2 == 0 ? this.jumpEvenRowMove(n3, n4, n, n5) : this.jumpOddRowMove(n3, n4, n, n5);
        }
        return bl;
    }

    private boolean isValidDirection(int n, int n2, int n3) {
        boolean bl = false;
        if (this.myBoard.getPieceAt(n3) != null && !(bl = this.myBoard.getPieceAt(n3).getType() == 1)) {
            bl = this.myBoard.getPieceAt(n3).getColor() == 1 ? n2 > n : n > n2;
        }
        return bl;
    }

    private boolean adjacentEvenRowMove(int n, int n2, int n3) {
        boolean bl = false;
        bl = n2 > n ? n3 == 3 || n3 == 4 : -n3 == 4 || -n3 == 5;
        return bl;
    }

    private boolean adjacentOddRowMove(int n, int n2, int n3) {
        boolean bl = false;
        bl = n2 > n ? n3 == 4 || n3 == 5 : -n3 == 3 || -n3 == 4;
        return bl;
    }

    private boolean jumpOddRowMove(int n, int n2, int n3, int n4) {
        boolean bl = false;
        int n5 = -1;
        if (n2 > n) {
            if (n4 == 7) {
                if (this.myBoard.getPieceAt(n3 + 4) != null) {
                    bl = this.myBoard.getPieceAt(n3).getColor() != this.myBoard.getPieceAt(n3 + 4).getColor();
                    n5 = n3 + 4;
                }
            } else if (n4 == 9 && this.myBoard.getPieceAt(n3 + 5) != null) {
                bl = this.myBoard.getPieceAt(n3).getColor() != this.myBoard.getPieceAt(n3 + 5).getColor();
                n5 = n3 + 5;
            }
        } else if (-n4 == 7) {
            if (this.myBoard.getPieceAt(n3 - 3) != null) {
                bl = this.myBoard.getPieceAt(n3).getColor() != this.myBoard.getPieceAt(n3 - 3).getColor();
                n5 = n3 - 3;
            }
        } else if (-n4 == 9 && this.myBoard.getPieceAt(n3 - 4) != null) {
            bl = this.myBoard.getPieceAt(n3).getColor() != this.myBoard.getPieceAt(n3 - 4).getColor();
            n5 = n3 - 4;
        }
        if (bl) {
            this.setJumpIndex(n5);
        }
        return bl;
    }

    private boolean jumpEvenRowMove(int n, int n2, int n3, int n4) {
        boolean bl = false;
        int n5 = -1;
        if (n2 > n) {
            if (n4 == 7) {
                if (this.myBoard.getPieceAt(n3 + 3) != null) {
                    bl = this.myBoard.getPieceAt(n3).getColor() != this.myBoard.getPieceAt(n3 + 3).getColor();
                    n5 = n3 + 3;
                }
            } else if (n4 == 9 && this.myBoard.getPieceAt(n3 + 4) != null) {
                bl = this.myBoard.getPieceAt(n3).getColor() != this.myBoard.getPieceAt(n3 + 4).getColor();
                n5 = n3 + 4;
            }
        } else if (-n4 == 7) {
            if (this.myBoard.getPieceAt(n3 - 4) != null) {
                bl = this.myBoard.getPieceAt(n3).getColor() != this.myBoard.getPieceAt(n3 - 4).getColor();
                n5 = n3 - 4;
            }
        } else if (-n4 == 9 && this.myBoard.getPieceAt(n3 - 5) != null) {
            bl = this.myBoard.getPieceAt(n3).getColor() != this.myBoard.getPieceAt(n3 - 5).getColor();
            n5 = n3 - 5;
        }
        if (bl) {
            this.setJumpIndex(n5);
        }
        return bl;
    }

    private void setJumpIndex(int n) {
        this.myJumpIndex = n;
    }

    public int getJumpIndex() {
        return this.myJumpIndex;
    }
}

