/*
 * Decompiled with CFR 0.152.
 */
package checkers.view;

import checkers.CheckersConstants;
import checkers.model.Board;
import checkers.model.CheckersGame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CheckerGUI
extends JFrame
implements CheckersConstants,
Observer {
    private static final long serialVersionUID = 1L;
    private static final String warning = "In Warning Time.";
    private Board board;
    private JPanel boardPanel;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JPanel infoPanel;
    private ArrayList squares;
    private JLabel playerOneLabel;
    private JLabel playerTwoLabel;
    private JLabel timeRemainingLabel;
    private JButton resignButton;
    private JButton drawButton;
    private JLabel warningLabel;
    private JLabel whosTurnLabel;
    private ActionListener listener;
    private boolean namesSet;
    private boolean actionListenerAdded = true;
    private JButton acceptDraw;

    public CheckerGUI(ActionListener actionListener, Board board) {
        super("Checkers");
        this.listener = actionListener;
        this.board = board;
        this.squares = new ArrayList(32);
        this.namesSet = false;
        this.addWindowListener((WindowListener)((Object)actionListener));
        this.initComponents(actionListener);
    }

    private void initComponents(ActionListener actionListener) {
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        for (int i = 0; i < 32; ++i) {
            this.squares.add(i, new JButton());
            JButton jButton = (JButton)this.squares.get(i);
            jButton.setActionCommand(Integer.toString(i));
            jButton.addActionListener(actionListener);
            jButton.setBackground(Color.WHITE);
            jButton.setBorder(BorderFactory.createEtchedBorder(Color.BLACK, Color.DARK_GRAY));
            jButton.setPreferredSize(new Dimension(80, 80));
        }
        this.playerOneLabel = new JLabel();
        this.playerOneLabel.setPreferredSize(new Dimension(160, 30));
        this.playerTwoLabel = new JLabel();
        this.playerTwoLabel.setPreferredSize(new Dimension(160, 30));
        this.whosTurnLabel = new JLabel();
        this.whosTurnLabel.setBorder(BorderFactory.createBevelBorder(1));
        this.whosTurnLabel.setPreferredSize(new Dimension(80, 30));
        this.warningLabel = new JLabel();
        this.warningLabel.setText(warning);
        this.warningLabel.setVisible(false);
        this.timeRemainingLabel = new JLabel("NO TIME");
        this.timeRemainingLabel.setPreferredSize(new Dimension(75, 27));
        this.timeRemainingLabel.setBorder(BorderFactory.createBevelBorder(1));
        this.resignButton = new JButton("Resign");
        this.resignButton.setActionCommand("resign");
        this.resignButton.addActionListener(actionListener);
        this.resignButton.setPreferredSize(new Dimension(75, 27));
        this.drawButton = new JButton("Draw");
        this.drawButton.setActionCommand("draw");
        this.drawButton.addActionListener(actionListener);
        this.drawButton.setPreferredSize(new Dimension(75, 27));
        this.acceptDraw = new JButton();
        this.acceptDraw.setActionCommand("accept");
        this.acceptDraw.addActionListener(actionListener);
        this.boardPanel = new JPanel();
        this.topPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.infoPanel = new JPanel();
        this.buildScreen();
    }

    private void buildScreen() {
        this.boardPanel.setLayout(new GridBagLayout());
        this.boardPanel.setBackground(Color.RED);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        JLabel jLabel = new JLabel();
        jLabel.setEnabled(false);
        jLabel.setBackground(Color.RED);
        jLabel.setPreferredSize(new Dimension(80, 80));
        gridBagConstraints.gridy = 0;
        gridBagConstraints2.gridy = 0;
        for (int i = 0; i < 32; ++i) {
            if (gridBagConstraints.gridy % 2 == 0) {
                gridBagConstraints.gridx = 2 * (i % 4);
                gridBagConstraints2.gridx = 2 * (i % 4) + 1;
            } else {
                gridBagConstraints.gridx = 2 * (i % 4) + 1;
                gridBagConstraints2.gridx = 2 * (i % 4);
            }
            this.boardPanel.add((Component)((JButton)this.squares.get(i)), gridBagConstraints);
            this.boardPanel.add((Component)jLabel, gridBagConstraints2);
            if (i % 4 != 3) continue;
            ++gridBagConstraints.gridy;
            ++gridBagConstraints2.gridy;
        }
        this.boardPanel.setBorder(BorderFactory.createBevelBorder(0, Color.WHITE, Color.BLACK));
        this.infoPanel.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        this.infoPanel.add((Component)new JLabel("Turn:"), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.infoPanel.add((Component)this.whosTurnLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.infoPanel.add((Component)this.drawButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.infoPanel.add((Component)this.resignButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.infoPanel.add((Component)new JLabel("Time Remaining:"), gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.infoPanel.add((Component)this.timeRemainingLabel, gridBagConstraints);
        this.topPanel.setLayout(new GridBagLayout());
        this.topPanel.add(this.playerOneLabel);
        this.bottomPanel.setLayout(new GridBagLayout());
        this.bottomPanel.add(this.playerTwoLabel);
        this.setPieces();
        this.getContentPane().add((Component)this.boardPanel, "Center");
        this.getContentPane().add((Component)this.infoPanel, "East");
        this.getContentPane().add((Component)this.topPanel, "North");
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.pack();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CheckersGame) {
            CheckersGame checkersGame = (CheckersGame)observable;
            this.namesSet = this.setNames(checkersGame);
            this.whosTurnLabel.setText(checkersGame.getPlayerName(checkersGame.getCurrentTurn()));
            if (object instanceof String) {
                if (((String)object).equals("resign")) {
                    this.resignGame(checkersGame.getMessage(), checkersGame.getPlayerName((checkersGame.getCurrentTurn() + 1) % 2));
                } else if (((String)object).equals("draw")) {
                    if (this.offerDraw()) {
                        this.acceptDraw.doClick();
                    }
                } else if (((String)object).equals("accept")) {
                    this.acceptDraw();
                }
            } else if (!checkersGame.isGameActive() && this.namesSet) {
                this.showWin(checkersGame.getPlayerName((checkersGame.getCurrentTurn() + 1) % 2));
            }
            if (checkersGame.getSelectedIndex() > -1) {
                ((JButton)this.squares.get(checkersGame.getSelectedIndex())).setBackground(Color.GREEN);
            } else {
                for (int i = 0; i < 32; ++i) {
                    ((JButton)this.squares.get(i)).setBackground(Color.WHITE);
                }
            }
            this.setTurn(checkersGame.getCurrentTurn() == checkersGame.getPlayerNum() || checkersGame.getPlayerNum() == -1);
            this.setPieces();
        }
        if (observable instanceof Board) {
            this.setPieces();
        }
    }

    private boolean setNames(CheckersGame checkersGame) {
        boolean bl = false;
        if (!this.namesSet) {
            if (this.playerOneLabel.getText() != checkersGame.getPlayerName(checkersGame.getPlayerColor(1)) || this.playerTwoLabel.getText() != checkersGame.getPlayerName(checkersGame.getPlayerColor(0))) {
                this.playerOneLabel.setText(checkersGame.getPlayerName(checkersGame.getPlayerColor(1)));
                this.playerTwoLabel.setText(checkersGame.getPlayerName(checkersGame.getPlayerColor(0)));
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private void showWin(String string) {
        String string2 = string + " has won!";
        JOptionPane.showMessageDialog(this, string2, "WIN", 1);
        this.setDefaultCloseOperation(3);
        this.drawButton.setEnabled(false);
        this.resignButton.setEnabled(false);
    }

    private void setPieces() {
        for (int i = 0; i < 32; ++i) {
            if (this.board.getPieceAt(i) != null) {
                this.checkType(i);
                continue;
            }
            ((JButton)this.squares.get(i)).setIcon(null);
        }
    }

    private void checkType(int n) {
        if (this.board.getPieceAt(n).getType() == 0) {
            this.checkColor(n, 0);
        } else {
            this.checkColor(n, 1);
        }
    }

    private void checkColor(int n, int n2) {
        ImageIcon imageIcon = new ImageIcon("WhiteSingle.gif");
        ImageIcon imageIcon2 = new ImageIcon("BlueSingle.gif");
        ImageIcon imageIcon3 = new ImageIcon("WhiteKing.gif");
        ImageIcon imageIcon4 = new ImageIcon("BlueKing.gif");
        if (this.board.getPieceAt(n).getColor() == 0) {
            if (n2 == 0) {
                ((JButton)this.squares.get(n)).setIcon(imageIcon);
            } else {
                ((JButton)this.squares.get(n)).setIcon(imageIcon3);
            }
        } else if (n2 == 0) {
            ((JButton)this.squares.get(n)).setIcon(imageIcon2);
        } else {
            ((JButton)this.squares.get(n)).setIcon(imageIcon4);
        }
    }

    private void resignGame(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, "End Game", 1);
        this.showWin(string2);
    }

    private void setTurn(boolean bl) {
        for (int i = 0; i < 32; ++i) {
            if (bl) {
                if (this.actionListenerAdded) continue;
                ((JButton)this.squares.get(i)).addActionListener(this.listener);
                this.resignButton.addActionListener(this.listener);
                this.drawButton.addActionListener(this.listener);
                continue;
            }
            if (!this.actionListenerAdded) continue;
            ((JButton)this.squares.get(i)).removeActionListener(this.listener);
            this.resignButton.removeActionListener(this.listener);
            this.drawButton.removeActionListener(this.listener);
        }
        this.actionListenerAdded = bl;
    }

    public boolean offerDraw() {
        int n = JOptionPane.showOptionDialog(this, "Do you Accept a Draw?", "Offer Draw", -1, -1, null, new Object[]{"Reject", "Accept"}, "Reject");
        return n == 1;
    }

    private void acceptDraw() {
        JOptionPane.showMessageDialog(this, "It's a Draw!", "End Game", 1);
        this.setDefaultCloseOperation(3);
        this.drawButton.setEnabled(false);
        this.resignButton.setEnabled(false);
    }
}

