/*
 * Decompiled with CFR 0.152.
 */
package checkers.view;

import checkers.CheckersConstants;
import checkers.model.CheckersGame;
import checkers.model.Move;
import checkers.model.NetPacket;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JOptionPane;

public class NetworkView
extends Thread
implements Observer,
CheckersConstants {
    public static final int PORT_NUM = 1051;
    private List actionListeners = new ArrayList();
    private ServerSocket socket;
    private Socket client = null;
    private boolean isConnected = false;
    ObjectOutputStream oos;
    ObjectInputStream ois;
    private List observables = new ArrayList();
    private String playerName;
    private int playerNum;
    private boolean hostGame = false;
    private int player1Color;

    public NetworkView(Observable observable, Observable observable2, int n) {
        this.observables.add(observable);
        this.observables.add(observable2);
        this.player1Color = n;
    }

    public void connectToHost(String string) {
        this.hostGame = false;
        this.setNetwork();
        try {
            this.client = new Socket(string, 1051);
            this.start();
        }
        catch (IOException iOException) {
            NetworkView.errorHandler(iOException);
        }
    }

    public void hostGame() {
        this.hostGame = true;
        this.setNetwork();
        this.start();
    }

    public void stopHostListening() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setNetwork() {
        Iterator iterator = this.observables.iterator();
        while (iterator.hasNext()) {
            ((Observable)iterator.next()).addObserver(this);
        }
    }

    public void run() {
        try {
            if (this.client == null) {
                this.log("Waiting for connections");
                this.socket = new ServerSocket(1051);
                this.client = this.socket.accept();
                this.log("Accepted a connection from: " + this.client.getInetAddress());
            }
            this.isConnected = true;
            this.oos = new ObjectOutputStream(this.client.getOutputStream());
            this.ois = new ObjectInputStream(this.client.getInputStream());
            this.oos.writeObject(this.getNamePacket());
            this.oos.flush();
            NetPacket netPacket = (NetPacket)this.ois.readObject();
            while (this.isConnected && this.client.isConnected()) {
                ActionEvent actionEvent;
                this.log("Packet received: " + netPacket.toString());
                if (netPacket.isDraw()) {
                    this.offerDraw();
                } else if (netPacket.isResign()) {
                    this.resign();
                } else if (netPacket.getMove() != null) {
                    this.makeMove(netPacket.getMove());
                } else if (netPacket.getPlayer1() != null) {
                    actionEvent = new ActionEvent(netPacket, 0, "player1set");
                    this.performAction(actionEvent);
                } else if (netPacket.getPlayer2() != null) {
                    actionEvent = new ActionEvent(netPacket, 0, "player2set");
                    this.performAction(actionEvent);
                }
                if (!this.isConnected) break;
                try {
                    netPacket = (NetPacket)this.ois.readObject();
                }
                catch (SocketException socketException) {}
            }
            this.log("Disconnected");
            this.ois.close();
            this.oos.close();
            this.client.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void update(Observable observable, Object object) {
        if (this.isConnected() && object != null) {
            NetPacket netPacket = new NetPacket();
            if (object instanceof Move) {
                netPacket.setMove((Move)object);
            } else if (object instanceof String) {
                if (object.equals("resign")) {
                    netPacket.setResign(true);
                } else if (object.equals("draw")) {
                    netPacket.setDraw(true);
                }
            }
            try {
                this.oos.writeObject(netPacket);
                this.oos.flush();
                this.log("Sent Packet: " + netPacket);
            }
            catch (IOException iOException) {
                NetworkView.errorHandler(iOException);
            }
            if (observable instanceof CheckersGame) {
                CheckersGame checkersGame = (CheckersGame)observable;
                this.setConnected(checkersGame.isGameActive());
            }
        }
    }

    private void performAction(ActionEvent actionEvent) {
        Iterator iterator = this.actionListeners.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }

    private void offerDraw() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "draw");
        this.performAction(actionEvent);
    }

    private void resign() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "resign");
        this.performAction(actionEvent);
    }

    private void makeMove(Move move) {
        ActionEvent actionEvent = new ActionEvent(this, 0, String.valueOf(move.startLocation()));
        this.performAction(actionEvent);
        actionEvent = new ActionEvent(this, 0, String.valueOf(move.endLocation()));
        this.performAction(actionEvent);
    }

    private void log(String string) {
        System.out.println(this.getTime() + string);
    }

    private String getTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        return "[" + simpleDateFormat.format(new Date(System.currentTimeMillis())) + "] ";
    }

    private static void errorHandler(Exception exception) {
        JOptionPane.showMessageDialog(null, "Error connecting to server.\n\n" + exception.getMessage(), "Error", 0);
    }

    private boolean isConnected() {
        return this.isConnected;
    }

    private void setConnected(boolean bl) {
        this.isConnected = bl;
    }

    public void setPlayerName(int n, String string) {
        this.playerName = string;
        this.playerNum = n;
    }

    private NetPacket getNamePacket() {
        NetPacket netPacket = new NetPacket();
        if (this.playerNum == 0) {
            netPacket.setPlayer1(this.playerName);
        } else if (this.playerNum == 1) {
            netPacket.setPlayer2(this.playerName);
        }
        if (this.hostGame) {
            netPacket.setPlayer1Color(this.player1Color);
        }
        return netPacket;
    }
}

