/*
 * Decompiled with CFR 0.152.
 */
package checkers.view;

import checkers.CheckersConstants;
import checkers.controller.GameController;
import checkers.view.CheckerGUI;
import checkers.view.Firstscreen;
import checkers.view.NetworkView;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Secondscreen
extends JFrame
implements ActionListener,
ChangeListener,
CheckersConstants {
    private static final long serialVersionUID = 1L;
    private GameController theFacade;
    private Firstscreen theFirst;
    private CheckerGUI gui;
    private NetworkView netView;
    private int gameType;
    private Checkbox timedGameBox;
    private JLabel playerOneLabel;
    private JLabel playerTwoLabel;
    private JTextField playerOneField;
    private JTextField playerTwoField;
    private JLabel turnLengthLabel;
    private JLabel WarningLengthLabel;
    private JButton okButton;
    private JButton cancelButton;
    private JSlider turnLengthField;
    private JSlider warningLengthField;

    public Secondscreen(GameController gameController, Firstscreen firstscreen, CheckerGUI checkerGUI, NetworkView networkView) {
        super("Second Screen");
        this.theFacade = gameController;
        this.theFirst = firstscreen;
        this.gui = checkerGUI;
        this.netView = networkView;
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.timedGameBox = new Checkbox();
        this.playerOneLabel = new JLabel();
        this.playerTwoLabel = new JLabel();
        this.playerOneField = new JTextField();
        this.playerTwoField = new JTextField();
        this.turnLengthLabel = new JLabel();
        this.WarningLengthLabel = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.turnLengthField = new JSlider(10, 300, 120);
        this.warningLengthField = new JSlider(10, 300, 120);
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Secondscreen.this.exitForm(windowEvent);
            }
        });
        this.timedGameBox.setBackground(new Color(204, 204, 204));
        this.timedGameBox.setName("timedGameBox");
        this.timedGameBox.setForeground(Color.black);
        this.timedGameBox.setLabel("Timed game");
        this.timedGameBox.setState(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(31, 0, 1, 0);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.timedGameBox, gridBagConstraints);
        this.playerOneLabel.setName("playerOneLabel");
        this.playerOneLabel.setBackground(new Color(204, 204, 204));
        this.playerOneLabel.setForeground(Color.black);
        this.playerOneLabel.setText("Player 1:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.playerOneLabel, gridBagConstraints);
        this.playerTwoLabel.setName("playerTwoLabel");
        this.playerTwoLabel.setBackground(new Color(204, 204, 204));
        this.playerTwoLabel.setForeground(Color.black);
        this.playerTwoLabel.setText("Player 2:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.playerTwoLabel, gridBagConstraints);
        this.playerOneField.setBackground(Color.white);
        this.playerOneField.setName("textfield1");
        this.playerOneField.setForeground(Color.black);
        this.playerOneField.setText("");
        this.playerOneField.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.playerOneField, gridBagConstraints);
        this.playerTwoField.setBackground(Color.white);
        this.playerTwoField.setName("textfield2");
        this.playerTwoField.setForeground(Color.black);
        this.playerTwoField.setText("");
        this.playerTwoField.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.playerTwoField, gridBagConstraints);
        this.turnLengthLabel.setName("label3");
        this.turnLengthLabel.setBackground(new Color(204, 204, 204));
        this.turnLengthLabel.setForeground(Color.black);
        this.turnLengthLabel.setText("Turn Length ( " + this.turnLengthField.getValue() + " seconds )");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.turnLengthLabel, gridBagConstraints);
        this.WarningLengthLabel.setName("label4");
        this.WarningLengthLabel.setBackground(new Color(204, 204, 204));
        this.WarningLengthLabel.setForeground(Color.black);
        this.WarningLengthLabel.setText("Warning Length ( " + this.warningLengthField.getValue() + " seconds )");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.WarningLengthLabel, gridBagConstraints);
        this.okButton.setText("OK");
        this.okButton.setName("button1");
        this.okButton.setBackground(new Color(212, 208, 200));
        this.okButton.setForeground(Color.black);
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(20, 0, 10, 12);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setName("button2");
        this.cancelButton.setBackground(new Color(212, 208, 200));
        this.cancelButton.setForeground(Color.black);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(20, 0, 10, 0);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.turnLengthField.setName("textfield3");
        this.turnLengthField.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.getContentPane().add((Component)this.turnLengthField, gridBagConstraints);
        this.warningLengthField.setName("textfield4");
        this.warningLengthField.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        this.getContentPane().add((Component)this.warningLengthField, gridBagConstraints);
    }

    public void setType(int n) {
        this.gameType = n;
        if (this.gameType != 0) {
            if (this.gameType == 1) {
                this.playerTwoLabel.setEnabled(false);
                this.playerTwoField.setEnabled(false);
            } else if (this.gameType == 2) {
                this.playerOneLabel.setEnabled(false);
                this.playerOneField.setEnabled(false);
                this.timedGameBox.setEnabled(false);
                this.turnLengthLabel.setEnabled(false);
                this.WarningLengthLabel.setEnabled(false);
                this.turnLengthField.setEnabled(false);
                this.warningLengthField.setEnabled(false);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource().equals(this.turnLengthField)) {
            this.turnLengthLabel.setText("Turn Length ( " + this.turnLengthField.getValue() + " seconds )");
        } else if (changeEvent.getSource().equals(this.warningLengthField)) {
            this.WarningLengthLabel.setText("Warning Length ( " + this.warningLengthField.getValue() + " seconds )");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getActionCommand().equals("ok")) {
                if (this.playerOneField.isEnabled() && this.playerOneField.getText().equalsIgnoreCase("")) {
                    this.playerOneField.setText("player1");
                }
                if (this.playerTwoField.isEnabled() && this.playerTwoField.getText().equalsIgnoreCase("")) {
                    this.playerTwoField.setText("player2");
                }
                this.theFacade.setPlayerName(0, this.playerOneField.getText());
                this.theFacade.setPlayerName(1, this.playerTwoField.getText());
                if (this.gameType == 1) {
                    this.theFacade.setPlayer(0);
                    this.theFacade.setPlayerName(1, "Waiting for Opponent");
                    this.netView.setPlayerName(0, this.playerOneField.getText());
                    this.netView.hostGame();
                } else if (this.gameType == 2) {
                    this.theFacade.setPlayer(1);
                    this.netView.setPlayerName(1, this.playerTwoField.getText());
                    this.netView.connectToHost(this.theFirst.getIP());
                } else {
                    this.theFacade.startGame();
                }
                this.setVisible(false);
                this.gui.setVisible(true);
            } else if (actionEvent.getActionCommand().equals("cancel")) {
                this.dispose();
                this.theFirst.setVisible(true);
            } else if (actionEvent.getSource() instanceof Checkbox) {
                if (this.timedGameBox.getState()) {
                    this.turnLengthField.setEnabled(true);
                    this.warningLengthField.setEnabled(true);
                } else {
                    this.turnLengthField.setEnabled(false);
                    this.warningLengthField.setEnabled(false);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }
}

