/*
 * CheckersConstants.java
 *
 * Version:
 *     $Id: CheckersConstants.java,v 1.6 2005/11/08 23:02:09 pjk7060 Exp $
 *
 * Revisions:
 *     $Log: CheckersConstants.java,v $
 *     Revision 1.6  2005/11/08 23:02:09  pjk7060
 *     comments
 *
 *     Revision 1.5  2005/11/07 00:01:30  mtg9625
 *     Draw functionality implemented, at least locally
 *
 *     Revision 1.4  2005/11/06 22:14:24  mtg9625
 *     Checks if a player has won and displays message
 *     Resign button works and ends game
 *
 *     Revision 1.3  2005/11/06 19:38:46  pjk7060
 *     worked many bugs out of networking
 *
 *     Revision 1.2  2005/11/05 17:30:28  pjk7060
 *     moved KING, SINGLE, BLUE, and WHITE out of other classes
 *
 *     Revision 1.1  2005/11/04 04:05:37  pjk7060
 *     Created Global Constants interface
 *
 *     Further development on controller, and initial game setup
 *
 */
package checkers;

/**
 * Constant variables used to identify actions.
 *
 * @author Peter Kuhn
 */
public interface CheckersConstants {
	
	// These are used by the GUI and the NetworkView to make sure that they 
	// are all sending the same updates.
	
	public static final String UPDATE = "update";
	
	public static final String DRAW = "draw";
	
	public static final String ACCEPT = "accept";
		
	public static final String RESIGN = "resign";
	
	public static final String PLAYER1SET = "player1set";
	
	public static final String PLAYER2SET = "player2set";
	
	public static final String LOCAL = "local";
	
	public static final int LOCALGAME = 0;
	
	public static final String HOST = "host";
	
	public static final int HOSTGAME = 1;
	
	public static final String JOIN = "join";
	
	public static final int CLIENTGAME = 2;
	
	public static final int WHITE = 0;

	public static final int BLUE = 1;
	
	public static final int SINGLE = 0;

	public static final int KING = 1;
	
	public static final int NUM_SPACES = 32;
	
}
