package checkers;

import checkers.controller.GameController;
import checkers.model.Board;
import checkers.model.CheckersGame;
import checkers.model.Rules;
import checkers.view.CheckerGUI;
import checkers.view.Firstscreen;
import checkers.view.NetworkView;
import checkers.view.Secondscreen;

/*

 * PlayCheckers.java

 *

 * 

 * Version:

 *   $Id: PlayCheckers.java,v 1.8 2005/11/08 23:02:09 pjk7060 Exp $

 *

 * Revisions:

 *   $Log: PlayCheckers.java,v $
 *   Revision 1.8  2005/11/08 23:02:09  pjk7060
 *   comments
 *
 *   Revision 1.7  2005/11/06 21:52:15  pjk7060
 *   fixed network play colors not being assigned correctly
 *
 *   Revision 1.6  2005/11/05 17:42:08  pjk7060
 *   working on update, displays pieces and current turn
 *
 *   Revision 1.5  2005/11/05 15:35:31  pjk7060
 *   Little fixes
 *
 *   Revision 1.4  2005/11/04 15:59:42  pjk7060
 *   *** empty log message ***
 *
 *   Revision 1.3  2005/11/04 15:50:16  pjk7060
 *   Fixed registering of components with proper observers, and proper references
 *
 *   Revision 1.2  2005/11/02 04:34:04  pjk7060
 *   moved classes into the proper packages
 *
 *   Revision 1.1  2005/11/02 04:31:20  pjk7060
 *   split everything into packages
 *
 *   implemented the networking class
 *
 *   Revision 1.3  2005/10/29 14:22:31  jmr1040
 *   Fixed formatting (so we can see all nesting)
 *
 *   Revision 1.2  2005/10/29 14:16:12  jmr1040
 *   Renamed Driver and Facade to match purpose
 *
 *   Revision 1.1  2005/10/20 13:53:36  jmr1040
 *   Initial state of Checkers project
 *
 *   Revision 1.1  2002/10/22 21:12:53  se362
 *   Initial creation of case study
 *
 */

/**
 * 
 * The main class to run the game. It creates the driver and first screen
 * 
 * @author
 * 
 */
class PlayCheckers {

	/**
	 * The main method to play checkers
	 * 
	 * @param args[] the command line arguments
	 * 
	 */
	public static void main(String args[]) {
		
		// create the board
		Board board = new Board();
		
		// tell the rules about the board
		Rules.getInstance().setBoard(board);
		
		// create the game
		CheckersGame theGame = new CheckersGame(board);
		// have it randomly select the colors of the players
		theGame.selectColors();
		
		// create the controller
		GameController controller = new GameController(theGame);
	
		// create the gui and add its observers
		CheckerGUI gui = new CheckerGUI(controller, board);
		theGame.addObserver(gui);
		board.addObserver(gui);
		
		// create the netview, it won't be registered to observers unless
		// it is a network game
		NetworkView netView = new NetworkView(theGame, board, theGame.getPlayerColor(0));
		netView.addActionListener(controller);
		
		// create the screens
		Firstscreen first = new Firstscreen(controller);
		Secondscreen second = new Secondscreen(controller, first, gui, netView);
		
		// tell the firstscreen about the second screen so it can display it
		first.setSecondScreen(second);
		
		// show the first screen, and we're off!
		first.setVisible(true);
		

	}

}// PlayCheckers
