package checkers.model;

import java.io.Serializable;

/**
 * Move.java
 *
 * Version:
 *    $Id: Move.java,v 1.8 2005/11/08 23:02:09 pjk7060 Exp $
 *
 * Revisions:
 *    $Log: Move.java,v $
 *    Revision 1.8  2005/11/08 23:02:09  pjk7060
 *    comments
 *
 *    Revision 1.7  2005/11/08 22:37:00  pjk7060
 *    removed unused timer code
 *
 *    fixed warnings
 *
 *    Revision 1.6  2005/11/06 19:38:46  pjk7060
 *    worked many bugs out of networking
 *
 *    Revision 1.5  2005/11/05 18:42:19  pjk7060
 *    fixed jumps
 *
 *    Revision 1.4  2005/11/05 15:35:32  pjk7060
 *    Little fixes
 *
 *    Revision 1.3  2005/11/04 14:46:12  pjk7060
 *    removed player from move
 *
 *    Revision 1.2  2005/11/04 14:17:09  pjk7060
 *    added validate(), isJump(), and getJumpIndex()
 *
 *    needs appropriate method in rules to return
 *
 *    Revision 1.1  2005/11/02 04:34:05  pjk7060
 *    moved classes into the proper packages
 *
 *    Revision 1.1  2005/11/02 04:31:20  pjk7060
 *    split everything into packages
 *
 *    implemented the networking class
 *
 *    Revision 1.2  2005/10/29 14:22:31  jmr1040
 *    Fixed formatting (so we can see all nesting)
 *
 *    Revision 1.1  2005/10/20 13:53:35  jmr1040
 *    Initial state of Checkers project
 *
 *    Revision 1.1  2002/10/22 21:12:52  se362
 *    Initial creation of case study
 *
 */


/**
 * An object representation of a move.
 * 
 * @author
 */
public class Move implements Serializable {

	// eclipse stuff
	private static final long serialVersionUID = 1L;

	private int startingLocation; // the starting location

	private int endingLocation; // the ending location

	/**
	 * Create a move with the starting location and ending location passed in as
	 * paremeters.
	 * 
	 * @param startLoc
	 *            The starting point of the move
	 * @param endLoc
	 *            The ending point of the move
	 * 
	 * @pre startLoc and endLoc are valid locations
	 */
	public Move(int startLoc, int endLoc) {
		startingLocation = startLoc;
		endingLocation = endLoc;
	}

	/**
	 * Return the starting location of this move.
	 * 
	 * @return The starting point of the move.
	 * 
	 * @post nothing has changed
	 */
	public int startLocation() {

		return startingLocation;
	}

	/**
	 * Return the ending location of this move.
	 * 
	 * @return The ending point of this location.
	 * 
	 * @post Nothing has changed
	 */
	public int endLocation() {

		return endingLocation;
	}
	
	/**
	 * Returns true if the move is valid.
	 * 
	 * @return valid
	 */
	public boolean validate(){
		return Rules.getInstance().validateMove(this);
	}
	
	/**
	 * Returns true if the move is a jump.
	 * 
	 * @return jump
	 */
	public boolean isJump(){		
		return Rules.getInstance().isJump(startingLocation, endingLocation);
	}
	
	/**
	 * If the move is a jump, returns the index of the jumped piece.
	 * 
	 * @return index
	 */
	public int getJumpIndex(){
		return Rules.getInstance().getJumpIndex();
	}
	
	/**
	 * String representation of move
	 */
	public String toString(){
		return startingLocation + " " + endingLocation;
	}

} // Move.java
