/*
 * NetPacket.java
 *
 * Version:
 *     $Id: NetPacket.java,v 1.4 2005/11/08 23:02:09 pjk7060 Exp $
 *
 * Revisions:
 *     $Log: NetPacket.java,v $
 *     Revision 1.4  2005/11/08 23:02:09  pjk7060
 *     comments
 *
 *     Revision 1.3  2005/11/06 21:52:15  pjk7060
 *     fixed network play colors not being assigned correctly
 *
 *     Revision 1.2  2005/11/06 19:38:46  pjk7060
 *     worked many bugs out of networking
 *
 *     Revision 1.1  2005/11/02 04:34:05  pjk7060
 *     moved classes into the proper packages
 *
 *     Revision 1.1  2005/11/02 04:31:20  pjk7060
 *     split everything into packages
 *
 *     implemented the networking class
 *
 */
package checkers.model;

import java.io.Serializable;


/**
 * Data Packet to be sent over the network.
 *
 * @author Peter Kuhn
 */
public class NetPacket implements Serializable {
	
	// eclipse stuff
	private static final long serialVersionUID = 1L;

	// true if the player offered a draw
	private boolean draw = false;
	
	// true if the player resigned
	private boolean resign = false;
	
	// move that the player just executed
	private Move move = null;
	
	// player1 name
	private String player1;
	
	// player2 name
	private String player2;
	
	// player1's color
	private int player1Color = -1;
	
	public String toString(){
		// value to be returned, duh.
		String retVal = "";
		
		if (isDraw()){
			retVal += "Draw Offered|";
		}else if (isResign()){
			retVal += "Resigned|";
		}else if (getMove() != null){
			retVal += "Move: " + getMove().toString() + "|";
		}else if (getPlayer1() != null){
			retVal += "Player 1 Name: " + getPlayer1() + "|";
		}else if (getPlayer2() != null){
			retVal += "Player 2 Name: " + getPlayer2() + "|";
		}else if (getPlayer1Color() != -1){
			retVal += "Player 1 Color: " + getPlayer1Color() + "|";
		}
		
		return retVal.substring(0, retVal.length()-1);
	}

	/**
	 * @return Returns the draw.
	 */
	public boolean isDraw() {
		return draw;
	}

	/**
	 * @param draw The draw to set.
	 */
	public void setDraw(boolean draw) {
		this.draw = draw;
	}

	/**
	 * @return Returns the move.
	 */
	public Move getMove() {
		return move;
	}

	/**
	 * @param move The move to set.
	 */
	public void setMove(Move move) {
		this.move = move;
	}

	/**
	 * @return Returns the resign.
	 */
	public boolean isResign() {
		return resign;
	}

	/**
	 * @param resign The resign to set.
	 */
	public void setResign(boolean resign) {
		this.resign = resign;
	}
	
	/**
	 * @return Returns the player1.
	 */
	public String getPlayer1() {
		return player1;
	}

	/**
	 * @param player1 The player1 to set.
	 */
	public void setPlayer1(String player1) {
		this.player1 = player1;
	}

	/**
	 * @return Returns the player2.
	 */
	public String getPlayer2() {
		return player2;
	}

	/**
	 * @param player2 The player2 to set.
	 */
	public void setPlayer2(String player2) {
		this.player2 = player2;
	}
	
	/**
	 * @return Returns the player1Color.
	 */
	public int getPlayer1Color() {
		return player1Color;
	}

	/**
	 * @param player1Color The player1Color to set.
	 */
	public void setPlayer1Color(int player1Color) {
		this.player1Color = player1Color;
	}
}
