package checkers.model;

/*
 * Piece.java
 *
 * Version:
 *   $Id: Piece.java,v 1.4 2005/11/05 17:42:09 pjk7060 Exp $
 *
 * Revisions:
 *   $Log: Piece.java,v $
 *   Revision 1.4  2005/11/05 17:42:09  pjk7060
 *   working on update, displays pieces and current turn
 *
 *   Revision 1.3  2005/11/03 01:31:31  jmr1040
 *   Removed SinglePiece and KingPiece
 *   de-abstracted Piece
 *
 *   Revision 1.1  2005/11/02 04:34:05  pjk7060
 *   moved classes into the proper packages
 *
 *   Revision 1.1  2005/11/02 04:31:20  pjk7060
 *   split everything into packages
 *
 *   implemented the networking class
 *
 *   Revision 1.2  2005/10/29 14:22:31  jmr1040
 *   Fixed formatting (so we can see all nesting)
 *
 *   Revision 1.1  2005/10/20 13:53:36  jmr1040
 *   Initial state of Checkers project
 *
 *   Revision 1.1  2002/10/22 21:12:53  se362
 *   Initial creation of case study
 *
 */

/**
 * This is an abstract class representing any piece that know about it's color
 * and possible moves and captures
 * 
 * @author Jeremy Ryan
 * 
 */
public class Piece {

	private int color; // the color of the piece

	private int type; // type of the piece (SINGLE or KING)

	/**
	 * The constructor for this piece
	 * 
	 * @param c
	 *            the color for this piece (as defined by constants Piece.WHITE
	 *            and Piece.BLUE)
	 * @param t
	 *            Type of the piece (as defined by constants Piece.SINGLE and
	 *            Piece.KING)
	 */
	public Piece(int c, int t) {

		// set the color
		this.color = c;
		this.type = t;
	}

	/**
	 * Returns the type of the piece
	 * 
	 * @return the type of the piece
	 */
	public int getType() {
		return type;
	}

	/**
	 * This method returns the color of this piece
	 * 
	 * @return the color for this piece
	 */
	public int getColor() {
		return color;
	}

	/**
	 * Sets the Piece's type (SINGLE or KING)
	 * 
	 * @param t
	 *            Type for this piece
	 */
	public void setType(int t) {
		this.type = t;
	}

}// Piece
