/*
 * Decompiled with CFR 0.152.
 */
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.util.Utilities;
import java.net.Socket;
import java.util.Vector;

public class FreeTTSEmacspeakHandler
extends EmacspeakProtocolHandler {
    private SpeakCommandHandler speakCommandHandler;

    public FreeTTSEmacspeakHandler(Socket socket, Voice voice) {
        this.setSocket(socket);
        this.speakCommandHandler = new SpeakCommandHandler(voice);
        this.speakCommandHandler.start();
        this.setDebug(Utilities.getBoolean("debug"));
    }

    public void speak(String input) {
        String[] parts = input.split("[.]*\\[\\*\\][.]*");
        for (int i = 0; i < parts.length; ++i) {
            this.speakCommandHandler.add(parts[i]);
        }
    }

    public void cancelAll() {
        this.speakCommandHandler.removeAll();
    }

    public void setRate(float wpm) {
        this.speakCommandHandler.setRate(wpm);
    }

    class SpeakCommandHandler
    extends Thread {
        private Voice voice;
        private boolean done = false;
        private Vector commandList = new Vector();

        public SpeakCommandHandler(Voice voice) {
            this.voice = voice;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!FreeTTSEmacspeakHandler.this.getSocket().isClosed() || this.commandList.size() > 0) {
                Object firstCommand = null;
                Vector vector = this.commandList;
                synchronized (vector) {
                    while (this.commandList.size() == 0 && !FreeTTSEmacspeakHandler.this.getSocket().isClosed()) {
                        try {
                            this.commandList.wait();
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace();
                        }
                    }
                    if (this.commandList.size() > 0) {
                        firstCommand = this.commandList.remove(0);
                    }
                }
                if (firstCommand == null) continue;
                this.voice.speak((String)firstCommand);
                FreeTTSEmacspeakHandler.this.debugPrintln("SPEAK: \"" + firstCommand + "\"");
            }
            FreeTTSEmacspeakHandler.this.debugPrintln("SpeakCommandHandler: thread terminated");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String command) {
            Vector vector = this.commandList;
            synchronized (vector) {
                this.commandList.add(command);
                this.commandList.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll() {
            Vector vector = this.commandList;
            synchronized (vector) {
                this.voice.getAudioPlayer().cancel();
                this.commandList.removeAllElements();
            }
        }

        public void setRate(float wpm) {
            this.voice.setRate(wpm);
        }

        public synchronized void setDone(boolean done) {
            this.done = done;
        }
    }
}

