/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public abstract class Clock
extends JFrame {
    private JLabel timeLabel;
    private JCheckBox announceCheckBox;
    private JTextField intervalTextField;
    private int timeFontSize = 24;
    private GregorianCalendar calendar;
    private SimpleDateFormat dateFormat;
    private long lastSpeakTime;
    private int speakInterval = 300000;
    private int sleepTime = 5000;
    private static char announceMnemonic = (char)65;
    private static char minutesMnemonic = (char)77;
    private static char speakMnemonic = (char)83;
    private boolean debug = true;

    public Clock() {
        super("FreeTTS Clock");
        this.setDefaultCloseOperation(3);
        JPanel timePanel = new JPanel(new BorderLayout());
        timePanel.setAlignmentY(0.5f);
        this.timeLabel = new JLabel("Loading...", 0);
        Font oldFont = this.timeLabel.getFont();
        this.timeLabel.setFont(new Font(oldFont.getFontName(), oldFont.getStyle(), this.timeFontSize));
        timePanel.add((Component)this.timeLabel, "Center");
        timePanel.add((Component)this.createAnnouncePanel(), "South");
        this.getContentPane().add((Component)timePanel, "Center");
        JButton speakButton = new JButton("Speak");
        speakButton.setMnemonic(speakMnemonic);
        speakButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Runnable speaker = new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Clock.access$100(1.access$000(this.this$1));
                    }
                };
                new Thread(speaker).start();
            }

            static /* synthetic */ Clock access$000(1 x0) {
                return x0.Clock.this;
            }
        });
        this.getContentPane().add((Component)speakButton, "South");
        this.createCalendar();
    }

    public void startClock() {
        ClockThread clock = new ClockThread();
        clock.start();
    }

    private JPanel createAnnouncePanel() {
        JPanel announcePanel = new JPanel(new FlowLayout());
        this.announceCheckBox = new JCheckBox("announce every", true);
        this.announceCheckBox.setMnemonic(announceMnemonic);
        this.announceCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    Clock.this.lastSpeakTime = Clock.this.calendar.getTimeInMillis();
                    Clock.this.debugPrintln("Last speak time: " + String.valueOf(Clock.this.lastSpeakTime));
                }
            }
        });
        this.intervalTextField = new JTextField("5", 3);
        this.intervalTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String text = Clock.this.intervalTextField.getText();
                if (text.matches("[1-9][0-9]*")) {
                    Clock.this.debugPrintln("New announce interval : " + text);
                    Clock.this.speakInterval = Integer.parseInt(text) * 60000;
                } else {
                    Clock.this.debugPrintln("Invalid minutes input: " + text);
                    Clock.this.intervalTextField.setText(String.valueOf(Clock.this.speakInterval / 60000));
                }
            }
        });
        JLabel minutesLabel = new JLabel("mins");
        minutesLabel.setDisplayedMnemonic(minutesMnemonic);
        minutesLabel.setLabelFor(this.intervalTextField);
        announcePanel.add(this.announceCheckBox);
        announcePanel.add(this.intervalTextField);
        announcePanel.add(minutesLabel);
        return announcePanel;
    }

    public abstract void createSynthesizer();

    protected abstract void speak(String var1);

    private void createCalendar() {
        this.calendar = new GregorianCalendar();
        this.dateFormat = new SimpleDateFormat("h:mm a");
        this.dateFormat.setCalendar(this.calendar);
    }

    private void setTimeLabel(final String time) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Clock.this.timeLabel.setText(time);
            }
        });
    }

    private void updateTime() {
        Date currentTime = new Date();
        this.calendar.setTime(currentTime);
        this.setTimeLabel(this.dateFormat.format(currentTime));
    }

    private void speakTime() {
        this.lastSpeakTime = this.calendar.getTimeInMillis();
        int hour = this.calendar.get(11);
        int min = this.calendar.get(12);
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Bad time format: hour");
        }
        if (min < 0 || min > 59) {
            throw new IllegalArgumentException("Bad time format: min");
        }
        String theTime = TimeUtils.timeToString(hour, min);
        this.speak(theTime);
    }

    private boolean isTimeToSpeak() {
        return this.lastSpeakTime + (long)this.speakInterval < this.calendar.getTimeInMillis();
    }

    private void debugPrintln(String line) {
        if (this.debug) {
            System.out.println(line);
        }
    }

    class ClockThread
    extends Thread {
        ClockThread() {
        }

        public void run() {
            while (true) {
                Clock.this.updateTime();
                if (Clock.this.announceCheckBox.isSelected() && Clock.this.isTimeToSpeak()) {
                    Clock.this.speakTime();
                }
                try {
                    Thread.sleep(Clock.this.sleepTime);
                    continue;
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

