/*
 * Decompiled with CFR 0.152.
 */
import java.util.regex.Pattern;

public class TimeUtils {
    private static String timeApprox(int hour, int min) {
        int mm = min % 5;
        if (mm == 0) {
            return "exactly";
        }
        if (mm == 1) {
            return "just after";
        }
        if (mm == 2) {
            return "a little after";
        }
        return "almost";
    }

    private static String timeMin(int hour, int min) {
        int mm = min / 5;
        if (min % 5 > 2) {
            ++mm;
        }
        if ((mm *= 5) > 55) {
            mm = 0;
        }
        if (mm == 0) {
            return "";
        }
        if (mm == 5) {
            return "five past";
        }
        if (mm == 10) {
            return "ten past";
        }
        if (mm == 15) {
            return "quarter past";
        }
        if (mm == 20) {
            return "twenty past";
        }
        if (mm == 25) {
            return "twenty-five past";
        }
        if (mm == 30) {
            return "half past";
        }
        if (mm == 35) {
            return "twenty-five to";
        }
        if (mm == 40) {
            return "twenty to";
        }
        if (mm == 45) {
            return "quarter to";
        }
        if (mm == 50) {
            return "ten to";
        }
        if (mm == 55) {
            return "five to";
        }
        return "five to";
    }

    private static String timeHour(int hour, int min) {
        int hh = hour;
        if (min > 32) {
            ++hh;
        }
        if (hh == 24) {
            hh = 0;
        }
        if (hh > 12) {
            hh -= 12;
        }
        if (hh == 0) {
            return "midnight";
        }
        if (hh == 1) {
            return "one";
        }
        if (hh == 2) {
            return "two";
        }
        if (hh == 3) {
            return "three";
        }
        if (hh == 4) {
            return "four";
        }
        if (hh == 5) {
            return "five";
        }
        if (hh == 6) {
            return "six";
        }
        if (hh == 7) {
            return "seven";
        }
        if (hh == 8) {
            return "eight";
        }
        if (hh == 9) {
            return "nine";
        }
        if (hh == 10) {
            return "ten";
        }
        if (hh == 11) {
            return "eleven";
        }
        if (hh == 12) {
            return "twelve";
        }
        return "twelve";
    }

    private static String timeOfDay(int hour, int min) {
        int hh = hour;
        if (min > 58) {
            ++hh;
        }
        if (hh == 24) {
            return "";
        }
        if (hh > 17) {
            return "in the evening";
        }
        if (hh > 11) {
            return "in the afternoon";
        }
        if (hh == 0 && min < 33) {
            return "";
        }
        return "in the morning";
    }

    public static String timeToString(String time) {
        String theTime = null;
        if (Pattern.matches("[012][0-9]:[0-5][0-9]", time)) {
            int hour = Integer.parseInt(time.substring(0, 2));
            int min = Integer.parseInt(time.substring(3));
            theTime = TimeUtils.timeToString(hour, min);
        }
        return theTime;
    }

    public static String timeToString(int hour, int min) {
        String theTime = "The time is now, " + TimeUtils.timeApprox(hour, min) + " " + TimeUtils.timeMin(hour, min) + " " + TimeUtils.timeHour(hour, min) + ", " + TimeUtils.timeOfDay(hour, min) + ".";
        return theTime;
    }
}

