/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.speech.Central;
import javax.speech.EngineException;
import javax.speech.EngineList;
import javax.speech.EngineModeDesc;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.Voice;

public class JTime {
    Synthesizer synthesizer;

    private static String noSynthesizerMessage() {
        String message = "No synthesizer created.  This may be the result of any\nnumber of problems.  It's typically due to a missing\n\"speech.properties\" file that should be at either of\nthese locations: \n\n";
        message = message + "user.home    : " + System.getProperty("user.home") + "\n";
        message = message + "java.home/lib: " + System.getProperty("java.home") + File.separator + "lib\n\n" + "Another cause of this problem might be corrupt or missing\n" + "voice jar files in the freetts lib directory.  This problem\n" + "also sometimes arises when the freetts.jar file is corrupt\n" + "or missing.  Sorry about that.  Please check for these\n" + "various conditions and then try again.\n";
        return message;
    }

    public static void listAllVoices(String modeName) {
        System.out.println();
        System.out.println("All " + modeName + " Mode JSAPI Synthesizers and Voices:");
        SynthesizerModeDesc required = new SynthesizerModeDesc(null, modeName, Locale.US, null, null);
        EngineList engineList = Central.availableSynthesizers((EngineModeDesc)required);
        for (int i = 0; i < engineList.size(); ++i) {
            SynthesizerModeDesc desc = (SynthesizerModeDesc)engineList.get(i);
            System.out.println("    " + desc.getEngineName() + " (mode=" + desc.getModeName() + ", locale=" + desc.getLocale() + "):");
            Voice[] voices = desc.getVoices();
            for (int j = 0; j < voices.length; ++j) {
                System.out.println("        " + voices[j].getName());
            }
        }
    }

    public JTime(String voiceName) {
        try {
            SynthesizerModeDesc desc = new SynthesizerModeDesc(null, "time", Locale.US, null, null);
            this.synthesizer = Central.createSynthesizer((EngineModeDesc)desc);
            if (this.synthesizer == null) {
                System.err.println(JTime.noSynthesizerMessage());
                System.exit(1);
            }
            this.synthesizer.allocate();
            this.synthesizer.resume();
            desc = (SynthesizerModeDesc)this.synthesizer.getEngineModeDesc();
            Voice[] voices = desc.getVoices();
            Voice voice = null;
            for (int i = 0; i < voices.length; ++i) {
                if (!voices[i].getName().equals(voiceName)) continue;
                voice = voices[i];
                break;
            }
            if (voice == null) {
                System.err.println("Synthesizer does not have a voice named " + voiceName + ".");
                System.exit(1);
            }
            this.synthesizer.getSynthesizerProperties().setVoice(voice);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void interactiveMode() {
        try {
            while (true) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Enter time (HH:MM): ");
                System.out.flush();
                String text = reader.readLine();
                if (text != null && text.length() != 0) {
                    this.timeToSpeech(text);
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void timeToSpeech(String time) {
        String theTime = TimeUtils.timeToString(time);
        if (theTime != null) {
            this.synthesizer.speakPlainText(theTime, null);
        } else {
            System.out.println("Bad time format. The format should be HH:MM");
        }
    }

    public void timeToSpeech(int hour, int min) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Bad time format: hour");
        }
        if (min < 0 || min > 59) {
            throw new IllegalArgumentException("Bad time format: min");
        }
        String theTime = TimeUtils.timeToString(hour, min);
        this.synthesizer.speakPlainText(theTime, null);
    }

    public void safeTimeToSpeech(String time) {
        try {
            if (time.equals("now")) {
                this.speakNow();
            } else {
                this.timeToSpeech(time);
            }
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Bad time format");
        }
    }

    public void speakNow() {
        long now = System.currentTimeMillis();
        GregorianCalendar cal = new GregorianCalendar();
        int hour = cal.get(11);
        int min = cal.get(12);
        this.timeToSpeech(hour, min);
    }

    public void close() {
        try {
            this.synthesizer.deallocate();
        }
        catch (EngineException ee) {
            System.out.println("Trouble deallocating synthesizer: " + (Object)((Object)ee));
        }
    }

    public static void main(String[] args) {
        JTime.listAllVoices("time");
        String voiceName = args.length > 0 ? args[0] : "alan";
        System.out.println();
        System.out.println("Using voice: " + voiceName);
        try {
            JTime jtime = new JTime(voiceName);
            jtime.speakNow();
            jtime.interactiveMode();
            jtime.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

