/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class AccountCaveUI
extends Observable
implements Displayable,
ActionListener {
    private static final int FRAME_SIZE_X = 400;
    private static final int FRAME_SIZE_Y = 400;
    private static final int PASS_PREF_SIZE_X = 130;
    private static final int PASS_PREF_SIZE_Y = 24;
    private static final int TEXTBOX_PREF_SIZE_X = 200;
    private JFrame mamaFrame;
    private BackgroundPanel mainPanel;
    private Image playerImage;
    private Report studReport;
    private boolean ownFrame;
    Student stu;
    JPasswordField t1;
    JPasswordField t2;
    JPasswordField t3;

    public AccountCaveUI(Student stud, Image playerAvatar) {
        this.studReport = stud.getReport();
        this.stu = stud;
        ImageIcon caveImg = new ImageIcon("images/cave.gif");
        this.mainPanel = new BackgroundPanel((LayoutManager)new BorderLayout(), caveImg.getImage());
        JPanel lowerPanel = new JPanel();
        lowerPanel.setOpaque(false);
        ImageIcon icon = new ImageIcon(playerAvatar);
        JLabel playerImage = new JLabel(icon);
        JButton exitButton = new JButton("Exit Cave");
        exitButton.addActionListener(this);
        lowerPanel.add(playerImage);
        lowerPanel.add(exitButton);
        JPanel subPanel = new JPanel(new GridLayout(7, 0));
        subPanel.setOpaque(false);
        JPanel namePanel = new JPanel(new FlowLayout(0));
        namePanel.setOpaque(false);
        JLabel nameLabel = new JLabel("Name :  ");
        nameLabel.setForeground(Color.WHITE);
        JLabel nameText = new JLabel(stud.getName());
        nameText.setForeground(Color.WHITE);
        namePanel.add(nameLabel);
        namePanel.add(nameText);
        JLabel teachPanel = new JLabel("Teacher :  " + stud.getTeacher().getName());
        teachPanel.setForeground(Color.WHITE);
        JLabel goldPanel = new JLabel("Gold : $" + stud.getMoney());
        goldPanel.setForeground(Color.WHITE);
        JPanel buttPanel = new JPanel();
        buttPanel.setOpaque(false);
        JButton passButton = new JButton("Change Password");
        JButton reportButton = new JButton("View Report");
        passButton.addActionListener(this);
        reportButton.addActionListener(this);
        buttPanel.add(passButton);
        buttPanel.add(reportButton);
        JPanel passSub1 = new JPanel(new FlowLayout(0));
        passSub1.setOpaque(false);
        JLabel l1 = new JLabel("Old Password");
        l1.setForeground(Color.WHITE);
        l1.setPreferredSize(new Dimension(130, 24));
        this.t1 = new JPasswordField();
        this.t1.setPreferredSize(new Dimension(200, 24));
        passSub1.add(l1);
        passSub1.add(this.t1);
        JPanel passSub2 = new JPanel(new FlowLayout(0));
        passSub2.setOpaque(false);
        JLabel l2 = new JLabel("New Password");
        l2.setForeground(Color.WHITE);
        l2.setPreferredSize(new Dimension(130, 24));
        this.t2 = new JPasswordField();
        this.t2.setPreferredSize(new Dimension(200, 24));
        passSub2.add(l2);
        passSub2.add(this.t2);
        JPanel passSub3 = new JPanel(new FlowLayout(0));
        passSub3.setOpaque(false);
        JLabel l3 = new JLabel("New Password Again");
        l3.setForeground(Color.WHITE);
        l3.setPreferredSize(new Dimension(130, 24));
        this.t3 = new JPasswordField();
        this.t3.setPreferredSize(new Dimension(200, 24));
        passSub3.add(l3);
        passSub3.add(this.t3);
        subPanel.add(namePanel);
        subPanel.add(teachPanel);
        subPanel.add(goldPanel);
        subPanel.add(passSub1);
        subPanel.add(passSub2);
        subPanel.add(passSub3);
        subPanel.add(buttPanel);
        this.mainPanel.add((Component)lowerPanel, "South");
        this.mainPanel.add((Component)subPanel, "Center");
    }

    public void displayInterface() {
        this.ownFrame = true;
        this.mamaFrame = new JFrame(String.valueOf(this.stu.getName()) + "'s Account Cave");
        this.mamaFrame.setDefaultCloseOperation(0);
        this.mamaFrame.setSize(400, 400);
        this.mamaFrame.getContentPane().add(this.mainPanel);
        this.mamaFrame.setVisible(true);
    }

    public JPanel getDisplay() {
        return this.mainPanel;
    }

    public void actionPerformed(ActionEvent e) {
        String buttonHit = e.getActionCommand();
        if (buttonHit.equals("Change Password")) {
            JFrame frameToUse = null;
            if (this.ownFrame) {
                frameToUse = this.mamaFrame;
            }
            if (this.t2.getText().equals(this.t3.getText())) {
                if (this.t1.getText().equals(this.stu.getPassword())) {
                    this.stu.setPassword(this.t2.getText());
                    JOptionPane.showMessageDialog(frameToUse, "Password Changed Successfully!", "Success!", 1);
                } else {
                    JOptionPane.showMessageDialog(frameToUse, "Old Password does not match", "Error", 0);
                }
            } else {
                JOptionPane.showMessageDialog(frameToUse, "Passwords do not match", "Error", 0);
            }
        }
        if (buttonHit.equals("View Report")) {
            JDialog report;
            if (this.ownFrame) {
                report = new JDialog((Frame)this.mamaFrame, true);
            } else {
                JComponent source = (JComponent)e.getSource();
                while (!(source.getParent() instanceof JFrame)) {
                    source = (JComponent)source.getParent();
                }
                report = new JDialog((Frame)((JFrame)source.getParent()), true);
            }
            report.setDefaultCloseOperation(2);
            report.getContentPane().add(new ReportUI(this.studReport));
            report.setSize(520, 549);
            report.setVisible(true);
        }
        if (buttonHit.equals("Exit Cave")) {
            if (this.ownFrame) {
                this.mamaFrame.dispose();
            } else {
                Container source = (Container)e.getSource();
                while (!(source.getParent() instanceof JFrame)) {
                    source = source.getParent();
                }
                JFrame masterFrame = (JFrame)source.getParent();
                masterFrame.dispose();
            }
            this.setChanged();
            this.notifyObservers(null);
        }
    }

    public static void main(String[] args) {
        Student moron = new Student("btg666", "Bill Twanger Gates", "mycrowsoft");
        moron.setTeacher(new Teacher("jul342", "Jane Undine Loodi", "youfailit"));
        ImageIcon tehIc = new ImageIcon("images/avatars/0d.gif");
        Image tehIm = tehIc.getImage();
        AccountCaveUI tester = new AccountCaveUI(moron, tehIm);
        if (args.length == 0 || args[0].equals("0")) {
            tester.displayInterface();
        } else {
            JFrame tehFrame = new JFrame("It's a cave");
            tehFrame.setSize(400, 300);
            tehFrame.setDefaultCloseOperation(3);
            tehFrame.getContentPane().add(tester.getDisplay());
            tehFrame.setVisible(true);
        }
    }
}

