/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AdminUI
extends TeacherGUI {
    private Admin me;
    private Panel admin = new Panel();
    DefaultListModel userModel = new DefaultListModel();
    JList userList = new JList(this.userModel);
    JScrollPane userListScroll = new JScrollPane(this.userList);
    List users;
    JButton deleteButton = new JButton("Delete User");
    JButton refreshButton = new JButton("Refresh");
    JButton createStudentButton = new JButton("Create New Student");
    JButton createTeacherButton = new JButton("Create New Teacher");

    public AdminUI(Admin a) {
        this.me = a;
        this.originalUser = a;
        this.teacherCB = new JComboBox();
        this.teacherCB.addActionListener(this);
        this.refreshCB();
    }

    public AdminUI() {
    }

    public void display() {
        this.admin.setLayout(new BorderLayout());
        JPanel createPanel = new JPanel();
        createPanel.add(this.createStudentButton);
        this.createStudentButton.addActionListener(this);
        createPanel.add(this.createTeacherButton);
        this.createTeacherButton.addActionListener(this);
        JPanel usersPanel = new JPanel();
        usersPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Modify Users"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        usersPanel.setLayout(new BoxLayout(usersPanel, 2));
        usersPanel.add(Box.createHorizontalStrut(200));
        this.userListScroll.setMaximumSize(new Dimension(300, 300));
        this.userListScroll.setPreferredSize(new Dimension(300, 300));
        usersPanel.add(this.userListScroll);
        usersPanel.add(Box.createHorizontalStrut(50));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 3));
        buttonsPanel.add((Component)this.deleteButton, "North");
        buttonsPanel.add(Box.createVerticalStrut(50));
        this.refreshButton.addActionListener(this);
        buttonsPanel.add((Component)this.refreshButton, "South");
        usersPanel.add(buttonsPanel);
        usersPanel.add(Box.createHorizontalStrut(200));
        this.deleteButton.addActionListener(this);
        this.admin.add((Component)usersPanel, "Center");
        this.admin.add((Component)createPanel, "South");
        super.display();
        this.tab.add("Admin", this.admin);
        this.refreshUserList();
    }

    public void refreshUserList() {
        this.userModel.clear();
        this.users = Client.requestAllUsers();
        if (this.users != null) {
            Iterator it = this.users.iterator();
            while (it.hasNext()) {
                User itu = (User)it.next();
                this.userModel.addElement(itu.getName());
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        JDialog d = null;
        if (e.getSource() == this.createStudentButton) {
            d = new JDialog((Frame)this.frame, true);
            d.setTitle("Create New Student");
            d.setSize(300, 300);
            d.setDefaultCloseOperation(2);
            d.getContentPane().setLayout(new FlowLayout());
            d.getContentPane().add(new createUserUI(1, this.teacherList));
            d.setVisible(true);
        } else if (e.getSource() == this.createTeacherButton) {
            d = new JDialog((Frame)this.frame, true);
            d.setTitle("Create New Teacher");
            d.setSize(300, 300);
            d.setDefaultCloseOperation(2);
            d.getContentPane().setLayout(new FlowLayout());
            d.getContentPane().add(new createUserUI(0, this.teacherList));
            d.setVisible(true);
        } else if (e.getSource() == this.refreshButton) {
            this.refreshUserList();
        } else if (e.getSource() == this.deleteButton) {
            System.out.println("Delete");
            int index = this.userList.getSelectedIndex();
            User torem = (User)this.users.get(index);
            if (torem instanceof Student) {
                Student stutorem = (Student)torem;
                if (stutorem.getTeacher() != null) {
                    stutorem.getTeacher().removeStudent(stutorem);
                    Client.sendUserUpdate(stutorem.getTeacher());
                    this.teacherList = Client.requestTeacherList();
                }
                Client.removeUser(stutorem.getUserName());
                this.teacherCB.setSelectedIndex(this.teacherCurSel);
            } else if (torem instanceof Teacher) {
                Teacher teatorem = (Teacher)torem;
                List stuList = teatorem.getStudents();
                this.teacherList.remove(teatorem);
                Client.removeUser(teatorem.getUserName());
                if (Client.exists(String.valueOf(teatorem.getUserName()) + "-sub")) {
                    Client.removeUser(String.valueOf(teatorem.getUserName()) + "-sub");
                }
                int i = 0;
                while (i < stuList.size()) {
                    Student temp2 = (Student)stuList.get(i);
                    temp2.setTeacher(null);
                    Client.sendUserUpdate(temp2);
                    ++i;
                }
                try {
                    this.u = (Teacher)this.teacherList.get(0);
                    this.teacherCB.setSelectedIndex(0);
                }
                catch (IndexOutOfBoundsException e1) {}
            } else if (torem instanceof SubstituteTeacher) {
                JOptionPane.showMessageDialog(this.frame, "Remove Substitute through the teacher.", "Error", 0);
            } else if (torem instanceof Admin) {
                JOptionPane.showMessageDialog(this.frame, "Can't Delete the Admin!", "Error", 0);
            }
            this.refreshUserList();
        }
    }

    public void saveTeacherList() {
        Iterator it = this.teacherList.iterator();
        while (it.hasNext()) {
            Client.sendUserUpdate((Teacher)it.next());
        }
    }

    public void windowClosing(WindowEvent arg0) {
        this.saveTeacherList();
        this.originalUser.notifyLogout();
    }
}

