/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.List;
import javax.swing.JOptionPane;

public class Client {
    private static String ip;
    private static int port;
    private static Socket socket;
    private static ObjectOutputStream oos;
    private static ObjectInputStream ois;

    static {
        socket = null;
        oos = null;
        ois = null;
    }

    private Client() {
    }

    public static void setIP(String s) {
        ip = s;
    }

    public static void setPort(int i) {
        port = i;
    }

    private static void setUpConnection() {
        try {
            socket = new Socket(ip, port);
            oos = new ObjectOutputStream(socket.getOutputStream());
            ois = new ObjectInputStream(socket.getInputStream());
        }
        catch (IOException e) {
            Client.errorHandler(e);
        }
    }

    private static void errorHandler(Exception e) {
        JOptionPane.showMessageDialog(null, "Error connecting to server.", "Error", 0);
    }

    public static User getUser(String username, String password) {
        Client.setUpConnection();
        ServerRequest req = new ServerRequest();
        req.requestUser = true;
        req.userName = username;
        req.password = password;
        User ret = null;
        try {
            oos.writeObject(req);
            ret = (User)ois.readObject();
            socket.close();
        }
        catch (IOException e) {
            Client.errorHandler(e);
        }
        catch (ClassNotFoundException e) {
            Client.errorHandler(e);
        }
        return ret;
    }

    public static boolean exists(String username) {
        Client.setUpConnection();
        ServerRequest req = new ServerRequest();
        req.exists = true;
        req.userName = username;
        boolean ret = false;
        try {
            oos.writeObject(req);
            ret = ois.readBoolean();
            socket.close();
        }
        catch (IOException e) {
            Client.errorHandler(e);
        }
        return ret;
    }

    public static void sendUserUpdate(User user) {
        Client.setUpConnection();
        ServerRequest req = new ServerRequest();
        req.updateUser = true;
        req.user = user;
        try {
            oos.writeObject(req);
            ois.readBoolean();
            socket.close();
        }
        catch (IOException e) {
            Client.errorHandler(e);
        }
    }

    public static void removeUser(String username) {
        Client.setUpConnection();
        ServerRequest req = new ServerRequest();
        req.removeUser = true;
        req.userName = username;
        try {
            oos.writeObject(req);
            socket.close();
        }
        catch (IOException e) {
            Client.errorHandler(e);
        }
    }

    public static List requestTeacherList() {
        Client.setUpConnection();
        ServerRequest req = new ServerRequest();
        req.requestTeacherList = true;
        List teachers = null;
        try {
            oos.writeObject(req);
            teachers = (List)ois.readObject();
            socket.close();
        }
        catch (IOException e) {
            Client.errorHandler(e);
        }
        catch (ClassNotFoundException e) {
            Client.errorHandler(e);
        }
        return teachers;
    }

    public static List requestVoidStudentsList() {
        Client.setUpConnection();
        ServerRequest req = new ServerRequest();
        req.requestVoidStudentsList = true;
        List voids = null;
        try {
            oos.writeObject(req);
            voids = (List)ois.readObject();
            socket.close();
        }
        catch (IOException e) {
            Client.errorHandler(e);
        }
        catch (ClassNotFoundException e) {
            Client.errorHandler(e);
        }
        return voids;
    }

    public static List requestAllUsers() {
        Client.setUpConnection();
        ServerRequest req = new ServerRequest();
        req.requestAllUsers = true;
        List all = null;
        try {
            oos.writeObject(req);
            all = (List)ois.readObject();
            socket.close();
        }
        catch (IOException e) {
            Client.errorHandler(e);
        }
        catch (ClassNotFoundException e) {
            Client.errorHandler(e);
        }
        return all;
    }

    public static void main(String[] args) {
        Client.setIP("127.0.0.1");
        Client.setPort(3000);
        try {
            User bob = Client.getUser("bob123", "12345");
            bob.name = "asdf";
            Client.sendUserUpdate(bob);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

