/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class EasyReader {
    protected String myFileName;
    protected BufferedReader myInFile;
    protected int myErrorFlags = 0;
    protected static final int OPENERROR = 1;
    protected static final int CLOSEERROR = 2;
    protected static final int READERROR = 4;
    protected static final int EOF = 256;

    public EasyReader() {
        this.myFileName = null;
        this.myErrorFlags = 0;
        this.myInFile = new BufferedReader(new InputStreamReader(System.in), 128);
    }

    public EasyReader(String fileName) {
        this.myFileName = fileName;
        this.myErrorFlags = 0;
        try {
            this.myInFile = new BufferedReader(new FileReader(fileName), 1024);
        }
        catch (FileNotFoundException e) {
            this.myErrorFlags |= 1;
            this.myFileName = null;
        }
    }

    public void close() {
        if (this.myFileName == null) {
            return;
        }
        try {
            this.myInFile.close();
        }
        catch (IOException e) {
            System.err.println("Error closing " + this.myFileName + "\n");
            this.myErrorFlags |= 2;
        }
    }

    public boolean bad() {
        return this.myErrorFlags != 0;
    }

    public boolean eof() {
        return (this.myErrorFlags & 0x100) != 0;
    }

    private boolean ready() throws IOException {
        return this.myFileName == null || this.myInFile.ready();
    }

    public char readChar() {
        char ch = '\u0000';
        try {
            if (this.ready()) {
                ch = (char)this.myInFile.read();
            }
        }
        catch (IOException e) {
            if (this.myFileName != null) {
                System.err.println("Error reading " + this.myFileName + "\n");
            }
            this.myErrorFlags |= 4;
        }
        if (ch == '\u0000') {
            this.myErrorFlags |= 0x100;
        }
        return ch;
    }

    public String readLine() {
        String s = null;
        try {
            s = this.myInFile.readLine();
        }
        catch (IOException e) {
            if (this.myFileName != null) {
                System.err.println("Error reading " + this.myFileName + "\n");
            }
            this.myErrorFlags |= 4;
        }
        if (s == null) {
            this.myErrorFlags |= 0x100;
        }
        return s;
    }

    public String readWord() {
        StringBuffer buffer = new StringBuffer(128);
        char ch = ' ';
        int count = 0;
        String s = null;
        try {
            while (this.ready() && Character.isWhitespace(ch)) {
                ch = (char)this.myInFile.read();
            }
            while (this.ready() && !Character.isWhitespace(ch)) {
                ++count;
                buffer.append(ch);
                this.myInFile.mark(1);
                ch = (char)this.myInFile.read();
            }
            if (count > 0) {
                this.myInFile.reset();
                s = buffer.toString();
            } else {
                this.myErrorFlags |= 0x100;
            }
        }
        catch (IOException e) {
            if (this.myFileName != null) {
                System.err.println("Error reading " + this.myFileName + "\n");
            }
            this.myErrorFlags |= 4;
        }
        return s;
    }

    public int readInt() {
        String s = this.readWord();
        if (s != null) {
            return Integer.parseInt(s);
        }
        return 0;
    }

    public double readDouble() {
        String s = this.readWord();
        if (s != null) {
            return Double.parseDouble(s);
        }
        return 0.0;
    }
}

