/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class GameMap
extends Observable
implements Observer {
    public static final int PLAYING_NORMAL_GAME = 0;
    public static final int PLAYING_RAND_GAME = 1;
    public static final int PLAYING_LETTER_GAME = 2;
    public static final int PLAYING_FINAL_GAME = 3;
    public static final int SHOPPING = 4;
    public static final int CHANCE_FOR_MISSPELL = 50;
    public static final int DAMAGE_FROM_RANDOM = 10;
    public static final int DAMAGE_FROM_LETTER = 5;
    public static final int MONEY_FROM_RANDOM = 20;
    public static final int MONEY_FROM_LETTER = 0;
    public static final int MONEY_FROM_FINAL = 200;
    public MapActions actor;
    public String set;
    public Tile[] chipSet;
    public int[][] tiles;
    public Entity[][] contents;
    protected Avatar player;
    public Report sessionReport;
    public int playingMiniGame = 0;
    public MGLauncher game;
    public WordList random;
    public WordList focused;
    public WordList misspell;
    public Letter[] letters;
    public Letter[] generator;
    public Word goal;
    public int money;
    public int lettersToRespawn;
    public boolean levelComplete = false;

    public GameMap(int level, int avatar, WordList rand, WordList foc, int m) {
        this.money = m;
        this.actor = new MapActions(this);
        EasyReader inFile = new EasyReader("maps/" + level + ".map");
        this.set = inFile.readLine();
        this.chipSet = new Tile[6];
        Image[] pics = new Image[6];
        ImageIcon[] files = new ImageIcon[6];
        int i = 0;
        while (i < 6) {
            files[i] = new ImageIcon("images/tiles/" + this.set + '/' + i + ".gif");
            pics[i] = files[i].getImage().getScaledInstance(64, 64, 1);
            ++i;
        }
        this.chipSet[0] = new Tile(pics[0], 0, true);
        this.chipSet[1] = new Tile(pics[1], 0, false);
        this.chipSet[2] = new Tile(pics[2], 1, false);
        this.chipSet[3] = new Tile(pics[3], 2, false);
        this.chipSet[4] = new Tile(pics[4], 2, true);
        this.chipSet[5] = new Tile(pics[5], 0, true);
        ImageIcon p = new ImageIcon("images/avatars/" + avatar + "d.gif");
        Image av = p.getImage();
        this.player = new Avatar(av.getScaledInstance(64, 64, 1), avatar, 1, 100);
        this.misspell = new WordList("Misspelled Words");
        this.random = rand;
        this.focused = foc;
        if (this.random != null && this.focused != null) {
            this.goal = this.chooseWord(true);
            this.letters = new Letter[this.goal.getSpelling().length()];
        } else {
            this.letters = new Letter[0];
        }
        inFile.readLine();
        this.generateMap(inFile);
        this.game = new MGLauncher();
        this.game.addObserver(this);
        this.sessionReport = new Report();
        this.sessionReport.setName("Session " + this.sessionReport.getDate());
        String story = "";
        while (!inFile.eof()) {
            String s = inFile.readLine();
            if (s == null) continue;
            story = String.valueOf(story) + s;
        }
        if (this.letters.length != 0) {
            JOptionPane.showMessageDialog(null, story);
        }
        this.generator = new Letter[this.lettersToRespawn];
        inFile.close();
    }

    protected void generateMap(EasyReader inFile) {
        int i;
        int sizeX = inFile.readInt();
        int sizeY = inFile.readInt();
        int startX = inFile.readInt();
        int startY = inFile.readInt();
        this.tiles = new int[sizeX][sizeY];
        this.contents = new Entity[sizeX][sizeY];
        this.player.x = startX;
        this.player.y = startY;
        inFile.readLine();
        int j = 0;
        while (j < sizeY) {
            i = 0;
            while (i < sizeX) {
                this.tiles[i][j] = inFile.readInt();
                ++i;
            }
            ++j;
        }
        inFile.readLine();
        int conts = inFile.readInt();
        inFile.readLine();
        i = 0;
        while (i < conts) {
            String s = inFile.readWord();
            int locX = inFile.readInt();
            int locY = inFile.readInt();
            if (s != null) {
                if (s.equals("Final")) {
                    this.contents[locX][locY] = new Entity(null, 0, 5);
                } else if (s.equals("Knight")) {
                    ImageIcon q = new ImageIcon("images/knight.gif");
                    this.contents[locX][locY] = new Entity(q.getImage().getScaledInstance(64, 64, 1), 0, 4);
                } else if (s.equals("Letter")) {
                    this.contents[locX][locY] = new Letter(this.goal.getSpelling().charAt((int)(Math.random() * (double)this.goal.getSpelling().length())));
                } else if (s.equals("Exit")) {
                    ImageIcon exit = new ImageIcon("images/exit.gif");
                    this.contents[locX][locY] = new Entity(exit.getImage().getScaledInstance(64, 64, 1), 0, 6);
                } else if (s.equals("Start")) {
                    ImageIcon start = new ImageIcon("images/enter.gif");
                    this.contents[locX][locY] = new Entity(start.getImage().getScaledInstance(64, 64, 1), 0, 7);
                } else if (s.equals("Account")) {
                    ImageIcon cave = new ImageIcon("images/tiles/" + this.set + "5.gif");
                    this.contents[locX][locY] = new Entity(cave.getImage(), 0, 8);
                } else if (s.equals("Item")) {
                    ImageIcon shop = new ImageIcon("images/itemshop.gif");
                    this.contents[locX][locY] = new Entity(shop.getImage(), 0, 9);
                } else if (s.equals("Sign")) {
                    ImageIcon acave = new ImageIcon("images/acave.gif");
                    this.contents[9][4] = new Entity(acave.getImage(), 0, 0);
                }
            }
            ++i;
        }
        inFile.readLine();
        this.lettersToRespawn = inFile.readInt();
    }

    public Word chooseWord(boolean type) {
        if (this.misspell.size() != 0 && Math.random() * 100.0 < 50.0) {
            return this.misspell.getWord();
        }
        if (type) {
            return this.focused.getWord();
        }
        return this.random.getWord();
    }

    public void update(Observable o, Object arg) {
        Report r = null;
        if (this.playingMiniGame != 4 && this.playingMiniGame != 0) {
            r = (Report)arg;
            this.sessionReport.update(r);
        }
        switch (this.playingMiniGame) {
            case 0: {
                break;
            }
            case 1: {
                if (r.getCorrect() > 0) {
                    this.money += 20;
                    Word ms = this.misspell.getWord(r.getSpelling());
                    if (ms == null || !this.misspell.contains(ms)) break;
                    this.misspell.remove(ms);
                    break;
                }
                this.player.health -= 10;
                Word ms = this.random.getWord(r.getSpelling());
                this.misspell.add(ms);
                break;
            }
            case 2: {
                if (r.getCorrect() > 0) {
                    Word ms;
                    this.money += 0;
                    int i = 0;
                    i = 0;
                    while (i < this.letters.length) {
                        if (this.letters[i] == null) break;
                        ++i;
                    }
                    if (i != this.letters.length) {
                        this.letters[i] = (Letter)this.contents[this.player.x][this.player.y];
                    }
                    if ((ms = this.misspell.getWord(r.getSpelling())) != null && this.misspell.contains(ms)) {
                        this.misspell.remove(ms);
                    }
                } else {
                    this.player.health -= 5;
                    Word ms = this.focused.getWord(r.getSpelling());
                    this.misspell.add(ms);
                }
                Letter newLetter = new Letter(this.goal.getSpelling().charAt((int)(Math.random() * (double)this.goal.getSpelling().length())));
                newLetter.active = false;
                if (this.generator[this.generator.length - 1] != null) {
                    this.generator[this.generator.length - 1].active = true;
                }
                int i = this.generator.length - 1;
                while (i > 0) {
                    this.generator[i] = this.generator[i - 1];
                    --i;
                }
                this.generator[0] = newLetter;
                this.contents[this.player.x][this.player.y] = newLetter;
                break;
            }
            case 3: {
                if (r.getCorrect() >= 5) {
                    this.money += 200;
                }
                this.setChanged();
                this.notifyObservers(new Integer(1));
                break;
            }
            case 4: {
                if (arg != null) {
                    return;
                }
                this.setChanged();
                this.notifyObservers(new Integer(-1));
            }
        }
        this.playingMiniGame = 0;
        if (this.player.health <= 0) {
            JOptionPane.showMessageDialog(null, "Out of health");
            this.setChanged();
            this.notifyObservers(new Integer(1));
        }
        this.setChanged();
        this.notifyObservers(new Integer(-1));
    }

    public void setChanged() {
        super.setChanged();
    }
}

