/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class ItemShopUI
extends Observable
implements Displayable,
ActionListener {
    private static final int FRAME_SIZE_X = 400;
    private static final int FRAME_SIZE_Y = 400;
    private static final int[] COST;
    private static final String[] DESCRIPTION;
    private JFrame mamaFrame;
    private BackgroundPanel mainPanel;
    private DefaultListModel listContents;
    private JList listItems;
    private JLabel avatar;
    private JLabel gold;
    private Student student;
    private boolean ownFrame;

    static {
        int[] nArray = new int[11];
        nArray[1] = 100;
        nArray[2] = 600;
        nArray[3] = 900;
        nArray[4] = 900;
        nArray[5] = 900;
        nArray[6] = 1200;
        nArray[7] = 1200;
        nArray[8] = 1200;
        nArray[9] = 5000;
        COST = nArray;
        DESCRIPTION = new String[]{"No Clothes", "Stolen from Fire Emblem", "Noble Knight", "Water Knight", "Fire Knight", "Evil Knight", "Red t-shrit and jeans", "Orange t-shirt and khakis", "Blue t-shirt and sweatpants", "A duck!!!", "Mr. Arrowhead"};
    }

    public ItemShopUI(Student stud) {
        this.student = stud;
        this.mainPanel = new BackgroundPanel(new BorderLayout());
        JTabbedPane tabPane = new JTabbedPane(1);
        this.listContents = new DefaultListModel();
        int i = 0;
        while (i < 11) {
            ImageIcon ic1 = new ImageIcon("images/avatars/" + i + "d.gif");
            ImageIcon ic2 = new ImageIcon(ic1.getImage().getScaledInstance(128, 128, 1));
            JLabel theItem = new JLabel("<HTML>" + DESCRIPTION[i] + "<br>$" + COST[i] + "</HTML>", ic2, 2);
            this.listContents.addElement(theItem);
            ++i;
        }
        this.listItems = new JList();
        this.listItems.setCellRenderer(new ImageRenderer());
        this.listItems.setModel(this.listContents);
        this.listItems.setSelectionMode(0);
        this.listItems.setSelectedIndex(-1);
        JScrollPane itemPane = new JScrollPane(this.listItems);
        tabPane.add("Avatars", itemPane);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        JButton butty = new JButton("Buy");
        butty.addActionListener(this);
        JButton butkus = new JButton("Exit");
        butkus.addActionListener(this);
        buttonPanel.add(butty);
        buttonPanel.add(butkus);
        JPanel rightSide = new JPanel(new GridLayout(3, 0));
        JLabel yourAvaTxt = new JLabel("<HTML>Your<br>Avatar:</HTML>");
        yourAvaTxt.setBorder(new EmptyBorder(64, 0, 0, 0));
        ImageIcon ic = new ImageIcon("images/avatars/" + stud.getAvatar() + "d.gif");
        Image resize = ic.getImage().getScaledInstance(64, 64, 1);
        this.avatar = new JLabel(new ImageIcon(resize));
        this.gold = new JLabel("<HTML>Your Gold<br>$" + stud.getMoney() + "</HTML>");
        rightSide.add(yourAvaTxt);
        rightSide.add(this.avatar);
        rightSide.add(this.gold);
        this.mainPanel.add((Component)tabPane, "Center");
        this.mainPanel.add((Component)buttonPanel, "South");
        this.mainPanel.add((Component)rightSide, "East");
    }

    public JPanel getDisplay() {
        return this.mainPanel;
    }

    public void displayInterface() {
        this.ownFrame = true;
        this.mamaFrame = new JFrame("The Item Shop");
        this.mamaFrame.setDefaultCloseOperation(0);
        this.mamaFrame.setSize(400, 400);
        this.mamaFrame.getContentPane().add(this.mainPanel);
        this.mamaFrame.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String buttonHit = e.getActionCommand();
        if (buttonHit.equals("Buy")) {
            int index = this.listItems.getSelectedIndex();
            int money = this.student.getMoney();
            if (index != -1 && this.student.getAvatar() != index && money >= COST[index]) {
                this.student.setMoney(money - COST[index]);
                this.student.setAvatar(index);
                this.refreshInfo();
                this.setChanged();
                this.notifyObservers(new Integer(5));
            }
        }
        if (buttonHit.equals("Exit")) {
            if (this.ownFrame) {
                this.mamaFrame.dispose();
            } else {
                Container source = (Container)e.getSource();
                while (!(source.getParent() instanceof JFrame)) {
                    source = source.getParent();
                }
                JFrame masterFrame = (JFrame)source.getParent();
                masterFrame.dispose();
            }
            this.setChanged();
            this.notifyObservers(null);
        }
    }

    private void refreshInfo() {
        ImageIcon ic = new ImageIcon("images/avatars/" + this.student.getAvatar() + "d.gif");
        Image resize = ic.getImage().getScaledInstance(64, 64, 1);
        this.avatar.setIcon(new ImageIcon(resize));
        this.gold.setText("<HTML>Your Gold<br>$" + this.student.getMoney() + "</HTML>");
    }

    public static void main(String[] args) {
        Student bob = new Student("All", "Your", "Base");
        bob.setMoney(20000);
        ItemShopUI test = new ItemShopUI(bob);
        test.displayInterface();
    }

    private class ImageRenderer
    extends JLabel
    implements ListCellRenderer {
        public ImageRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JLabel) {
                this.setPreferredSize(new Dimension(256, 128));
                this.setIcon(((JLabel)value).getIcon());
                this.setText(((JLabel)value).getText());
            } else {
                this.setText(value.toString());
            }
            this.setBackground(isSelected ? Color.red : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }
}

