/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class LauncherNew
implements Observer {
    private User theUser;
    private LoginUI loginScreen;
    private UserUI userScreen;
    private JFrame theFrame = new JFrame();
    private static final String TITLE_IMAGE = "title.gif";

    public LauncherNew() {
        this.theFrame.setDefaultCloseOperation(3);
        Container theDisplay = this.theFrame.getContentPane();
        this.theFrame.setSize(1024, 768);
        theDisplay.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        theDisplay.setBackground(Color.white);
        this.loginScreen = new LoginUI();
        JPanel loginSetup = this.loginScreen.getDisplay();
        loginSetup.setBackground(Color.white);
        c.gridx = 3;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        theDisplay.add((Component)loginSetup, c);
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 3;
        ImageIcon tmpIcon = new ImageIcon("images/title.gif");
        tmpIcon.setImage(tmpIcon.getImage().getScaledInstance(640, 480, 1));
        theDisplay.add((Component)new JLabel(tmpIcon), c);
        this.loginScreen.addObserver(this);
        this.theFrame.setVisible(true);
        Thread loadVoice = new Thread(){

            public void run() {
                Speaker.myVoice.allocate();
            }
        };
        loadVoice.start();
        Thread precacheSounds = new Thread(){

            public void run() {
                SoundPlayer.precacheSounds();
            }
        };
        precacheSounds.start();
    }

    public void update(Observable o, Object arg) {
        DisplayableEvent event = (DisplayableEvent)arg;
        if (o == this.loginScreen) {
            if (event.getText().equals("EXIT")) {
                System.exit(1);
            } else if (event.getText().equals("LOGIN")) {
                String[] eventInfo = (String[])event.getInfo();
                Client.setIP(eventInfo[3]);
                Client.setPort(Integer.parseInt(eventInfo[4]));
                this.theUser = Client.getUser(eventInfo[1], eventInfo[2]);
                if (this.theUser != null) {
                    this.theUser.initUI();
                    this.theUser.addObserver(this);
                    this.theFrame.setVisible(false);
                    this.theUser.userUI.display();
                } else {
                    JOptionPane.showMessageDialog(null, "Invalid username/password. Please try again.", "Error", 0);
                }
            }
        } else if (event.getText().equals("LOGOUT")) {
            this.theUser.hideUI();
            Client.sendUserUpdate(this.theUser);
            this.theFrame.setVisible(true);
            this.theUser = null;
        }
    }

    public static void main(String[] args) {
        LauncherNew fr = new LauncherNew();
    }
}

