/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class LoginUI
extends Observable
implements MouseListener,
ActionListener,
Displayable {
    public static final String EXIT_BUTTON_COMMAND = "exit";
    public static final String LOGIN_BUTTON_COMMAND = "login";
    public static final int EVENT_LOC = 0;
    public static final int NAME_LOC = 1;
    public static final int PASS_LOC = 2;
    public static final int IP_LOC = 3;
    public static final int PORT_LOC = 4;
    private static final String OPTIONS_FILE = "Client_Registry.xxx";
    private static final String DEFAULT_PORT = "3000";
    private static final String DEFAULT_IP = "127.0.0.1";
    private static String loginName = "Login";
    private static String exitName = "Exit";
    private JTextField name;
    private JTextField password;
    private JTextField IP = null;
    private JTextField port = null;
    private JPanel myPanel;

    public LoginUI() {
        BufferedReader buffy = null;
        try {
            buffy = new BufferedReader(new FileReader(OPTIONS_FILE));
        }
        catch (FileNotFoundException ex) {
            this.writeOptionsFile(DEFAULT_IP, DEFAULT_PORT);
        }
        if (buffy != null) {
            this.readOptionsFile(buffy);
        } else {
            this.IP = new JTextField(DEFAULT_IP, 12);
            this.port = new JTextField(DEFAULT_PORT, 4);
        }
        this.name = new JTextField(10);
        this.password = new JPasswordField(10);
        this.myPanel = new JPanel();
        this.makeDisplay();
        this.myPanel.setVisible(true);
        this.myPanel.setOpaque(true);
    }

    private void makeDisplay() {
        this.myPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridwidth = 2;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.myPanel.add((Component)this.createLoginOptPanel(), c);
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 11;
        c.gridx = 1;
        c.gridy = 1;
        c.weighty = 0.0;
        this.myPanel.add((Component)this.createButtonPanel(), c);
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 1.0;
        c.gridheight = 2;
        c.gridwidth = 2;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        this.myPanel.add((Component)spacer, c);
    }

    public JPanel getDisplay() {
        return this.myPanel;
    }

    private void writeOptionsFile(String ip, String port) {
        try {
            BufferedWriter fileOut = new BufferedWriter(new FileWriter(OPTIONS_FILE));
            fileOut.write("SERVERIP=" + ip);
            fileOut.newLine();
            fileOut.write("SERVERPORT=" + port);
            fileOut.newLine();
            fileOut.flush();
            fileOut.close();
        }
        catch (IOException except) {
            System.err.println("Error: There was a problemwriting to the options file.");
        }
    }

    private void readOptionsFile(BufferedReader b) {
        try {
            String sLine = b.readLine();
            this.IP = sLine.substring(0, 9).equals("SERVERIP=") ? new JTextField(sLine.substring(9, sLine.length()), 12) : new JTextField(DEFAULT_IP, 12);
            sLine = b.readLine();
            this.port = sLine.substring(0, 11).equals("SERVERPORT=") ? new JTextField(sLine.substring(11, sLine.length()), 12) : new JTextField(DEFAULT_PORT, 12);
        }
        catch (IOException ex) {
            System.err.println("Error: There was a problemreading from the options file.");
        }
    }

    private JPanel createButtonPanel() {
        JButton loginButton = new JButton(loginName);
        loginButton.setActionCommand(LOGIN_BUTTON_COMMAND);
        loginButton.addActionListener(this);
        JButton exitButton = new JButton(exitName);
        exitButton.setActionCommand(EXIT_BUTTON_COMMAND);
        exitButton.addActionListener(this);
        JPanel buttonStorage = new JPanel();
        buttonStorage.add(loginButton);
        buttonStorage.add(exitButton);
        buttonStorage.setOpaque(false);
        return buttonStorage;
    }

    private JTabbedPane createLoginOptPanel() {
        JTabbedPane tmpPane = new JTabbedPane();
        tmpPane.addTab("Login", null, this.createLogin(), "");
        tmpPane.addTab("Options", null, this.createOptions(), "");
        return tmpPane;
    }

    private JPanel createOptions() {
        JPanel thePanel = new JPanel();
        thePanel.setLayout(new GridBagLayout());
        thePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Options"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        thePanel.add((Component)SpringUtilities.makeFormPanel("IP:          ", this.IP), c);
        c.gridx = 0;
        c.gridy = 1;
        thePanel.add((Component)SpringUtilities.makeFormPanel("Port:      ", this.port), c);
        return thePanel;
    }

    private JPanel createLogin() {
        JPanel thePanel = new JPanel();
        thePanel.setLayout(new GridBagLayout());
        thePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Login"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.fill = 2;
        c.gridy = 0;
        this.name.addActionListener(this);
        thePanel.add((Component)SpringUtilities.makeFormPanel("Name:          ", this.name), c);
        c.gridy = 1;
        thePanel.add((Component)SpringUtilities.makeFormPanel("Password:  ", this.password), c);
        this.password.addActionListener(this);
        return thePanel;
    }

    public void actionPerformed(ActionEvent e) {
        this.setChanged();
        if (e.getActionCommand() == EXIT_BUTTON_COMMAND) {
            this.writeOptionsFile(this.IP.getText(), this.port.getText());
            DisplayableEvent event = new DisplayableEvent("EXIT", null);
            this.notifyObservers(event);
        } else {
            String[] eventExtra = new String[5];
            eventExtra[1] = this.name.getText();
            eventExtra[2] = this.password.getText();
            eventExtra[3] = this.IP.getText();
            eventExtra[4] = this.port.getText();
            DisplayableEvent event = new DisplayableEvent("LOGIN", eventExtra);
            this.notifyObservers(event);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public static void main(String[] args) throws Exception {
        JFrame f = new JFrame();
        Container pane = f.getContentPane();
        f.setSize(385, 200);
        LoginUI test = new LoginUI();
        JPanel test2 = test.getDisplay();
        test2.setBackground(Color.red);
        pane.add(test2);
        test.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
            }
        });
        f.setBackground(Color.red);
        f.pack();
        f.setVisible(true);
    }
}

