/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;

public class MGLauncher
extends Observable
implements Observer {
    private MiniGame[] randBattle;
    private MiniGame[] letter;
    private MiniGame[] endlevel;
    private Random randGen;
    private FinalUI fb;
    private Report finalRep = new Report();
    private LetterUI lb;
    private RandBattleUI rb;
    private WordList finalList;
    public static final int NUM_WINS_NEEDED = 5;
    boolean finalRunning;

    public MGLauncher() {
        this.finalRep.setName("Final Game");
        this.randGen = new Random();
        this.randBattle = new MiniGame[3];
        this.randBattle[0] = new MGScramble();
        this.randBattle[1] = new MGMisspelling();
        this.randBattle[2] = new MGFillintheBlank();
        this.letter = new MiniGame[2];
        this.letter[0] = new MGAudio();
        this.letter[1] = new MGPicture();
        this.endlevel = new MiniGame[5];
        this.endlevel[0] = new MGScramble();
        this.endlevel[1] = new MGMisspelling();
        this.endlevel[2] = new MGFillintheBlank();
        this.endlevel[3] = new MGAudio();
        this.endlevel[4] = new MGPicture();
        int x = 0;
        while (x < this.letter.length) {
            this.letter[x].addObserver(this);
            ++x;
        }
        x = 0;
        while (x < this.randBattle.length) {
            this.randBattle[x].addObserver(this);
            ++x;
        }
        x = 0;
        while (x < this.endlevel.length) {
            this.endlevel[x].addObserver(this);
            ++x;
        }
    }

    public void update(Observable o, Object obj) {
        int result;
        boolean myResult = (Boolean)obj;
        MiniGame myMG = (MiniGame)o;
        if (!myResult) {
            result = 0;
            if (this.finalRunning) {
                this.fb.wrong();
            }
        } else {
            result = 1;
            if (this.finalRunning) {
                this.fb.correct();
            }
        }
        Report retReport = new Report(result, 1, String.valueOf(myMG.getGameName()) + " " + myMG.getWord().getSpelling(), myMG.getWord().getSpelling());
        if (!this.finalRunning) {
            if (this.lb != null) {
                this.lb.dispose();
            }
            if (this.rb != null) {
                this.rb.dispose();
            }
            this.setChanged();
            this.notifyObservers(retReport);
        } else {
            this.finalRep.update(retReport);
            if (this.finalRep.getCorrect() != 5 && this.finalRep.getAttempted() - this.finalRep.getCorrect() < 5) {
                this.playFinalGame(this.finalList, null);
            } else {
                this.finalRunning = false;
                this.fb.dispose();
                this.setChanged();
                this.notifyObservers(this.finalRep);
            }
        }
    }

    public void playRandomBattleGame(Word w) {
        int randint = this.randGen.nextInt(this.randBattle.length);
        while (!this.randBattle[randint].isValid(w)) {
            randint = this.randGen.nextInt(this.randBattle.length);
        }
        this.randBattle[randint].setWord(w);
        this.rb = new RandBattleUI(this.randBattle[randint], "defaultBGs/RandUI.jpg");
    }

    public void playLetterChallengeGame(Word w) {
        double whatever = Math.random() * (double)this.letter.length;
        int randint = (int)whatever;
        while (!this.letter[randint].isValid(w)) {
            whatever = Math.random() * (double)this.letter.length;
            randint = (int)whatever;
        }
        this.letter[randint].setWord(w);
        this.lb = new LetterUI(this.letter[randint], "defaultBGs/LetterUI.jpg");
    }

    public void playFinalGame(WordList w, Image avatar) {
        if (!this.finalRunning) {
            this.finalRunning = true;
            this.fb = new FinalUI(avatar);
            this.finalList = w;
        }
        Word fWord = w.getWord();
        int endint = this.randGen.nextInt(this.endlevel.length);
        while (!this.endlevel[endint].isValid(fWord)) {
            endint = this.randGen.nextInt(this.endlevel.length);
        }
        this.endlevel[endint].setWord(fWord);
        this.fb.playGame(this.endlevel[endint]);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Hello World");
        Word testWord = new Word("Clowns");
        testWord.addMistake("Cloun");
        testWord.addMistake("Klown");
        testWord.addMistake("Clowne");
        testWord.addMistake("Klowne");
        MGLauncher mgl = new MGLauncher();
        System.out.println("Launcher created");
        mgl.playRandomBattleGame(testWord);
    }
}

