/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MapActions
implements KeyListener,
MouseListener {
    public static final int TRASH_X = 480;
    public static final int LETTER_RIGHT_X = 422;
    public static final int SPACE_BETWEEN_LETTERS = 8;
    private Image trash;
    private int selectedLetter = -1;
    private GameMap map;

    public MapActions(GameMap m) {
        this.map = m;
        ImageIcon t = new ImageIcon("images/trash.gif");
        this.trash = t.getImage();
    }

    public void paint(Graphics g, StudentUICanvas s) {
        int j;
        int numTilesTall = (s.getHeight() - 64) / 64;
        int numTilesWide = s.getWidth() / 64;
        int centerXPos = this.map.player.x;
        int centerYPos = this.map.player.y;
        if (centerXPos - numTilesWide / 2 < 0) {
            centerXPos = numTilesWide / 2;
        }
        if (centerYPos - numTilesTall / 2 < 0) {
            centerYPos = numTilesTall / 2;
        }
        if (centerXPos + numTilesWide / 2 > this.map.tiles.length) {
            centerXPos = this.map.tiles.length - numTilesWide / 2;
        }
        if (centerYPos + numTilesTall / 2 > this.map.tiles[0].length) {
            centerYPos = this.map.tiles[0].length - numTilesTall / 2;
        }
        int startX = centerXPos - numTilesWide / 2;
        int startY = centerYPos - numTilesTall / 2;
        int endX = centerXPos + numTilesWide / 2;
        int endY = centerYPos + numTilesTall / 2;
        int i = startX;
        while (i < endX) {
            j = startY;
            while (j < endY) {
                g.drawImage(this.map.chipSet[this.map.tiles[i][j]].icon, (i - startX) * 64, (j - startY + 1) * 64, s);
                ++j;
            }
            ++i;
        }
        i = startX;
        while (i < endX) {
            j = startY;
            while (j < endY) {
                if (this.map.contents[i][j] != null && this.map.contents[i][j].icon != null && this.map.contents[i][j].active) {
                    g.drawImage(this.map.contents[i][j].icon, (i - startX) * 64, (j - startY + 1) * 64, s);
                }
                ++j;
            }
            ++i;
        }
        g.drawImage(this.map.player.icon, (this.map.player.x - startX) * 64, (this.map.player.y - startY + 1) * 64, s);
        if (this.map.letters.length != 0) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, 640, 64);
            g.drawImage(this.trash, 480, 0, s);
            g.setColor(Color.YELLOW);
            g.drawRect(547, 27, 60, 25);
            g.setColor(Color.WHITE);
            g.drawString("Health: " + this.map.player.health, 550, 16);
            g.drawString("Click here", 550, 38);
            g.drawString("   for hint", 550, 48);
            g.drawString("Money: " + this.map.money, 550, 26);
        } else {
            ImageIcon q = new ImageIcon("images/lobbytitle.gif");
            g.drawImage(q.getImage(), 0, 0, s);
        }
        i = 0;
        while (i < this.map.letters.length) {
            if (this.map.letters[this.map.letters.length - i - 1] != null) {
                g.drawImage(this.map.letters[this.map.letters.length - i - 1].icon, 422 - i * 32, 0, s);
            }
            ++i;
        }
        if (this.selectedLetter >= 0) {
            g.setColor(Color.YELLOW);
            int offset = 19;
            g.drawRect(422 - (this.map.letters.length - this.selectedLetter - 1) * 32 + offset, offset, 26, 26);
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.map.playingMiniGame != 0) {
            return;
        }
        int p = this.map.player.x;
        int q = this.map.player.y;
        if (e.getKeyCode() == 39 && p < this.map.tiles.length - 1) {
            this.map.player.setIcon(this.map.player.myIcons[3]);
            ++p;
        } else if (e.getKeyCode() == 37 && p > 0) {
            this.map.player.setIcon(this.map.player.myIcons[1]);
            --p;
        } else if (e.getKeyCode() == 38 && q > 0) {
            this.map.player.setIcon(this.map.player.myIcons[2]);
            --q;
        } else if (e.getKeyCode() == 40 && q < this.map.tiles[0].length - 1) {
            this.map.player.setIcon(this.map.player.myIcons[0]);
            ++q;
        } else {
            return;
        }
        int action = this.map.contents[p][q] == null || !this.map.contents[p][q].active ? this.map.chipSet[this.map.tiles[p][q]].interact(this.map.player) : this.map.contents[p][q].interact(this.map.player);
        if (action != 0 && action != 4) {
            this.map.player.x = p;
            this.map.player.y = q;
        }
        switch (action) {
            case 2: {
                Word w = this.map.chooseWord(false);
                this.map.game.playRandomBattleGame(w);
                this.map.playingMiniGame = 1;
                break;
            }
            case 3: {
                Word w = this.map.chooseWord(true);
                this.map.game.playLetterChallengeGame(w);
                this.map.playingMiniGame = 2;
                break;
            }
            case 4: {
                char[] c = new char[this.map.letters.length];
                boolean allLetters = true;
                int i = 0;
                while (i < this.map.letters.length) {
                    if (this.map.letters[i] == null) {
                        allLetters = false;
                    }
                    ++i;
                }
                ImageIcon img = new ImageIcon("images/knight.gif");
                if (!allLetters) {
                    JOptionPane.showMessageDialog(null, "This is not the word I seek! Begone!", "Ye Royal Guard!", -1, img);
                    this.map.letters = new Letter[this.map.letters.length];
                    break;
                }
                int i2 = 0;
                while (i2 < this.map.letters.length) {
                    c[i2] = this.map.letters[i2].letter;
                    ++i2;
                }
                if (new String(c).equalsIgnoreCase(this.map.goal.getSpelling())) {
                    JOptionPane.showMessageDialog(null, "Ah, a fine word it is! Ye may pass.", "Ye Royal Guard!", -1, img);
                    this.map.contents[p][q].active = false;
                    this.map.letters = new Letter[this.map.letters.length];
                    this.map.levelComplete = true;
                    break;
                }
                JOptionPane.showMessageDialog(null, "This is not the word I seek! Begone!", "Ye Royal Guard!", -1, img);
                this.map.letters = new Letter[this.map.letters.length];
                break;
            }
            case 5: {
                this.map.player.setIcon(this.map.player.myIcons[3]);
                this.map.game.playFinalGame(this.map.focused, this.map.player.icon);
                this.map.playingMiniGame = 3;
                break;
            }
            case 6: {
                if (this.map.letters.length != 0) {
                    this.map.setChanged();
                    this.map.notifyObservers(new Integer(1));
                    break;
                }
                this.map.setChanged();
                this.map.notifyObservers(new Integer(0));
                return;
            }
            case 7: {
                this.map.setChanged();
                this.map.notifyObservers(new Integer(2));
                break;
            }
            case 8: {
                this.map.setChanged();
                this.map.notifyObservers(new Integer(3));
                break;
            }
            case 9: {
                this.map.setChanged();
                this.map.notifyObservers(new Integer(4));
            }
        }
        this.map.setChanged();
        this.map.notifyObservers(new Integer(-1));
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        int offset = 19;
        if (e.getY() > 64 - offset || e.getY() < offset) {
            return;
        }
        if (e.getX() > 544 && this.map.goal != null) {
            Object[] buttons = new Object[]{"View Picture", "Play Sound", "View Text Hint", "Cancel"};
            int i = JOptionPane.showOptionDialog(null, "Pick one!", "Hint", 0, 0, null, buttons, buttons[0]);
            JPanel d = new JPanel();
            switch (i) {
                case 0: {
                    if (this.map.goal.getImage() == null) {
                        d.add(new JLabel("No image given."));
                        break;
                    }
                    d.add(new JLabel(new ImageIcon(this.map.goal.getImage())));
                    break;
                }
                case 1: {
                    JButton tmp = new JButton("Play Sound");
                    tmp.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Speaker.myVoice.speak(((MapActions)MapActions.this).map.goal.getAudio());
                        }
                    });
                    d.add(tmp);
                    break;
                }
                case 2: {
                    if (this.map.goal.getHint().equals("")) {
                        d.add(new JLabel("No hint given."));
                        break;
                    }
                    d.add(new JLabel(this.map.goal.getHint()));
                    break;
                }
                default: {
                    return;
                }
            }
            JOptionPane.showOptionDialog(null, d, "Hint", -1, 0, null, null, null);
        }
        if (this.selectedLetter >= 0) {
            if (e.getX() > 480 && e.getX() < 544) {
                this.map.letters[this.selectedLetter] = null;
            } else {
                int swapLetter = this.map.letters.length - (446 + offset - e.getX()) / 32 - 1;
                if (swapLetter < this.map.letters.length && swapLetter >= 0 && swapLetter != this.selectedLetter) {
                    Letter temp2 = this.map.letters[this.selectedLetter];
                    this.map.letters[this.selectedLetter] = this.map.letters[swapLetter];
                    this.map.letters[swapLetter] = temp2;
                }
            }
            this.selectedLetter = -1;
        } else {
            this.selectedLetter = this.map.letters.length - (446 + offset - e.getX()) / 32 - 1;
            if (this.selectedLetter >= this.map.letters.length) {
                this.selectedLetter = -1;
            }
        }
        this.map.setChanged();
        this.map.notifyObservers(new Integer(-1));
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

