/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.Date;
import java.util.TreeSet;

public class Report
implements Comparable,
Serializable {
    private int numWordCorrect;
    private int numWordAttempted;
    private String reportName;
    private TreeSet myReports;
    private Date reportDate;
    private String spellingWord;

    public Report() {
        this.numWordCorrect = 0;
        this.numWordAttempted = 0;
        this.reportName = "";
        this.spellingWord = null;
        this.reportDate = new Date();
        this.myReports = new TreeSet();
    }

    public Report(int numRight, int numTried, String reportName, String wordUsed) {
        this.numWordCorrect = numRight;
        this.numWordAttempted = numTried;
        this.reportName = reportName;
        this.reportDate = new Date();
        this.spellingWord = wordUsed;
        this.myReports = new TreeSet();
    }

    public void update(Report updateWith) {
        this.numWordCorrect += updateWith.numWordCorrect;
        this.numWordAttempted += updateWith.numWordAttempted;
        this.myReports.add(updateWith);
        this.reportDate = new Date();
    }

    public void addCorrect(int newNum) {
        this.numWordCorrect += newNum;
        this.numWordAttempted += newNum;
    }

    public void addAttempted(int newNum) {
        this.numWordAttempted += newNum;
    }

    public void setName(String newName) {
        this.reportName = newName;
    }

    public void setWord(String wordUsed) {
        this.spellingWord = wordUsed;
    }

    public String getName() {
        return this.reportName;
    }

    public int getCorrect() {
        return this.numWordCorrect;
    }

    public int getAttempted() {
        return this.numWordAttempted;
    }

    public int getWrong() {
        return this.numWordAttempted - this.numWordCorrect;
    }

    public String getSpelling() {
        return this.spellingWord;
    }

    public Report[] getReports() {
        if (this.myReports == null) {
            return null;
        }
        Report[] tmp = new Report[this.myReports.size()];
        this.myReports.toArray(tmp);
        return tmp;
    }

    public String getDate() {
        return this.reportDate.toString();
    }

    public String toString() {
        return this.getName();
    }

    public String getReportHeading() {
        return "Report for: " + this.reportName + "\n" + "Report was last updated on: " + this.reportDate + "\n";
    }

    public String getReportBody() {
        String result = "Percent Correct: ";
        if (this.getAttempted() != 0) {
            result = String.valueOf(result) + String.valueOf((int)(100.0 * (double)this.getCorrect()) / this.getAttempted()) + "%\n";
        }
        result = String.valueOf(result) + "\nNumber Correct: " + this.getCorrect() + "\nNumber Incorrect: " + this.getWrong();
        return result;
    }

    public String getPrintableReport() {
        Report[] tmp = this.getReports();
        String result = "";
        result = String.valueOf(result) + this.getReportHeading() + "\n";
        result = String.valueOf(result) + this.getReportBody() + "\n";
        if (tmp != null) {
            int i = 0;
            while (i < tmp.length) {
                result = String.valueOf(result) + "_____________________________________________\n";
                result = String.valueOf(result) + "Report for: " + tmp[i].getName() + "\n";
                result = String.valueOf(result) + tmp[i].getReportBody();
                result = String.valueOf(result) + "\n";
                ++i;
            }
        }
        result = String.valueOf(result) + "_____________________________________________\n";
        return result;
    }

    public int compareTo(Object other) {
        int ret = ((Report)other).reportDate.compareTo(this.reportDate);
        if (ret == 0) {
            ret = ((Report)other).reportName.compareTo(this.reportName);
        }
        return ret;
    }
}

