/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import myRenderer.DocumentRenderer;

public class ReportUI
extends JPanel
implements ActionListener,
FocusListener,
Displayable,
Printable {
    public static final String VIEW_TEXT = "View";
    public static final String PREV_TEXT = "Go Back";
    public static final String PREV_COMMAND = "back";
    public static final String VIEW_COMMAND = "next";
    public static final String PAGE_SETUP = "Printer Page Setup...";
    public static final String PRINT_REPORT = "Print Report...";
    public static final String PAGE_COMMAND = "pagesetup";
    public static final String PRINT_COMMAND = "print";
    public static int MAX_DEPTH = 6;
    private ReportUIElement[] myDisplay;
    private CardPanel myPanels;
    private int depth = 0;
    private Report myReport;
    private JList tmpList;
    private JButton prev;
    private JButton view;
    private JButton pgSetup;
    private JButton printRep;
    private PlainDocument tempPrintReport;
    private DocumentRenderer printer;

    public ReportUI(Report r) {
        this.myReport = r;
        this.myDisplay = new ReportUIElement[MAX_DEPTH];
        this.myPanels = new CardPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.view = new JButton(VIEW_TEXT);
        this.prev = new JButton(PREV_TEXT);
        this.pgSetup = new JButton(PAGE_SETUP);
        this.printRep = new JButton(PRINT_REPORT);
        this.tempPrintReport = null;
        this.printer = new DocumentRenderer();
        this.view.setActionCommand(VIEW_COMMAND);
        this.prev.setActionCommand(PREV_COMMAND);
        this.pgSetup.setActionCommand(PAGE_COMMAND);
        this.printRep.setActionCommand(PRINT_COMMAND);
        int i = 0;
        while (i < MAX_DEPTH) {
            this.myDisplay[i] = new ReportUIElement();
            this.myPanels.add(this.myDisplay[i]);
            ++i;
        }
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Report for " + this.myReport.getName()), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add(this.myPanels);
        this.add(this.makeButtons());
        this.updateDisplay(this.myReport);
    }

    public Report getReport() {
        return this.myDisplay[this.depth].getReport();
    }

    private void updateDisplay(Report r) {
        this.myDisplay[this.depth].update(r);
        this.myPanels.showCard(this.myDisplay[this.depth]);
        if (this.depth == 0) {
            this.prev.setEnabled(false);
        }
    }

    private JPanel makeButtons() {
        JPanel tmp = new JPanel();
        tmp.add(this.prev);
        tmp.add(this.view);
        tmp.add(this.pgSetup);
        tmp.add(this.printRep);
        tmp.setOpaque(false);
        this.view.addActionListener(this);
        this.prev.addActionListener(this);
        this.pgSetup.addActionListener(this);
        this.printRep.addActionListener(this);
        return tmp;
    }

    public JPanel getDisplay() {
        return this;
    }

    private void makeDisplay() {
    }

    public int print(Graphics g, PageFormat format, int pageIndex) throws PrinterException {
        Graphics2D g2d = (Graphics2D)g;
        if (pageIndex == 0) {
            g2d.translate(format.getImageableX(), format.getImageableY());
            RepaintManager currentManager = RepaintManager.currentManager(this);
            currentManager.setDoubleBufferingEnabled(false);
            this.myDisplay[0].paint(g2d);
            currentManager.setDoubleBufferingEnabled(true);
            return 0;
        }
        return 1;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == VIEW_COMMAND) {
            Report tmpReport;
            ++this.depth;
            if (this.depth >= MAX_DEPTH) {
                --this.depth;
            }
            if ((tmpReport = this.myDisplay[this.depth - 1].getSelected()) == null) {
                --this.depth;
            } else {
                this.updateDisplay(this.myDisplay[this.depth - 1].getSelected());
                this.prev.setEnabled(true);
            }
        }
        if (e.getActionCommand() == PREV_COMMAND) {
            if (this.depth > 0) {
                --this.depth;
            }
            this.myPanels.showCard(this.myDisplay[this.depth]);
            if (this.depth == 0) {
                this.prev.setEnabled(false);
            }
        }
        if (e.getActionCommand() == PAGE_COMMAND) {
            if (this.tempPrintReport == null) {
                this.tempPrintReport = new PlainDocument();
            }
            this.printer.pageDialog();
        }
        if (e.getActionCommand() == PRINT_COMMAND) {
            if (this.tempPrintReport == null) {
                this.tempPrintReport = new PlainDocument();
            }
            try {
                this.tempPrintReport.remove(0, this.tempPrintReport.getLength());
            }
            catch (BadLocationException e2) {
                e2.printStackTrace();
            }
            String strToPrint = new String();
            try {
                if (this.depth != 0) {
                    strToPrint = String.valueOf(strToPrint) + this.myReport.getReportHeading();
                    strToPrint = String.valueOf(strToPrint) + "_____________________________________________\n\n";
                }
                strToPrint = String.valueOf(strToPrint) + this.getReport().getPrintableReport();
                this.tempPrintReport.insertString(0, strToPrint, null);
            }
            catch (BadLocationException ex) {
                System.err.println("Error formating document.");
            }
            try {
                this.printer.print(this.tempPrintReport);
                this.tempPrintReport.remove(0, this.tempPrintReport.getLength());
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public static void main(String[] args) throws Exception {
        String[] data = new String[]{"one", "two", "three", "four", "five", "six", "seve", "eigh", "nine"};
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        Container pane = f.getContentPane();
        f.setSize(520, 549);
        Report r = new Report();
        Report t = new Report();
        t.setName("Minigame afldafl");
        r.setName("What's his name");
        t.setWord("soup");
        t.addAttempted(3);
        r.addAttempted(1);
        r.addCorrect(4);
        t.addCorrect(7);
        r.update(t);
        ReportUI test = new ReportUI(r);
        pane.add(test.getDisplay());
        f.setVisible(true);
    }

    private class ReportUIElement
    extends JPanel
    implements ActionListener,
    ListSelectionListener {
        private JTextField numCorrect = new JTextField(10);
        private JTextField numIncorrect = new JTextField(10);
        private JTextField numTried = new JTextField(10);
        private JTextField reportName = new JTextField(10);
        private JTextField wordUsed = new JTextField(10);
        private JTextField reportDate;
        private JList otherReports = new JList();
        private JList gameReports;
        private JPanel myDisplay;
        private JList mgReports;
        private Report myReport;
        private JTextField perCor;

        ReportUIElement() {
            this.reportDate = new JTextField(10);
            this.perCor = new JTextField(10);
            this.setPreferredSize(new Dimension(300, 300));
        }

        private JPanel update(Report r) {
            this.removeAll();
            this.myReport = r;
            this.numCorrect.setText(Integer.toString(this.myReport.getCorrect()));
            this.numIncorrect.setText(Integer.toString(this.myReport.getWrong()));
            this.numTried.setText(Integer.toString(this.myReport.getAttempted()));
            this.wordUsed.setText(this.myReport.getSpelling());
            this.reportDate.setText(r.getDate());
            this.reportName.setText(this.myReport.getName());
            if (this.myReport.getAttempted() != 0) {
                this.perCor.setText(String.valueOf(String.valueOf((int)(100.0 * (double)this.myReport.getCorrect()) / this.myReport.getAttempted())) + "%");
            }
            this.numIncorrect.setEditable(false);
            this.numCorrect.setEditable(false);
            this.numTried.setEditable(false);
            this.reportDate.setEditable(false);
            this.wordUsed.setEditable(false);
            this.perCor.setEditable(false);
            this.otherReports = new JList<Report>(this.myReport.getReports());
            this.makeDisplay();
            return this;
        }

        private void makeDisplay() {
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridBag);
            c.anchor = 11;
            c.weightx = 0.0;
            c.gridwidth = 0;
            c.weighty = 0.0;
            c.gridx = 1;
            c.gridy = 0;
            c.weighty = 0.0;
            c.fill = 10;
            this.add((Component)this.makeTitle(), c);
            c.weighty = 0.0;
            c.anchor = 13;
            c.weightx = 0.0;
            c.gridwidth = 2;
            c.gridx = 0;
            c.fill = 2;
            c.gridy = 1;
            c.gridx = 0;
            this.add((Component)this.makeDate(), c);
            c.anchor = 11;
            c.fill = 2;
            c.weightx = 1.0;
            c.gridx = 0;
            c.gridy = 2;
            this.add((Component)this.makePercent(), c);
            c.gridy = 3;
            this.add((Component)this.makeAttempted(), c);
            c.gridy = 4;
            this.add((Component)this.makeIncorrect(), c);
            c.gridy = 5;
            this.add((Component)this.makeCorrect(), c);
            c.gridy = 6;
            this.add((Component)this.makeWordUsed(), c);
            c.gridwidth = 1;
            c.gridy = 6;
            c.gridx = 1;
            this.add((Component)this.makeOtherReports(), c);
            this.setVisible(true);
        }

        private JPanel getDisplay() {
            return new JPanel();
        }

        private JPanel makeTitle() {
            JLabel tmpLabel = new JLabel(this.myReport.getName());
            JPanel tmpPanel = new JPanel();
            tmpPanel.add(tmpLabel);
            return tmpPanel;
        }

        private JPanel makeAttempted() {
            return SpringUtilities.makeFormPanel("Number of words Attempted: ", this.numTried);
        }

        private JPanel makePercent() {
            if (this.perCor.getText().equals("")) {
                return new JPanel();
            }
            return SpringUtilities.makeFormPanel("Percent Correct: ", this.perCor);
        }

        private JPanel makeDate() {
            return SpringUtilities.makeFormPanel("Last updated: ", this.reportDate);
        }

        private JPanel makeCorrect() {
            return SpringUtilities.makeFormPanel("Number of words Correct:      ", this.numCorrect);
        }

        private JPanel makeIncorrect() {
            return SpringUtilities.makeFormPanel("Number of words Incorrect:   ", this.numIncorrect);
        }

        private JPanel makeWordUsed() {
            if (this.wordUsed.getText() == null || this.wordUsed.getText().equals("")) {
                return new JPanel();
            }
            return SpringUtilities.makeFormPanel("Word Attempted:   ", this.wordUsed);
        }

        private JPanel makeOtherReports() {
            JPanel tmpPanel = new JPanel();
            tmpPanel.setOpaque(false);
            JScrollPane scrollPane = new JScrollPane(this.otherReports);
            scrollPane.setPreferredSize(new Dimension(400, 162));
            scrollPane.setMinimumSize(new Dimension(126, 100));
            this.otherReports.addListSelectionListener(this);
            tmpPanel.add(scrollPane);
            return tmpPanel;
        }

        private Report getSelected() {
            return (Report)this.otherReports.getSelectedValue();
        }

        private Report getReport() {
            return this.myReport;
        }

        public void actionPerformed(ActionEvent e) {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == this.otherReports) {
                ReportUI.this.view.setEnabled(true);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

