/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Date;
import java.text.SimpleDateFormat;

public class Server
extends Thread {
    ServerSocket server;
    UserDatabase data;
    String databaseFile;

    public Server(String file, int port) throws IOException {
        this.databaseFile = file;
        Thread hook = new Thread(new Runnable(){

            public void run() {
                Server.this.backupDatabase();
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
        this.log("Reading Database file " + file + " ...");
        this.data = UserDatabase.open(file);
        this.log("Done");
        this.server = new ServerSocket(port);
        this.log("Server listening on " + InetAddress.getLocalHost().getHostAddress() + ":" + this.server.getLocalPort());
        this.start();
    }

    private void log(String s) {
        System.out.println(String.valueOf(this.getTime()) + s);
    }

    private String getTime() {
        SimpleDateFormat s = new SimpleDateFormat("HH:mm:ss");
        return "[" + s.format(new Date(System.currentTimeMillis())) + "] ";
    }

    public void backupDatabase() {
        System.out.print(String.valueOf(this.getTime()) + "Saving the database to " + this.databaseFile + " ...");
        this.data.save(this.databaseFile);
        this.log("Done");
        this.log("Shutting Down Server.");
    }

    public void run() {
        while (true) {
            try {
                this.log("Waiting for connections.");
                Socket client = this.server.accept();
                this.log("Accepted a connection from: " + client.getInetAddress());
                ServerIO c = new ServerIO(client, this.data);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        try {
            new Server("Database.txt", 3000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

