/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ServerIO
extends Thread {
    UserDatabase data;
    Socket client = null;
    ObjectOutputStream oos = null;
    ObjectInputStream ois = null;

    public ServerIO(Socket cl, UserDatabase d) {
        this.client = cl;
        this.data = d;
        this.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            block20: {
                try {
                    this.oos = new ObjectOutputStream(this.client.getOutputStream());
                    this.ois = new ObjectInputStream(this.client.getInputStream());
                    ServerRequest req = (ServerRequest)this.ois.readObject();
                    this.log(req.toString());
                    if (req.requestUser) {
                        User requested = this.data.getUser(req.userName, req.password);
                        if (requested == null) {
                            this.log("No Such User.");
                            this.oos.writeObject(null);
                        } else {
                            this.log("User Sent.");
                            this.oos.writeObject(requested);
                        }
                        this.oos.flush();
                        break block20;
                    }
                    if (req.updateUser) {
                        this.data.addUser(req.user);
                        this.log("User Added.");
                        this.oos.writeBoolean(true);
                        this.oos.flush();
                        break block20;
                    }
                    if (req.removeUser) {
                        if (this.data.removeUser(req.userName)) {
                            this.log("User Removed Successfully.");
                            break block20;
                        } else {
                            this.log("Error Removing User.");
                        }
                        break block20;
                    }
                    if (req.requestTeacherList) {
                        this.oos.writeObject(this.data.getTeachers());
                        this.log("Teacher List Sent");
                        break block20;
                    }
                    if (req.requestVoidStudentsList) {
                        this.oos.writeObject(this.data.getVoidStudents());
                        this.log("Void Students Sent");
                        break block20;
                    }
                    if (req.requestAllUsers) {
                        this.oos.writeObject(this.data.getAllUsers());
                        this.log("All Users Sent");
                        break block20;
                    }
                    if (req.exists) {
                        this.oos.writeBoolean(this.data.exists(req.userName));
                        break block20;
                    }
                    this.log("Unknown Packet");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            Object var3_7 = null;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            try {
                this.oos.close();
                this.ois.close();
                this.client.close();
                this.log("Connection Closed.");
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {
            return;
        }
        this.oos.close();
        this.ois.close();
        this.client.close();
        this.log("Connection Closed.");
    }

    public void log(String s) {
        System.out.println(String.valueOf(this.getTime()) + s);
    }

    public String getTime() {
        SimpleDateFormat s = new SimpleDateFormat("HH:mm:ss");
        return "[" + s.format(new Date(System.currentTimeMillis())) + "] ";
    }
}

