/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class StudentUI
extends UserUI
implements Observer,
WindowListener {
    Student user;
    public static final int NONE = -1;
    public static final int LOGOUT = 0;
    public static final int BEGIN_LOBBY = 1;
    public static final int BEGIN_GAME = 2;
    public static final int ACCOUNT_CAVE = 3;
    public static final int ITEM_SHOP = 4;
    public static final int AVATAR_CHANGE = 5;
    public static final int SCREEN_HEIGHT = 704;
    public static final int SCREEN_WIDTH = 640;
    public static final int TOTAL_LEVELS = 2;
    private StudentUICanvas myCanvas;
    private GameMap map;
    private int avatar;
    private int money;
    private int level;
    private WordList random;
    private WordList focused;
    private boolean failed = false;
    private AccountCaveUI c;
    private ItemShopUI it;
    private Graphics g;
    BufferStrategy strategy;
    Frame f;

    public StudentUI(Student u) {
        this.user = u;
        this.avatar = u.getAvatar();
        this.level = u.getLevel();
        if (u.getTeacher() == null) {
            JOptionPane.showMessageDialog(null, "You're not in a class.\nShout at your principal.");
            this.failed = true;
            return;
        }
        WordListList ran = u.getTeacher().getRandomLists();
        WordListList foc = u.getTeacher().getFocusedLists();
        WordListList all = u.getTeacher().getAllLists();
        if (ran == null || ran.isEmpty()) {
            ran = foc;
        }
        if (foc == null || foc.isEmpty()) {
            foc = ran;
        }
        if (foc == null || foc.isEmpty()) {
            JOptionPane.showMessageDialog(null, "You have no words to use.\nShout at your teacher.");
            this.failed = true;
            return;
        }
        this.random = new WordList();
        int i = 0;
        while (i < ran.size()) {
            this.random.add(ran.getWordList(i));
            ++i;
        }
        this.focused = new WordList();
        i = 0;
        while (i < foc.size()) {
            this.focused.add(foc.getWordList(i));
            ++i;
        }
        this.money = u.getMoney();
    }

    public void display() {
        this.f = new Frame();
        if (this.failed) {
            this.update(null, new Integer(0));
            return;
        }
        this.f.setVisible(true);
        this.f.setSize(640, 704 + this.f.insets().top);
        this.f.setResizable(false);
        this.display(this.f);
        this.f.addWindowListener(this);
    }

    public void hideUI() {
        this.f.dispose();
    }

    public void display(Frame frame) {
        this.f = frame;
        this.f.removeAll();
        this.f.setLayout(null);
        this.map = new Lobby(this.avatar, this.money);
        this.map.addObserver(this);
        ImageIcon p = new ImageIcon("images/avatars/" + this.user.getAvatar() + "d.gif");
        Image av = p.getImage().getScaledInstance(128, 128, 1);
        this.c = new AccountCaveUI(this.user, av);
        this.it = new ItemShopUI(this.user);
        this.c.addObserver(this.map);
        this.c.addObserver(this);
        this.it.addObserver(this.map);
        this.it.addObserver(this);
        this.myCanvas = new StudentUICanvas(this.map);
        this.myCanvas.setBounds(0, this.f.insets().top, 640, 704);
        this.f.add(this.myCanvas);
        this.myCanvas.addKeyListener(this.map.actor);
        this.myCanvas.addMouseListener(this.map.actor);
        this.myCanvas.requestFocus();
        this.myCanvas.createBufferStrategy(2);
        this.strategy = this.myCanvas.getBufferStrategy();
        this.g = this.strategy.getDrawGraphics();
        this.map.player.loadImages(this.myCanvas);
        int i = 0;
        while (i < 6) {
            this.map.chipSet[i].loadImages(this.myCanvas);
            ++i;
        }
        i = 0;
        while (i < this.map.contents.length) {
            int j = 0;
            while (j < this.map.contents[i].length) {
                if (this.map.contents[i][j] != null) {
                    this.map.contents[i][j].loadImages(this.myCanvas);
                }
                ++j;
            }
            ++i;
        }
        Letter.loadLetterImages(this.myCanvas);
        this.myCanvas.paint(this.g);
    }

    public void update(Observable o, Object arg) {
        if (arg == null) {
            return;
        }
        Integer action = (Integer)arg;
        if (action == 0) {
            this.user.notifyLogout();
        } else if (action == 1) {
            this.user.getReport().update(this.map.sessionReport);
            this.money = this.map.money;
            this.user.setMoney(this.money);
            if (this.map.levelComplete) {
                ++this.level;
                if (this.level > 2) {
                    this.level = 1;
                }
                this.user.setLevel(this.level);
            }
            this.map.deleteObserver(this);
            this.myCanvas.removeKeyListener(this.map.actor);
            this.myCanvas.removeMouseListener(this.map.actor);
            this.map = new Lobby(this.avatar, this.money);
            this.myCanvas.changeMap(this.map);
            this.map.addObserver(this);
            this.myCanvas.addMouseListener(this.map.actor);
            this.myCanvas.addKeyListener(this.map.actor);
            this.map.player.loadImages(this.myCanvas);
            int i = 0;
            while (i < 6) {
                this.map.chipSet[i].loadImages(this.myCanvas);
                ++i;
            }
            i = 0;
            while (i < this.map.contents.length) {
                int j = 0;
                while (j < this.map.contents[i].length) {
                    if (this.map.contents[i][j] != null) {
                        this.map.contents[i][j].loadImages(this.myCanvas);
                    }
                    ++j;
                }
                ++i;
            }
        } else if (action == 2) {
            this.map.deleteObserver(this);
            this.myCanvas.removeKeyListener(this.map.actor);
            this.myCanvas.removeMouseListener(this.map.actor);
            this.map = new GameMap(this.level, this.avatar, this.random, this.focused, this.money);
            this.myCanvas.changeMap(this.map);
            this.map.addObserver(this);
            this.myCanvas.addMouseListener(this.map.actor);
            this.myCanvas.addKeyListener(this.map.actor);
            this.map.player.loadImages(this.myCanvas);
            int i = 0;
            while (i < 6) {
                this.map.chipSet[i].loadImages(this.myCanvas);
                ++i;
            }
            i = 0;
            while (i < this.map.contents.length) {
                int j = 0;
                while (j < this.map.contents[i].length) {
                    if (this.map.contents[i][j] != null) {
                        this.map.contents[i][j].loadImages(this.myCanvas);
                    }
                    ++j;
                }
                ++i;
            }
        } else if (action == 3) {
            ImageIcon p = new ImageIcon("images/avatars/" + this.user.getAvatar() + "d.gif");
            Image av = p.getImage().getScaledInstance(128, 128, 1);
            this.c = new AccountCaveUI(this.user, av);
            this.c.addObserver(this.map);
            this.c.addObserver(this);
            this.c.displayInterface();
            this.map.playingMiniGame = 4;
        } else if (action == 4) {
            this.it = new ItemShopUI(this.user);
            this.it.addObserver(this.map);
            this.it.addObserver(this);
            this.it.displayInterface();
            this.map.playingMiniGame = 4;
        } else if (action == 5) {
            this.map.player.changeAvatar(this.user.avatar);
            this.avatar = this.user.avatar;
            this.money = this.user.getMoney();
            this.map.player.loadImages(this.myCanvas);
            this.myCanvas.repaint();
        }
        if (action != 0) {
            this.g = this.strategy.getDrawGraphics();
            this.myCanvas.paint(this.g);
            this.strategy.show();
        }
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        this.user.notifyLogout();
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }
}

