/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class TeacherGUI
extends UserUI
implements ActionListener,
WindowListener,
FocusListener,
ItemListener {
    Teacher u;
    User originalUser;
    JFrame frame;
    Container c;
    JTabbedPane tab = new JTabbedPane();
    EmailInfo emailInfo = new EmailInfo();
    JPanel students = new JPanel();
    JButton rightButton = new JButton("-->");
    JButton leftButton = new JButton("<--");
    JButton changePassButton = new JButton("Change Student's Password");
    JButton viewReportButton = new JButton("View Report");
    JButton refreshButton = new JButton("Refresh");
    JButton chpassButton = new JButton("Change My Password");
    JButton emailReportButton = new JButton("Email Report");
    JButton viewOverallReportButton = new JButton("View Overall Report");
    ReportUI repUI;
    WordTab words;
    DefaultListModel lmodelstu = new DefaultListModel();
    JList studentList = new JList(this.lmodelstu);
    JScrollPane studentListScroll = new JScrollPane(this.studentList);
    DefaultListModel lmodelvoid = new DefaultListModel();
    JList voidList = new JList(this.lmodelvoid);
    JScrollPane voidListScroll = new JScrollPane(this.voidList);
    JCheckBox chbx = new JCheckBox("Enable Substitute Teacher");
    JPanel sub;
    List voids;
    List stuList;
    List teacherList;
    JComboBox teacherCB = new JComboBox();
    ComboBoxModel cbModel;
    int teacherCurSel = 0;

    public TeacherGUI() {
        this.teacherList = Client.requestTeacherList();
        try {
            this.u = (Teacher)this.teacherList.get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.voidList.addFocusListener(this);
        this.studentList.addFocusListener(this);
        this.viewReportButton.setEnabled(false);
        this.changePassButton.setEnabled(false);
    }

    public TeacherGUI(User u) {
        this.u = (Teacher)u;
        this.originalUser = (Teacher)u;
        this.teacherList = Client.requestTeacherList();
        Iterator it = this.teacherList.iterator();
        int i = 0;
        while (it.hasNext()) {
            Teacher temp2 = (Teacher)it.next();
            if (temp2.getUserName().equals(u.getUserName())) {
                this.teacherCurSel = i;
                u = (Teacher)this.teacherList.get(i);
            }
            ++i;
        }
        this.teacherCB = new JComboBox();
        this.teacherCB.addActionListener(this);
        this.teacherCB.setEnabled(false);
        this.voidList.addFocusListener(this);
        this.studentList.addFocusListener(this);
        this.viewReportButton.setEnabled(false);
        this.changePassButton.setEnabled(false);
        this.refreshCB();
    }

    public TeacherGUI(String name) {
        this.teacherList = Client.requestTeacherList();
        Iterator it = this.teacherList.iterator();
        int i = 0;
        while (it.hasNext()) {
            Teacher temp2 = (Teacher)it.next();
            if (temp2.getUserName().equals(name)) {
                this.teacherCurSel = i;
                this.u = (Teacher)this.teacherList.get(i);
            }
            ++i;
        }
        this.teacherCB = new JComboBox();
        this.teacherCB.addActionListener(this);
        this.teacherCB.setEnabled(false);
        this.refreshCB();
    }

    public void hideUI() {
        this.frame.dispose();
    }

    public void display() {
        this.frame = new JFrame();
        this.frame.setSize(800, 600);
        this.frame.addWindowListener(this);
        this.frame.setTitle("Teacher Control Panel");
        this.words = new WordTab(this.u, this.frame);
        this.initStudent();
        this.emailReportButton.addActionListener(this);
        JPanel mainPan = new JPanel();
        mainPan.setLayout(new BorderLayout());
        mainPan.add((Component)this.teacherCB, "North");
        JPanel center = new JPanel();
        center.setLayout(new BorderLayout());
        center.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Add/Remove Students From Your Class"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        center.add((Component)this.students, "Center");
        JPanel bottom = new JPanel();
        bottom.add(this.changePassButton);
        this.changePassButton.addActionListener(this);
        bottom.add(this.viewReportButton);
        this.viewReportButton.addActionListener(this);
        bottom.add(this.refreshButton);
        this.refreshButton.addActionListener(this);
        center.add((Component)bottom, "South");
        mainPan.add((Component)center, "Center");
        JPanel chpass = new JPanel();
        chpass.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Teacher Options"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        chpass.add(this.chpassButton);
        this.chpassButton.addActionListener(this);
        chpass.add(this.viewOverallReportButton);
        this.viewOverallReportButton.addActionListener(this);
        this.sub = new JPanel();
        this.sub.setLayout(new BorderLayout());
        if (this.u != null) {
            this.chbx.setSelected(Client.exists(String.valueOf(this.u.getUserName()) + "-sub"));
        }
        this.chbx.addItemListener(this);
        this.sub.add((Component)this.chbx, "North");
        chpass.add(this.sub);
        mainPan.add((Component)chpass, "South");
        this.tab.add("Student Control", mainPan);
        this.tab.add("Words", this.words.display());
        this.frame.getContentPane().add(this.tab);
        if (this.u != null) {
            this.stuList = this.u.getStudents();
        }
        this.tab.addFocusListener(this);
        this.refreshStudents();
        this.refreshVoid();
        if (this.u != null) {
            this.chpassButton.setText("Change " + this.u.getName() + "'s Password");
        }
        this.frame.setVisible(true);
    }

    public void initStudent() {
        this.students.setLayout(new BoxLayout(this.students, 2));
        this.students.add(Box.createHorizontalGlue());
        JPanel stuListPanel = new JPanel();
        stuListPanel.setLayout(new BoxLayout(stuListPanel, 3));
        stuListPanel.add(new JLabel("Students in your Class:"));
        stuListPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.studentListScroll.setSize(new Dimension(100, 100));
        stuListPanel.add(this.studentListScroll);
        stuListPanel.add(Box.createVerticalGlue());
        this.students.add(stuListPanel);
        this.students.add(Box.createHorizontalGlue());
        JPanel mid = new JPanel();
        mid.setLayout(new BoxLayout(mid, 0));
        mid.add(this.rightButton);
        this.rightButton.addActionListener(this);
        mid.add(Box.createRigidArea(new Dimension(0, 25)));
        mid.add(this.leftButton);
        this.leftButton.addActionListener(this);
        this.students.add(mid);
        this.students.add(Box.createHorizontalGlue());
        JPanel voidPanel = new JPanel();
        voidPanel.setLayout(new BoxLayout(voidPanel, 3));
        voidPanel.add(new JLabel("Students in no classes:"));
        voidPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.studentListScroll.setSize(new Dimension(100, 100));
        voidPanel.add(this.voidListScroll);
        voidPanel.add(Box.createVerticalGlue());
        this.students.add(voidPanel);
        this.students.add(Box.createHorizontalGlue());
    }

    public void refreshVoid() {
        this.lmodelvoid.clear();
        this.voids = Client.requestVoidStudentsList();
        int i = 0;
        while (i < this.voids.size()) {
            this.lmodelvoid.addElement(String.valueOf(((Student)this.voids.get(i)).getName()) + " - " + ((Student)this.voids.get(i)).getUserName());
            ++i;
        }
    }

    public void refreshStudents() {
        if (this.u != null) {
            this.stuList = this.u.getStudents();
            this.lmodelstu.clear();
            int i = 0;
            while (i < this.stuList.size()) {
                this.lmodelstu.addElement(String.valueOf(((Student)this.stuList.get(i)).getName()) + " - " + ((Student)this.stuList.get(i)).getUserName());
                ++i;
            }
        }
    }

    public void refreshCB() {
        this.teacherCB.removeActionListener(this);
        this.teacherCB.removeAllItems();
        Iterator it = this.teacherList.iterator();
        int me = -1;
        int i = 0;
        while (it.hasNext()) {
            Teacher temp2 = (Teacher)it.next();
            this.teacherCB.addItem(temp2);
            if (this.u != null && temp2.getName().equals(this.u.getName())) {
                me = i;
            }
            ++i;
        }
        if (this.teacherCB.getModel().getSize() != 0) {
            this.studentList.removeAll();
            this.teacherCB.setSelectedIndex(this.teacherCurSel);
        }
        this.teacherCB.setVisible(true);
        this.teacherCB.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        Student t;
        if (this.studentList.getSelectedIndex() >= 0) {
            Student s;
            if (e.getSource() == this.rightButton) {
                if (this.teacherCB.getModel().getSize() != 0) {
                    t = (Student)this.stuList.get(this.studentList.getSelectedIndex());
                    this.u.removeStudent(t);
                    t.setTeacher(null);
                    Client.sendUserUpdate(this.u);
                    Client.sendUserUpdate(t);
                    this.refreshStudents();
                    this.refreshVoid();
                }
            } else if (e.getSource() == this.changePassButton) {
                s = (Student)this.stuList.get(this.studentList.getSelectedIndex());
                String inputValue = JOptionPane.showInputDialog("New Password for " + s.getName() + ":");
                if (inputValue != null) {
                    s.setPassword(inputValue);
                    Client.sendUserUpdate(s);
                }
            } else if (e.getSource() == this.viewReportButton) {
                s = (Student)this.stuList.get(this.studentList.getSelectedIndex());
                JDialog report = new JDialog((Frame)this.frame, true);
                report.setDefaultCloseOperation(2);
                this.repUI = new ReportUI(s.getReport());
                report.getContentPane().add(this.repUI);
                report.setSize(520, 549);
                report.getContentPane().setLayout(new FlowLayout());
                report.getContentPane().add(this.emailReportButton);
                report.setVisible(true);
            } else if (e.getSource() == this.emailReportButton) {
                s = (Student)this.stuList.get(this.studentList.getSelectedIndex());
                Object[] buttons = new Object[]{"Cancel", "Save", "Save+Send"};
                this.emailInfo.SMTPServer.setText(this.u.getServer());
                this.emailInfo.teachPass.setText(this.u.getEmailPass());
                this.emailInfo.teachEmail.setText(this.u.getEmailAccount());
                this.emailInfo.stuEmail.setText(s.getEmail());
                int numPicked = JOptionPane.showOptionDialog(null, this.emailInfo, "Email Report", 0, 0, null, buttons, buttons[2]);
                if (numPicked != 0) {
                    if (numPicked == 1) {
                        this.u.setServer(this.emailInfo.SMTPServer.getText());
                        this.u.setEmailPass(new String(this.emailInfo.teachPass.getPassword()));
                        this.u.setEmailAccount(this.emailInfo.teachEmail.getText());
                        s.setEmail(this.emailInfo.stuEmail.getText());
                    } else if (numPicked == 2) {
                        this.u.setServer(this.emailInfo.SMTPServer.getText());
                        this.u.setEmailPass(new String(this.emailInfo.teachPass.getPassword()));
                        this.u.setEmailAccount(this.emailInfo.teachEmail.getText());
                        s.setEmail(this.emailInfo.stuEmail.getText());
                        SMTPMailer.sendMessage(this.u.getServer(), this.u.getEmailAccount(), s.getEmail(), "Student Report(" + s.getName() + ")", s.getReport().getPrintableReport(), this.u.getEmailPass());
                    }
                }
                Client.sendUserUpdate(this.u);
                Client.sendUserUpdate(s);
            }
        }
        if (e.getSource() == this.refreshButton) {
            this.refreshStudents();
            this.refreshVoid();
        } else if (e.getSource() == this.leftButton && this.voidList.getSelectedIndex() >= 0) {
            t = (Student)this.voids.get(this.voidList.getSelectedIndex());
            t.setTeacher(this.u);
            Client.sendUserUpdate(t);
            this.refreshStudents();
            this.refreshVoid();
        } else if (e.getSource() == this.chpassButton) {
            String inputValue = JOptionPane.showInputDialog("New Password for " + this.u.getName() + ":");
            if (inputValue != null) {
                this.u.setPassword(inputValue);
            }
        } else if (e.getSource() == this.viewOverallReportButton) {
            List stuList = this.u.getStudents();
            Report teachReport = new Report();
            teachReport.setName(this.u.getName());
            int i = 0;
            while (i < stuList.size()) {
                System.out.println(((Student)stuList.get(i)).getReport().getDate());
                teachReport.update(((Student)stuList.get(i)).getReport());
                ++i;
            }
            ReportUI ui = new ReportUI(teachReport);
            JDialog report = new JDialog((Frame)this.frame, true);
            report.setDefaultCloseOperation(2);
            this.repUI = new ReportUI(teachReport);
            report.getContentPane().add(this.repUI);
            report.setSize(520, 549);
            report.setVisible(true);
        } else if (e.getSource() instanceof JComboBox) {
            try {
                JComboBox ch = (JComboBox)e.getSource();
                if (ch.getSelectedIndex() != -1) {
                    Client.sendUserUpdate(this.u);
                    this.u = (Teacher)this.teacherList.get(ch.getSelectedIndex());
                    this.chpassButton.setText("Change " + this.u.getName() + "'s Password");
                    this.chbx.removeItemListener(this);
                    this.chbx.setSelected(Client.exists(String.valueOf(this.u.getUserName()) + "-sub"));
                    this.chbx.addItemListener(this);
                    this.teacherCurSel = ch.getSelectedIndex();
                    this.refreshStudents();
                    this.refreshVoid();
                    this.words.refreshWordList(this.u);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) throws Exception {
        TeacherGUI ui = new TeacherGUI(Client.getUser("ProfLudi", "se1"));
        ui.display();
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        this.originalUser.notifyLogout();
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }

    public void focusGained(FocusEvent arg0) {
        if (arg0.getSource() == this.voidList) {
            this.studentList.clearSelection();
            this.viewReportButton.setEnabled(false);
            this.changePassButton.setEnabled(false);
        } else if (arg0.getSource() == this.studentList) {
            this.voidList.clearSelection();
            this.viewReportButton.setEnabled(true);
            this.changePassButton.setEnabled(true);
        } else {
            this.refreshCB();
            this.refreshStudents();
            this.refreshVoid();
        }
    }

    public void focusLost(FocusEvent arg0) {
    }

    public void addSubTeacher(String password) {
        Client.sendUserUpdate(new SubstituteTeacher(String.valueOf(this.u.getUserName()) + "-sub", password, this.u.getUserName(), this.u.getPassword()));
    }

    public void removeSubTeacher() {
        Client.removeUser(String.valueOf(this.u.getUserName()) + "-sub");
    }

    public void itemStateChanged(ItemEvent e) {
        boolean isSelected = ((JCheckBox)e.getSource()).isSelected();
        if (isSelected) {
            String inputValue = null;
            inputValue = JOptionPane.showInputDialog("New Password for " + this.u.getUserName() + "-sub " + ":");
            if (inputValue != null && !inputValue.equals("")) {
                this.addSubTeacher(inputValue);
            } else {
                JOptionPane.showMessageDialog(this.frame, "Must Enter a password!", "Error", 0);
                this.chbx.removeItemListener(this);
                this.chbx.setSelected(false);
                this.chbx.addItemListener(this);
            }
        } else {
            this.removeSubTeacher();
        }
    }

    private class EmailInfo
    extends JPanel {
        public JTextField SMTPServer = new JTextField(15);
        public JTextField teachEmail = new JTextField(15);
        public JPasswordField teachPass = new JPasswordField(15);
        public JTextField stuEmail = new JTextField(15);

        public EmailInfo() {
            this.setLayout(new BoxLayout(this, 0));
            Box labelPanel = Box.createVerticalBox();
            JPanel textPanel = new JPanel();
            labelPanel.add(new JLabel("Student's Email Address: "));
            labelPanel.add(Box.createVerticalGlue());
            labelPanel.add(new JLabel("SMTP Server: "));
            labelPanel.add(Box.createVerticalGlue());
            labelPanel.add(new JLabel("Your Email Address: "));
            labelPanel.add(Box.createVerticalGlue());
            labelPanel.add(new JLabel("Your Email Password: "));
            labelPanel.add(Box.createVerticalGlue());
            textPanel.setLayout(new BoxLayout(textPanel, 1));
            textPanel.add(this.stuEmail);
            textPanel.add(this.SMTPServer);
            textPanel.add(this.teachEmail);
            textPanel.add(this.teachPass);
            this.add(labelPanel);
            this.add(textPanel);
        }
    }
}

