/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UserDatabase
implements Serializable {
    Map users = new HashMap();
    public static final long serialVersionUID = -7787408436345765739L;

    public void addUser(User u) {
        if (this.users.containsKey(u.getUserName())) {
            User original = (User)this.users.get(u.getUserName());
            if (u instanceof Student) {
                Student originalStudent = (Student)original;
                Student uStudent = (Student)u;
                originalStudent.copy(uStudent);
                Teacher uTeacher = uStudent.getTeacher();
                if (uTeacher != null) {
                    originalStudent.copyTeacher((Teacher)this.users.get(uStudent.getTeacher().getUserName()));
                } else {
                    originalStudent.setTeacher(null);
                }
            } else if (u instanceof Teacher) {
                Teacher originalTeacher = (Teacher)original;
                Teacher uTeacher = (Teacher)u;
                originalTeacher.copy(uTeacher);
                List stuList = uTeacher.getStudents();
                originalTeacher.clearStudents();
                int i = 0;
                while (i < stuList.size()) {
                    originalTeacher.copyStudents((Student)stuList.get(i));
                    ++i;
                }
            } else {
                this.users.put(u.getUserName(), u);
            }
        } else {
            this.users.put(u.getUserName(), u);
        }
    }

    public boolean exists(String username) {
        return this.users.containsKey(username);
    }

    public boolean removeUser(String username) {
        User rem = (User)this.users.get(username);
        if (rem == null) {
            return false;
        }
        this.users.remove(username);
        return true;
    }

    public void rebuildReferences() {
        List teachers = this.getTeachers();
        Iterator it = teachers.iterator();
        int i = 0;
        while (i < teachers.size()) {
            Teacher curTeacher = (Teacher)teachers.get(i);
            List stuList = curTeacher.getStudents();
            int j = 0;
            while (j < stuList.size()) {
                Student stu = (Student)stuList.get(j);
                stuList.remove(j);
                stuList.add(this.users.get(stu.getUserName()));
                ++j;
            }
            ++i;
        }
    }

    public User getUser(String username, String password) {
        User ret = (User)this.users.get(username);
        if (ret == null) {
            return null;
        }
        if (ret.getPassword().equals(password)) {
            return ret;
        }
        return null;
    }

    public List getTeachers() {
        ArrayList ret = new ArrayList();
        Collection l = this.users.values();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Object u = it.next();
            if (!(u instanceof Teacher)) continue;
            ret.add(u);
        }
        Collections.sort(ret);
        return ret;
    }

    public List getVoidStudents() {
        ArrayList ret = new ArrayList();
        Collection l = this.users.values();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Object u = it.next();
            if (!(u instanceof Student) || ((Student)u).getTeacher() != null) continue;
            ret.add(u);
        }
        Collections.sort(ret);
        return ret;
    }

    public List getAllUsers() {
        Collection l = this.users.values();
        ArrayList ret = new ArrayList(l);
        Collections.sort(ret);
        return ret;
    }

    public void save(String file) {
        try {
            FileOutputStream f = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(f);
            oos.writeObject(this);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static UserDatabase open(String file) {
        UserDatabase ret = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            ret = (UserDatabase)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void main(String[] args) {
        Client.setIP("127.0.0.1");
        Client.setPort(3000);
        List tlist = Client.requestTeacherList();
        Teacher teach = (Teacher)Client.getUser("ProfLudi", "se1");
        teach.setName("blah");
        Client.sendUserUpdate(teach);
        List slist = teach.getStudents();
        Student stu = (Student)slist.get(0);
        System.out.println("Stu: " + stu.getName());
        stu.getTeacher().setName("I rock.");
        stu.setName("I love myself.");
        Client.sendUserUpdate(teach);
        Student sameStu = (Student)Client.getUser(stu.getUserName(), stu.getPassword());
        System.out.println("Same Stu: " + sameStu.getName());
        System.out.println("Teacher's Name: " + sameStu.getTeacher().getName());
    }
}

