/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.io.Serializable;
import java.util.TreeSet;
import javax.swing.ImageIcon;

public class Word
implements Comparable,
Serializable {
    private String spelling;
    private ImageWrapper picture;
    private String audio;
    private String definition;
    private TreeSet commonMisspellings = new TreeSet();
    private String picPath;
    public static final String FIELD_DELIM = "~";
    public static final String MISSPELL_DELIM = ",";

    public static Word readWord(String theWord) throws InvalidWordException {
        Word newWord = new Word("a");
        String[] wordFields = theWord.split(FIELD_DELIM, -1);
        String[] misspellingToAdd = new String[]{};
        if (!wordFields[4].equals("")) {
            misspellingToAdd = wordFields[4].split(MISSPELL_DELIM);
        }
        newWord.setSpelling(wordFields[0]);
        if (!wordFields[2].equals("")) {
            newWord.setAudio(wordFields[2]);
        } else {
            newWord.setAudio(wordFields[0]);
        }
        newWord.setDef(wordFields[1]);
        try {
            newWord.setImagePath(wordFields[3]);
        }
        catch (ImageNotFoundException imageNotFoundException) {
            // empty catch block
        }
        newWord.addMistake(misspellingToAdd);
        return newWord;
    }

    public Word(Word w) throws InvalidWordException {
        this.setSpelling(w.spelling);
        this.setAudio(w.audio);
        this.setDef(w.definition);
        try {
            this.setImagePath(w.picPath);
        }
        catch (ImageNotFoundException imageNotFoundException) {
            // empty catch block
        }
        this.commonMisspellings = new TreeSet();
        this.commonMisspellings.add(w.getMistakes());
    }

    public Word(String theWord, String def, String picPath, String pronunciation, String[] commonMistakes) throws InvalidWordException {
        this.setSpelling(theWord);
        this.setAudio(pronunciation);
        this.setDef(def);
        try {
            this.setImagePath(picPath);
        }
        catch (ImageNotFoundException imageNotFoundException) {
            // empty catch block
        }
        this.addMistake(commonMistakes);
        this.commonMisspellings = new TreeSet();
    }

    public Word(String theWord) throws InvalidWordException {
        this.picPath = "";
        this.picture = null;
        this.setSpelling(theWord);
        this.setAudio(theWord);
        this.setDef("");
    }

    public Image getImage() {
        if (this.picture == null) {
            return null;
        }
        return this.picture.getImage();
    }

    public String toString() {
        String[] theMisspellings = new String[this.commonMisspellings.size()];
        String retString = new String(String.valueOf(this.spelling) + FIELD_DELIM + this.definition + FIELD_DELIM + this.audio + FIELD_DELIM + this.picPath + FIELD_DELIM);
        this.commonMisspellings.toArray(theMisspellings);
        int i = 0;
        while (i < theMisspellings.length) {
            retString = String.valueOf(retString) + theMisspellings[i] + MISSPELL_DELIM;
            ++i;
        }
        return retString;
    }

    public String getSpelling() {
        return this.spelling;
    }

    public String getAudio() {
        if (this.audio == null || this.audio.equals("")) {
            return this.getSpelling();
        }
        return this.audio;
    }

    public String getDef() {
        return this.definition;
    }

    public String getHint() {
        return this.definition;
    }

    public Object[] getMistakes() {
        if (this.commonMisspellings == null) {
            return null;
        }
        return this.commonMisspellings.toArray();
    }

    public String getImagePath() {
        return this.picPath;
    }

    public void setImagePath(String pathName) throws ImageNotFoundException {
        if (pathName.indexOf(FIELD_DELIM) == -1) {
            ImageIcon i = new ImageIcon(pathName);
            if (i.getImageLoadStatus() == 4) {
                this.picture = null;
                this.picPath = "";
                throw new ImageNotFoundException("The image at: " + pathName + " was not found, or the type was not .png, .gif, or .jpg");
            }
            i.setImage(i.getImage().getScaledInstance(GFX_CONSTANTS.MINIMUM_IMAGE_SIZE.width, GFX_CONSTANTS.MINIMUM_IMAGE_SIZE.height, 1));
            this.picture = new ImageWrapper(i.getImage());
            this.picPath = pathName;
        }
    }

    public void setSpelling(String newSpelling) throws InvalidWordException {
        if (newSpelling == null || newSpelling.equals("")) {
            throw new InvalidWordException("The spelling given was null or empty.");
        }
        if (newSpelling.indexOf(FIELD_DELIM) != -1) {
            throw new InvalidWordException("The spelling given contained an illegal character: ~");
        }
        if (newSpelling.indexOf(" ") != -1) {
            throw new InvalidWordException("The spelling of a word may not contain spaces.");
        }
        this.spelling = newSpelling;
    }

    public void setAudio(String newAudio) {
        if (newAudio.indexOf(FIELD_DELIM) == -1) {
            this.audio = newAudio;
        }
    }

    public void setDef(String newDef) {
        if (newDef.indexOf(FIELD_DELIM) == -1) {
            this.definition = newDef;
        }
    }

    public void setHint(String newHint) {
        if (newHint.indexOf(FIELD_DELIM) == -1) {
            this.definition = newHint;
        }
    }

    public void addMistake(String newMistake) {
        if (newMistake.indexOf(FIELD_DELIM) == -1 && newMistake.indexOf(MISSPELL_DELIM) == -1) {
            this.commonMisspellings.add(new String(newMistake));
        }
    }

    public void addMistake(String[] newMistake) {
        int i = 0;
        while (i < newMistake.length) {
            if (newMistake[i].indexOf(FIELD_DELIM) == -1 && newMistake[i].indexOf(MISSPELL_DELIM) == -1) {
                this.commonMisspellings.add(new String(newMistake[i]));
            }
            ++i;
        }
    }

    public void removeMistake(String oldMistake) {
        if (oldMistake != null) {
            this.commonMisspellings.remove(oldMistake);
        }
    }

    public int numMistakes() {
        return this.commonMisspellings.size();
    }

    public int compareTo(Object otherWord) {
        return this.spelling.compareTo(((Word)otherWord).spelling);
    }

    public boolean equals(Object o) {
        return o instanceof Word && this.spelling.equals(((Word)o).spelling);
    }
}

