/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class WordGraphicalEditor
extends JPanel
implements ActionListener,
FocusListener,
Displayable {
    public static final String SAVED = "Changes Saved";
    public static final String RESTORED = "Changes Restored";
    public static final String UNABLE = "Changes Saved";
    public static final String PENDING = "Unsaved Changes";
    private Word myWord;
    private Word realWord;
    private JTextField spelling;
    private JTextArea definition;
    private JTextField sound;
    private JTextField picturePath;
    private JTextField newMisspelling;
    private JButton playSound;
    private JButton addRemoveButton;
    private JList misspellList;
    private final JLabel saveState = new JLabel("Changes Saved");
    private final JButton undoChange = new JButton("Undo");
    private JPanel picPanel = new JPanel();
    private JPanel editSpelling = new JPanel();
    private JPanel editDef = new JPanel();
    private JPanel editSound = new JPanel();
    private JPanel editImage = new JPanel();
    private JPanel editMisspelling = new JPanel();
    private JButton browseButton = new JButton("Browse");

    public WordGraphicalEditor(Word w) {
        this.removeAll();
        this.myWord = w;
        this.spelling = new JTextField(10);
        this.definition = new JTextArea(3, 10);
        this.picturePath = new JTextField(10);
        this.picturePath.setEditable(false);
        this.picturePath.setBackground(Color.WHITE);
        this.sound = new JTextField(10);
        this.playSound = new JButton();
        this.addRemoveButton = new JButton();
        this.picPanel = new JPanel();
        this.newMisspelling = new JTextField(10);
        this.misspellList = new JList();
        this.buildDisplay(w);
    }

    public JPanel buildDisplay(Word w) {
        this.removeAll();
        this.myWord = w;
        this.definition.setText(this.myWord.getDef());
        this.spelling.setText(this.myWord.getSpelling());
        this.picturePath.setText(this.myWord.getImagePath());
        this.sound.setText(this.myWord.getAudio());
        this.editSpelling = this.makeEditSpellingPane();
        this.editSpelling.setOpaque(false);
        this.editDef = this.makeEditDefPane();
        this.editDef.setOpaque(false);
        this.editSound = this.makeEditSoundPane();
        this.editSound.setOpaque(false);
        this.editImage = this.makeEditImagePane();
        this.editImage.setOpaque(false);
        this.editMisspelling = this.makeEditMisspellingPane();
        this.editMisspelling.setOpaque(false);
        this.picPanel = this.makeDisplayImagePane();
        this.makeDisplay();
        this.updateUI();
        this.setVisible(true);
        this.setOpaque(true);
        return this;
    }

    public JPanel getDisplay() {
        return this;
    }

    private void makeDisplay() {
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Word Editor"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.setLayout(gridBag);
        c.anchor = 11;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.gridx = 0;
        c.fill = 2;
        c.gridy = 1;
        this.add((Component)this.editSpelling, c);
        c.gridy = 2;
        this.add((Component)this.editDef, c);
        c.gridy = 3;
        this.add((Component)this.editSound, c);
        c.gridy = 4;
        this.add((Component)this.editImage, c);
        c.gridwidth = 1;
        c.gridy = 5;
        c.gridx = 1;
        this.add((Component)this.picPanel, c);
        c.gridheight = 2;
        c.gridy = 5;
        c.gridx = 0;
        this.add((Component)this.editMisspelling, c);
        c.gridy = 6;
        c.gridx = 1;
        JPanel tmpPanel = new JPanel();
        this.saveState.setMinimumSize(new Dimension(125, 16));
        this.saveState.setPreferredSize(new Dimension(125, 16));
        tmpPanel.add(this.saveState);
        this.add((Component)tmpPanel, c);
        this.addListeners();
    }

    private void addListeners() {
        this.misspellList.addFocusListener(this);
        this.addRemoveButton.addFocusListener(this);
        this.playSound.addActionListener(this);
        this.addRemoveButton.addActionListener(this);
        this.browseButton.addActionListener(this);
        DocumentListener docuListen = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                WordGraphicalEditor.this.saveState.setText(WordGraphicalEditor.PENDING);
            }

            public void removeUpdate(DocumentEvent e) {
                WordGraphicalEditor.this.saveState.setText(WordGraphicalEditor.PENDING);
            }
        };
        FocusListener listen = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    if (e.getOppositeComponent() == WordGraphicalEditor.this.undoChange) {
                        WordGraphicalEditor.this.saveState.setText(WordGraphicalEditor.RESTORED);
                        WordGraphicalEditor.this.spelling.setText(WordGraphicalEditor.this.myWord.getSpelling());
                    } else {
                        try {
                            WordGraphicalEditor.this.myWord.setSpelling(((JTextComponent)e.getSource()).getText());
                        }
                        catch (InvalidWordException ex) {
                            JOptionPane.showMessageDialog(null, ex.toString(), "Error", 0);
                            ((JTextComponent)e.getSource()).setText(WordGraphicalEditor.this.myWord.getSpelling());
                            WordGraphicalEditor.this.spelling.setText(WordGraphicalEditor.this.myWord.getSpelling());
                        }
                        WordGraphicalEditor.this.saveState.setText("Changes Saved");
                    }
                }
            }
        };
        this.spelling.addFocusListener(listen);
        listen = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    if (e.getOppositeComponent() == WordGraphicalEditor.this.undoChange) {
                        WordGraphicalEditor.this.saveState.setText(WordGraphicalEditor.RESTORED);
                        WordGraphicalEditor.this.definition.setText(WordGraphicalEditor.this.myWord.getDef());
                    } else {
                        WordGraphicalEditor.this.myWord.setDef(((JTextComponent)e.getSource()).getText());
                        WordGraphicalEditor.this.definition.setText(WordGraphicalEditor.this.myWord.getDef());
                        WordGraphicalEditor.this.saveState.setText("Changes Saved");
                    }
                }
            }
        };
        this.definition.addFocusListener(listen);
        listen = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != WordGraphicalEditor.this.playSound && e.getOppositeComponent() != WordGraphicalEditor.this.sound && !e.isTemporary()) {
                    if (e.getOppositeComponent() == WordGraphicalEditor.this.undoChange) {
                        WordGraphicalEditor.this.saveState.setText(WordGraphicalEditor.RESTORED);
                        WordGraphicalEditor.this.sound.setText(WordGraphicalEditor.this.myWord.getAudio());
                    } else {
                        WordGraphicalEditor.this.myWord.setAudio(WordGraphicalEditor.this.sound.getText());
                        WordGraphicalEditor.this.sound.setText(WordGraphicalEditor.this.myWord.getAudio());
                        WordGraphicalEditor.this.saveState.setText("Changes Saved");
                    }
                }
            }
        };
        this.sound.addFocusListener(listen);
        this.playSound.addFocusListener(listen);
        listen = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    if (e.getOppositeComponent() == WordGraphicalEditor.this.undoChange) {
                        WordGraphicalEditor.this.saveState.setText(WordGraphicalEditor.RESTORED);
                        WordGraphicalEditor.this.picturePath.setText(WordGraphicalEditor.this.myWord.getImagePath());
                    } else {
                        try {
                            WordGraphicalEditor.this.myWord.setImagePath(((JTextComponent)e.getSource()).getText());
                        }
                        catch (ImageNotFoundException imageNotFoundException) {
                            // empty catch block
                        }
                        WordGraphicalEditor.this.picturePath.setText(WordGraphicalEditor.this.myWord.getImagePath());
                        WordGraphicalEditor.this.saveState.setText("Changes Saved");
                    }
                    WordGraphicalEditor.this.makeDisplayImagePane();
                }
            }
        };
        this.picturePath.addFocusListener(listen);
        this.definition.getDocument().addDocumentListener(docuListen);
        this.sound.getDocument().addDocumentListener(docuListen);
        this.picturePath.getDocument().addDocumentListener(docuListen);
        this.spelling.getDocument().addDocumentListener(docuListen);
    }

    private JPanel makeEditSpellingPane() {
        return SpringUtilities.makeFormPanel("Spelling:            ", this.spelling);
    }

    private JPanel makeEditDefPane() {
        return SpringUtilities.makeFormPanel("Definition:          ", this.definition);
    }

    private JPanel makeEditSoundPane() {
        JPanel pane = SpringUtilities.makeFormPanel("Pronunciation: ", this.sound);
        this.playSound = new JButton();
        this.playSound.setIcon(new ImageIcon("images/sound.gif"));
        pane.add(this.playSound);
        this.playSound.setActionCommand("Play Sound");
        SpringUtilities.makeCompactGrid(pane, 1, 3, 6, 6, 4, 4);
        return pane;
    }

    private JPanel makeEditImagePane() {
        JPanel pane = SpringUtilities.makeFormPanel("Image Path: ", this.picturePath);
        pane.add(this.browseButton);
        SpringUtilities.makeCompactGrid(pane, 1, 3, 6, 6, 4, 4);
        return pane;
    }

    private JPanel makeDisplayImagePane() {
        this.picPanel.removeAll();
        if (this.myWord.getImage() != null) {
            ImageIcon tmpIcon = new ImageIcon(this.myWord.getImage());
            tmpIcon.setImage(tmpIcon.getImage().getScaledInstance(GFX_CONSTANTS.MINIMUM_IMAGE_SIZE.width, GFX_CONSTANTS.MINIMUM_IMAGE_SIZE.height, 1));
            JLabel tmpPicture = new JLabel(tmpIcon);
            this.picPanel.setMinimumSize(GFX_CONSTANTS.MINIMUM_IMAGE_SIZE);
            this.picPanel.setPreferredSize(GFX_CONSTANTS.MINIMUM_IMAGE_SIZE);
            this.picPanel.add(tmpPicture);
        }
        this.picturePath.setText(this.myWord.getImagePath());
        this.updateUI();
        return this.picPanel;
    }

    private void updateMisspellingList() {
        this.misspellList.setListData(this.myWord.getMistakes());
    }

    private JPanel makeEditMisspellingPane() {
        JPanel pane = new JPanel();
        this.updateMisspellingList();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Edit Common Misspellings"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        pane.setLayout(gridBag);
        c.anchor = 17;
        c.weightx = 0.0;
        c.gridx = 0;
        this.misspellList.setPrototypeCellValue("index 1234567890");
        JScrollPane scrollPane = new JScrollPane(this.misspellList);
        scrollPane.setPreferredSize(new Dimension(126, 162));
        scrollPane.setMinimumSize(new Dimension(86, 50));
        c.gridy = 0;
        c.gridx = 0;
        pane.add((Component)scrollPane, c);
        c.gridy = 0;
        c.gridx = 1;
        this.addRemoveButton.setText("Add");
        this.addRemoveButton.setPreferredSize(new Dimension(80, 26));
        pane.add(this.addRemoveButton);
        c.gridx = 0;
        c.gridy = 1;
        pane.add((Component)this.newMisspelling, c);
        return pane;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.playSound.getActionCommand())) {
            Speaker.myVoice.speak(this.sound.getText());
        } else if (e.getActionCommand().equals("Remove")) {
            this.myWord.removeMistake((String)this.misspellList.getSelectedValue());
            this.saveState.setText("Changes Saved");
            this.updateMisspellingList();
        } else if (e.getActionCommand().equals("Add")) {
            this.saveState.setText("Changes Saved");
            if (!this.newMisspelling.getText().equals("")) {
                this.myWord.addMistake(this.newMisspelling.getText());
                this.newMisspelling.setText("");
            }
            this.updateMisspellingList();
        } else if (e.getActionCommand().equals("Browse")) {
            JFileChooser chooser = new JFileChooser("images/");
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("jpg");
            filter.addExtension("gif");
            filter.addExtension("png");
            filter.setDescription("jpg gif and png files");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                try {
                    String path = chooser.getSelectedFile().getPath();
                    path = path.replace('\\', '/');
                    this.myWord.setImagePath(path);
                    this.makeDisplayImagePane();
                    this.updateUI();
                }
                catch (ImageNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.misspellList) {
            this.addRemoveButton.setText("Remove");
            this.addRemoveButton.setActionCommand("Remove");
        }
    }

    public void focusLost(FocusEvent e) {
        if (!(e.getOppositeComponent() == this.addRemoveButton || e.isTemporary() || e.getSource() != this.misspellList && e.getSource() != this.addRemoveButton)) {
            this.misspellList.clearSelection();
            this.addRemoveButton.setText("Add");
            this.addRemoveButton.setActionCommand("Add");
            this.saveState.setText("Changes Saved");
        } else {
            this.saveState.setText("Changes Saved");
        }
    }

    public static void main(String[] args) throws Exception {
        String[] data = new String[]{"one", "two", "three", "four", "five", "six", "seve", "eigh", "nine"};
        JFrame f = new JFrame();
        Container pane = f.getContentPane();
        f.setBackground(Color.red);
        f.setSize(520, 549);
        Word w = new Word("test");
        WordGraphicalEditor wgd = new WordGraphicalEditor(w);
        JPanel tmpPanel = wgd.getDisplay();
        tmpPanel.setBackground(Color.red);
        pane.add(tmpPanel);
        f.setVisible(true);
    }
}

