/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class WordList
extends TreeSet
implements Serializable {
    private String name;

    public WordList() {
        this.name = "Unnamed Word List";
    }

    public WordList(String listName) {
        this.name = listName;
    }

    public boolean add(Object o) {
        if (o instanceof Word) {
            return super.add(o);
        }
        return false;
    }

    public boolean add(WordList w) {
        boolean returnValue = false;
        ArrayList words = w.toArrayList();
        if (words != null) {
            int i = 0;
            while (i < words.size()) {
                if (this.add(words.get(i))) {
                    returnValue = true;
                }
                ++i;
            }
        }
        return returnValue;
    }

    public boolean remove(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.size() != 0) {
            Iterator iter = this.iterator();
            int i = 0;
            while (i < index) {
                iter.next();
                ++i;
            }
            if (this.remove(iter.next())) {
                return true;
            }
        }
        return false;
    }

    public Word getWord() {
        int setSize = this.size();
        if (setSize != 0) {
            int wordIndex = (int)(Math.random() * (double)setSize);
            Iterator iter = this.iterator();
            Object randWord = null;
            try {
                int i = 0;
                while (i < wordIndex) {
                    iter.next();
                    ++i;
                }
                return (Word)iter.next();
            }
            catch (NoSuchElementException e) {
                System.err.println("WordList Failure - Element could not be found.");
            }
        }
        return null;
    }

    public Word getWord(int wordIndex) throws IndexOutOfBoundsException {
        if (wordIndex < 0 || wordIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.size() != 0) {
            Word theWord = null;
            Iterator iter = this.iterator();
            int i = 0;
            while (i < wordIndex) {
                iter.next();
                ++i;
            }
            Object tempWord = iter.next();
            if (tempWord instanceof Word) {
                theWord = (Word)tempWord;
            }
            return theWord;
        }
        return null;
    }

    public Word getWord(String theWord) {
        Word word = null;
        try {
            word = new Word(theWord);
        }
        catch (InvalidWordException ex) {
            System.err.println("Error: Not a valid word.");
        }
        if (this.contains(word)) {
            ArrayList list = this.toArrayList();
            return (Word)list.get(list.indexOf(word));
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void resort() {
        ArrayList list = this.toArrayList();
        if (list != null) {
            this.clear();
            int i = 0;
            while (i < list.size()) {
                this.add((Word)list.get(i));
                ++i;
            }
        }
    }

    public ArrayList toArrayList() {
        if (this.size() != 0) {
            Iterator iter = this.iterator();
            ArrayList<Word> setAsList = new ArrayList<Word>();
            while (iter.hasNext()) {
                setAsList.add((Word)iter.next());
            }
            return setAsList;
        }
        return null;
    }

    public String toString() {
        String ret = "";
        int i = 0;
        while (i < this.size()) {
            ret = String.valueOf(ret) + " " + this.getWord(i);
            ++i;
        }
        return ret;
    }
}

