/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class WordListEditorUI
implements Displayable,
ActionListener {
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private JFrame masterFrame = null;
    private JLabel listHeader = new JLabel("No list selected");
    private DefaultListModel listContents;
    private JList listOfWords;
    private WordList realList = null;
    private Word editingWord;
    private Word oldWord;
    private boolean disabled = false;
    private final String INSTRUCTIONS = "<HTML>All the words in your list are displayed above.<br>Add, edit, and remove words with the buttons on<br>the right.  You can clear the list to remove every<br>word at once.</HTML>";

    public WordListEditorUI() {
        this.listHeader.setBorder(new EmptyBorder(4, 8, 4, 8));
        this.mainPanel.add((Component)this.listHeader, "North");
        JLabel l2 = new JLabel("<HTML>All the words in your list are displayed above.<br>Add, edit, and remove words with the buttons on<br>the right.  You can clear the list to remove every<br>word at once.</HTML>", 2);
        l2.setBorder(new EmptyBorder(8, 16, 8, 16));
        this.mainPanel.add((Component)l2, "South");
        GridLayout subPanelLayout = new GridLayout(0, 2);
        subPanelLayout.setHgap(18);
        JPanel subPanel = new JPanel(subPanelLayout);
        subPanel.setBorder(new EmptyBorder(16, 16, 16, 16));
        this.listContents = new DefaultListModel();
        this.listOfWords = new JList(this.listContents);
        this.listOfWords.setSelectionMode(0);
        this.listOfWords.setSelectedIndex(-1);
        this.listOfWords.setPrototypeCellValue("index 1234567890");
        JScrollPane wordPane = new JScrollPane(this.listOfWords);
        subPanel.add(wordPane);
        GridLayout buttonsLayout = new GridLayout(4, 0);
        buttonsLayout.setVgap(4);
        JPanel wlButtons = new JPanel(buttonsLayout);
        wlButtons.setBorder(new EmptyBorder(0, 12, 0, 12));
        JButton newWordButton = new JButton("New Word");
        newWordButton.addActionListener(this);
        JButton edtWordButton = new JButton("Edit Word");
        edtWordButton.addActionListener(this);
        JButton remWordButton = new JButton("Remove Word");
        remWordButton.addActionListener(this);
        JButton clrWordButton = new JButton("Clear List");
        clrWordButton.addActionListener(this);
        wlButtons.add(newWordButton);
        wlButtons.add(edtWordButton);
        wlButtons.add(remWordButton);
        wlButtons.add(clrWordButton);
        subPanel.add(wlButtons);
        this.mainPanel.add((Component)subPanel, "Center");
    }

    public WordListEditorUI(WordList w) {
        this();
        this.loadNewList(w);
    }

    public WordListEditorUI(WordList w, JFrame f) {
        this();
        this.masterFrame = f;
        this.loadNewList(w);
    }

    public void actionPerformed(ActionEvent e) {
        String buttonHit = e.getActionCommand();
        if (!this.disabled) {
            int index;
            if (buttonHit.equals("New Word") && this.realList != null) {
                this.editingWord = null;
                this.oldWord = null;
                try {
                    this.editingWord = new Word("newword");
                }
                catch (InvalidWordException ex) {
                    System.err.println("Invalid Word Exception!");
                }
                this.showWordEditor(this.editingWord);
            }
            if ((index = this.listOfWords.getSelectedIndex()) != -1) {
                if (buttonHit.equals("Edit Word")) {
                    this.oldWord = this.editingWord = this.realList.getWord(index);
                    this.realList.remove(this.editingWord);
                    this.showWordEditor(this.editingWord);
                }
                if (buttonHit.equals("Remove Word") && JOptionPane.showConfirmDialog(this.masterFrame, "Are you sure want to delete\nthe word " + this.listContents.elementAt(index) + "?", "Delete word?", 0) == 0) {
                    this.listContents.remove(index);
                    this.realList.remove(index);
                }
            }
            if (buttonHit.equals("Clear List") && this.listContents.size() > 0 && JOptionPane.showConfirmDialog(this.masterFrame, "Are you sure want to delete\nevery word in this list?", "Clear entire list?", 0) == 0) {
                this.listOfWords.setSelectedIndex(-1);
                this.listContents.clear();
                this.realList.clear();
            }
        }
    }

    public void clearDisplay() {
        this.loadNewList(null);
    }

    public void refreshDisplay() {
        this.listContents.clear();
        if (this.realList != null) {
            this.listHeader.setText("List :  " + this.realList.getName());
            int i = 0;
            while (i < this.realList.size()) {
                this.listContents.addElement(this.realList.getWord(i).getSpelling());
                ++i;
            }
        } else {
            this.listHeader.setText("No list selected");
        }
    }

    public JPanel getDisplay() {
        return this.mainPanel;
    }

    public void loadNewList(WordList w) {
        this.realList = w;
        this.listOfWords.setSelectedIndex(-1);
        this.listContents.clear();
        if (this.realList != null) {
            this.listHeader.setText("List :  " + this.realList.getName());
            int i = 0;
            while (i < this.realList.size()) {
                this.listContents.addElement(this.realList.getWord(i).getSpelling());
                ++i;
            }
        } else {
            this.listHeader.setText("No list selected");
        }
    }

    public void showWordEditor(Word w) {
        JInternalFrame wordEditor = new JInternalFrame("Word Editor", true, true, false, false);
        wordEditor.setSize(520, 550);
        wordEditor.setLocation(32, 32);
        wordEditor.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent e) {
                WordListEditorUI.this.disabled = false;
                WordListEditorUI.this.realList.resort();
                if (!WordListEditorUI.this.realList.add(WordListEditorUI.this.editingWord) && WordListEditorUI.this.oldWord != null) {
                    WordListEditorUI.this.realList.add(WordListEditorUI.this.oldWord);
                    WordListEditorUI.this.oldWord = null;
                }
                WordListEditorUI.this.refreshDisplay();
            }
        });
        WordGraphicalEditor wge = new WordGraphicalEditor(w);
        wordEditor.getContentPane().add(wge.getDisplay());
        this.masterFrame.getLayeredPane().add((Component)wordEditor, new Integer(5));
        wordEditor.setVisible(true);
        this.disabled = true;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Word List Editor");
        f.setSize(800, 600);
        f.setDefaultCloseOperation(3);
        WordList l = new WordList("Rofling Words");
        try {
            l.add(new Word("ROFL"));
            l.add(new Word("OMG"));
            l.add(new Word("WTF"));
            l.add(new Word("LOL"));
            l.add(new Word("LMAO"));
            l.add(new Word("ROFKASLALG"));
        }
        catch (Exception e) {
            System.out.println("FAILURE");
        }
        WordListEditorUI w = new WordListEditorUI(l, f);
        f.getContentPane().add(w.getDisplay());
        f.setVisible(true);
    }
}

