/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class WordListTest
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("WordListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testWordListConstructEmpty() {
        WordList l = new WordList();
        Assert.assertEquals((String)"List size should be 0.", (int)0, (int)l.size());
    }

    public void testWordListAdd() {
        WordList l = new WordList();
        Word w = null;
        try {
            w = new Word("person");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        Assert.assertTrue((String)"The add call should return true.", (boolean)l.add(w));
    }

    public void testWordListAddFail() {
        WordList l = new WordList();
        Integer w = new Integer(7);
        Assert.assertFalse((String)"The add call should return false.", (boolean)l.add(w));
    }

    public void testAddWordListSize() {
        WordList l = new WordList();
        Word w = null;
        try {
            w = new Word("person");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        Assert.assertEquals((String)"List size should be 1.", (int)1, (int)l.size());
    }

    public void testAddWordListSize2() {
        WordList l = new WordList();
        Word w = null;
        Word x = null;
        try {
            w = new Word("moron");
            x = new Word("person");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        l.add(x);
        Assert.assertEquals((String)"List size should be 2.", (int)2, (int)l.size());
    }

    public void testAddWordAlphabeticalOrder() {
        WordList l = new WordList();
        Word w = null;
        Word x = null;
        Word z = null;
        Word a = null;
        try {
            w = new Word("carefree");
            x = new Word("brofl");
            z = new Word("dudelol");
            a = new Word("anchor");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        l.add(x);
        l.add(z);
        l.add(a);
        Assert.assertEquals((String)"The first word in the list should be \"anchor\"", (Object)a, l.first());
    }

    public void testAddWordAlphabeticalOrder2() {
        WordList l = new WordList();
        Word w = null;
        Word x = null;
        Word z = null;
        Word a = null;
        try {
            w = new Word("gabbldygok");
            x = new Word("hounddog");
            z = new Word("escargoLOL");
            a = new Word("fruitful");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        l.add(x);
        l.add(z);
        l.add(a);
        Assert.assertEquals((String)"The last word in the list should be \"hounddog\"", (Object)x, l.last());
    }

    public void testAddWordListToEmptyBySize() {
        WordList l = new WordList();
        WordList l2 = new WordList();
        Word w = null;
        Word x = null;
        Word z = null;
        try {
            w = new Word("moron");
            x = new Word("person");
            z = new Word("sparkly");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l2.add(w);
        l2.add(x);
        l2.add(z);
        l.add(l2);
        Assert.assertEquals((String)"The size of the WordList should be 3", (int)3, (int)l.size());
    }

    public void testAddWordListToEmptyByContent() {
        WordList l = new WordList();
        WordList l2 = new WordList();
        Word w = null;
        Word x = null;
        Word z = null;
        try {
            w = new Word("moron");
            x = new Word("person");
            z = new Word("sparkly");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l2.add(w);
        l2.add(x);
        l2.add(z);
        l.add(l2);
        Assert.assertEquals((String)"The second word should be \"person\"", (Object)x, (Object)l.getWord(1));
    }

    public void testAddWordListByContent() {
        WordList l = new WordList();
        WordList l2 = new WordList();
        Word w = null;
        Word x = null;
        Word z = null;
        Word a = null;
        Word b = null;
        try {
            w = new Word("moron");
            x = new Word("person");
            z = new Word("sparkly");
            a = new Word("albright");
            b = new Word("really");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l2.add(w);
        l2.add(x);
        l2.add(z);
        l.add(a);
        l.add(b);
        l.add(l2);
        Assert.assertEquals((String)"The fourth word should be \"really\"", (Object)b, (Object)l.getWord(3));
    }

    public void testGetWordEmpty() {
        WordList l = new WordList();
        Assert.assertEquals((String)"List should return null element.", null, (Object)l.getWord());
    }

    public void testGetSpecificWordEmpty() {
        WordList l = new WordList();
        try {
            l.getWord(2);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertTrue((String)"List should catch an IndexOutOfBoundsException.", (boolean)true);
        }
        Assert.assertFalse((String)"List should catch an IndexOutOfBoundsException.", (boolean)false);
    }

    public void testGetWord() {
        WordList l = new WordList();
        Word w = null;
        try {
            w = new Word("person");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        Assert.assertEquals((String)"The added word should be the returned word.", (Object)w, (Object)l.getWord());
    }

    public void testGetWordFromThree() {
        WordList l = new WordList();
        Word w = null;
        Word x = null;
        Word z = null;
        try {
            w = new Word("moron");
            x = new Word("person");
            z = new Word("sparkly");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        l.add(x);
        l.add(z);
        boolean returnedValidWord = false;
        Word q = l.getWord();
        if (q == w || q == x || q == z) {
            returnedValidWord = true;
        }
        Assert.assertTrue((String)"The Word returned should be one of the words", (boolean)returnedValidWord);
    }

    public void testGetSpecificWord() {
        WordList l = new WordList();
        Word w = null;
        Word x = null;
        Word y = null;
        try {
            w = new Word("moron");
            x = new Word("person");
            y = new Word("sparkly");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        l.add(x);
        l.add(y);
        Assert.assertEquals((String)"The second word in the list should be \"person\"", (Object)x, (Object)l.getWord(1));
    }

    public void testGetWordString() {
        WordList l = new WordList();
        Word w = null;
        Word x = null;
        Word y = null;
        try {
            w = new Word("moron");
            x = new Word("person");
            y = new Word("sparkly");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        l.add(x);
        l.add(y);
        Assert.assertEquals((String)"The returns word should be \"sparkly\"", (Object)y, (Object)l.getWord("sparkly"));
    }

    public void testGetName() {
        WordList l = new WordList();
        Assert.assertEquals((String)"The method getName() should return \"Unnamed Word List\"", (String)"Unnamed Word List", (String)l.getName());
    }

    public void testGetName2() {
        WordList l = new WordList("Some List");
        Assert.assertEquals((String)"The method getName() should return \"Some List\"", (String)"Some List", (String)l.getName());
    }

    public void testSetName() {
        WordList l = new WordList();
        l.setName("Another List");
        Assert.assertEquals((String)"The method getName() should return \"Another List\"", (String)"Another List", (String)l.getName());
    }

    public void testIndexedRemovalSize() {
        WordList l = new WordList();
        Word w = null;
        Word x = null;
        Word y = null;
        try {
            w = new Word("moron");
            x = new Word("person");
            y = new Word("sparkly");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        l.add(x);
        l.add(y);
        l.remove(1);
        Assert.assertEquals((String)"The size of the list should be 2.", (int)2, (int)l.size());
    }

    public void testIndexedRemoval() {
        WordList l = new WordList();
        Word w = null;
        Word x = null;
        Word y = null;
        try {
            w = new Word("moron");
            x = new Word("person");
            y = new Word("sparkly");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        l.add(x);
        l.add(y);
        l.remove(0);
        Assert.assertEquals((String)"The first element should be \"person\".", (Object)x, l.first());
    }

    public void testIndexedRemoval2() {
        WordList l = new WordList();
        Word w = null;
        Word x = null;
        Word y = null;
        Word a = null;
        try {
            w = new Word("moron");
            x = new Word("person");
            y = new Word("sparkly");
            a = new Word("zeroWing");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        l.add(x);
        l.add(y);
        l.add(a);
        l.remove(3);
        Assert.assertEquals((String)"The last element should be \"sparkly\".", (Object)y, l.last());
    }

    public void testToArrayListBySize() {
        WordList l = new WordList();
        Word w = null;
        Word x = null;
        Word y = null;
        try {
            w = new Word("moron");
            x = new Word("person");
            y = new Word("sparkly");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        l.add(x);
        l.add(y);
        ArrayList asList = l.toArrayList();
        Assert.assertEquals((String)"The size of the WordList should equal the size of the ArrayList", (int)asList.size(), (int)l.size());
    }

    public void testToArrayListByElements() {
        WordList l = new WordList();
        Word w = null;
        Word x = null;
        Word y = null;
        try {
            w = new Word("moron");
            x = new Word("person");
            y = new Word("sparkly");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(w);
        l.add(x);
        l.add(y);
        ArrayList asList = l.toArrayList();
        boolean inSameOrder = true;
        int i = 0;
        while (i < asList.size()) {
            if (asList.get(i) != l.getWord(i)) {
                inSameOrder = false;
            }
            ++i;
        }
        Assert.assertTrue((String)"The elements of the ArrayList should be the same, in the same order", (boolean)inSameOrder);
    }

    public void testTheEnduranceTest() {
        WordList l = new WordList();
        Word el1 = null;
        Word el2 = null;
        Word el3 = null;
        Word el4 = null;
        Word el5 = null;
        Word el6 = null;
        Word el7 = null;
        Word el8 = null;
        Word el9 = null;
        Word el10 = null;
        Word el11 = null;
        try {
            el1 = new Word("apple");
            el2 = new Word("banana");
            el3 = new Word("cat");
            el4 = new Word("dig");
            el5 = new Word("effect");
            el6 = new Word("fignewton");
            el7 = new Word("gunbound");
            el8 = new Word("holysheet");
            el9 = new Word("ifrit");
            el10 = new Word("jumbo");
            el11 = new Word("killographic");
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        l.add(el1);
        l.add(el2);
        l.add(el3);
        l.remove(el2);
        l.add(el4);
        l.add(el5);
        l.add(el6);
        l.remove(el4);
        l.add(el7);
        l.add(el8);
        l.add(el9);
        l.remove(el6);
        l.add(el10);
        l.add(el11);
        l.remove(el1);
        Assert.assertEquals((String)"The 4th element should be \"fignewton\"", (Object)el8, (Object)l.getWord(3));
    }
}

