/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WordTab
implements ListSelectionListener,
ActionListener {
    Teacher u;
    JFrame frame;
    DefaultListModel wordmodel = new DefaultListModel();
    JList wordList = new JList(this.wordmodel);
    JScrollPane wordListScroll = new JScrollPane(this.wordList);
    JButton addList = new JButton("New List");
    JButton removeList = new JButton("Remove List");
    WordListEditorUI wordUI;
    JPanel words = new JPanel();
    DefaultListModel voidModel = new DefaultListModel();
    JList voidList = new JList(this.voidModel);
    JScrollPane voidListScroll = new JScrollPane(this.voidList);
    DefaultListModel randomModel = new DefaultListModel();
    JList randomList = new JList(this.randomModel);
    JScrollPane randomListScroll = new JScrollPane(this.randomList);
    DefaultListModel focusedModel = new DefaultListModel();
    JList focusedList = new JList(this.focusedModel);
    JScrollPane focusedListScroll = new JScrollPane(this.focusedList);
    WordListList focused;
    WordListList random;
    WordListList all;
    JButton randomButton = new JButton("Add to Random");
    JButton focusedButton = new JButton("Add to Focused");
    JButton removeRandom = new JButton("Remove Random");
    JButton removeFocused = new JButton("Remove Focused");

    public WordTab(Teacher u, JFrame f) {
        this.wordList.setPreferredSize(new Dimension(100, 100));
        this.u = u;
        this.frame = f;
        this.addList.addActionListener(this);
        this.removeList.addActionListener(this);
        this.randomButton.addActionListener(this);
        this.focusedButton.addActionListener(this);
        this.removeRandom.addActionListener(this);
        this.removeFocused.addActionListener(this);
        this.randomButton.setEnabled(false);
        this.focusedButton.setEnabled(false);
        this.removeRandom.setEnabled(false);
        this.removeFocused.setEnabled(false);
        this.removeList.setEnabled(false);
        this.voidList.addListSelectionListener(this);
        this.focusedList.addListSelectionListener(this);
        this.randomList.addListSelectionListener(this);
        Dimension buttonSize = this.removeFocused.getMaximumSize();
        this.refreshRandomList();
        this.words.setBorder(new EmptyBorder(20, 20, 20, 0));
        this.words.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 3;
        c.ipady = 100;
        c.anchor = 11;
        JLabel randomLabel = new JLabel("Random Battle List:");
        c.gridy = 0;
        c.gridx = 1;
        c.ipady = 0;
        c.anchor = 10;
        c.ipady = 0;
        c.fill = 0;
        this.words.add((Component)randomLabel, c);
        c.gridy = 1;
        c.ipady = 100;
        c.fill = 3;
        JLabel focusedLabel = new JLabel("Focused Word List:");
        c.gridy = 0;
        c.gridx = 2;
        c.ipady = 0;
        c.anchor = 10;
        c.ipady = 0;
        c.fill = 0;
        this.words.add((Component)focusedLabel, c);
        c.gridy = 1;
        c.ipady = 100;
        c.fill = 3;
        c.gridy = 3;
        c.gridx = 1;
        c.ipady = 0;
        c.anchor = 10;
        c.ipady = 0;
        c.fill = 0;
        this.randomButton.setMinimumSize(buttonSize);
        this.words.add((Component)this.randomButton, c);
        c.gridy = 1;
        c.ipady = 100;
        c.fill = 3;
        c.gridy = 4;
        c.gridx = 1;
        c.ipady = 0;
        c.anchor = 10;
        c.ipady = 0;
        c.fill = 0;
        this.removeRandom.setMinimumSize(buttonSize);
        this.words.add((Component)this.removeRandom, c);
        c.gridy = 1;
        c.ipady = 100;
        c.fill = 3;
        c.gridy = 3;
        c.gridx = 2;
        c.ipady = 0;
        c.anchor = 10;
        c.ipady = 0;
        c.fill = 0;
        this.focusedButton.setMinimumSize(buttonSize);
        this.words.add((Component)this.focusedButton, c);
        c.gridy = 1;
        c.ipady = 100;
        c.fill = 3;
        c.gridy = 4;
        c.gridx = 2;
        c.ipady = 0;
        c.anchor = 10;
        c.ipady = 0;
        c.fill = 0;
        this.removeFocused.setMinimumSize(buttonSize);
        this.words.add((Component)this.removeFocused, c);
        c.gridy = 1;
        c.ipady = 100;
        c.fill = 3;
        JLabel voidLabel = new JLabel("All Lists:");
        c.gridy = 0;
        c.gridx = 0;
        c.ipady = 0;
        c.anchor = 10;
        c.ipady = 0;
        c.fill = 0;
        this.words.add((Component)voidLabel, c);
        c.gridy = 1;
        c.ipady = 100;
        c.fill = 3;
        c.gridy = 3;
        c.gridx = 0;
        c.ipady = 0;
        c.anchor = 10;
        c.ipady = 0;
        c.fill = 0;
        this.addList.setMinimumSize(buttonSize);
        this.words.add((Component)this.addList, c);
        c.gridy = 1;
        c.ipady = 100;
        c.fill = 3;
        c.gridy = 4;
        c.gridx = 0;
        c.ipady = 0;
        c.anchor = 10;
        c.ipady = 0;
        c.fill = 0;
        this.removeList.setMinimumSize(buttonSize);
        this.words.add((Component)this.removeList, c);
        c.gridy = 1;
        c.ipady = 100;
        c.fill = 3;
        c.gridx = 1;
        Dimension d = new Dimension();
        d = this.randomList.getPreferredSize();
        d.height += 10;
        d.width += 10;
        this.randomListScroll.setMinimumSize(d);
        this.focusedListScroll.setMinimumSize(d);
        this.voidListScroll.setMinimumSize(d);
        c.weightx = 1.0;
        c.fill = 1;
        this.words.add((Component)this.randomListScroll, c);
        c.gridx = 2;
        this.words.add((Component)this.focusedListScroll, c);
        c.gridx = 3;
        this.wordUI = new WordListEditorUI(null, this.frame);
        c.weighty = 1.0;
        c.gridheight = 1;
        this.words.add((Component)this.wordUI.getDisplay(), c);
        c.gridx = 0;
        this.words.add((Component)this.voidListScroll, c);
        this.refreshWordList(u);
    }

    public JPanel display() {
        return this.words;
    }

    private void refreshVoidList() {
        this.voidModel.clear();
        this.all = this.u.getAllLists();
        if (this.all != null) {
            List alist = this.all.getWordLists();
            Iterator it = alist.iterator();
            while (it.hasNext()) {
                WordList wl = (WordList)it.next();
                this.voidModel.addElement(wl.getName());
            }
            this.voidList.setPrototypeCellValue("index 1234567890");
        }
    }

    private void refreshRandomList() {
        this.randomModel.clear();
        this.random = this.u.getRandomLists();
        if (this.random != null) {
            List rList = this.random.getWordLists();
            Iterator it = rList.iterator();
            while (it.hasNext()) {
                WordList wl = (WordList)it.next();
                this.randomModel.addElement(wl.getName());
            }
            this.randomList.setPrototypeCellValue("index 1234567890");
        }
    }

    private void refreshFocusedList() {
        this.focusedModel.clear();
        this.focused = this.u.getFocusedLists();
        if (this.focused != null) {
            List fList = this.focused.getWordLists();
            Iterator it = fList.iterator();
            while (it.hasNext()) {
                WordList wl = (WordList)it.next();
                this.focusedModel.addElement(wl.getName());
            }
            this.focusedList.setPrototypeCellValue("index 1234567890");
        }
    }

    public void refreshWordList(Teacher u) {
        this.u = u;
        this.removeListeners();
        this.refreshWordList();
        this.addListeners();
    }

    private void refreshWordList() {
        int curSel = this.getSelectedIndex();
        int curList = this.getSelectedList();
        this.refreshVoidList();
        this.refreshRandomList();
        this.refreshFocusedList();
        switch (curList) {
            case 0: {
                this.voidList.setSelectedIndex(curSel);
                break;
            }
            case 1: {
                this.randomList.setSelectedIndex(curSel);
                break;
            }
            case 2: {
                this.focusedList.setSelectedIndex(curSel);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Word ghost = new Word("ghost");
        ghost.addMistake("gost");
        ghost.addMistake("goste");
        ghost.addMistake("ghoct");
        ghost.addMistake("ghoest");
        ghost.setHint("An undead phantom, see also Casper the Ghost");
        Word walrus = new Word("walrus");
        walrus.addMistake("walruse");
        walrus.addMistake("walruss");
        walrus.addMistake("wallrus");
        walrus.addMistake("wolrus");
        walrus.setHint("Large sea cow.  Taste great with hickory barbecue sauce");
        walrus.setImagePath("images/words/walrus.jpg");
        Word clown = new Word("clown");
        clown.addMistake("clowne");
        clown.addMistake("kloun");
        clown.addMistake("cloun");
        clown.addMistake("klown");
        clown.setHint("Terrifying circus folk.  Carnies with makeup");
        clown.setImagePath("images/words/clown.jpg");
        Word spell = new Word("spell");
        spell.addMistake("speal");
        spell.addMistake("spele");
        spell.addMistake("speel");
        spell.addMistake("cpell");
        spell.setHint("");
        Word lobster = new Word("lobster");
        lobster.addMistake("lobstar");
        lobster.addMistake("loubster");
        lobster.addMistake("lorbster");
        lobster.addMistake("lobstore");
        lobster.setHint("Sticks to magnet.  Don't put him on a plate.");
        lobster.setImagePath("images/words/lobster.jpg");
        Word schizophrenic = new Word("schizophrenic");
        schizophrenic.addMistake("skitzofrenik");
        schizophrenic.addMistake("schitzophrenik");
        schizophrenic.addMistake("skizophrenic");
        schizophrenic.addMistake("schitzophrenic");
        schizophrenic.setImagePath("images/words/schizophrenic.jpg");
        schizophrenic.setHint("What happens when you use linux for too long");
        Word but = new Word("but");
        but.setHint("lol butts");
        Teacher ludi = new Teacher("ProfLudi", "Professor Ludi", "se1");
        try {
            ludi.getAllLists().addWordList(new WordList("WordList 1"));
            ludi.getAllLists().addWordList(new WordList("Another one"));
            ludi.getAllLists().getWordList(0).add(clown);
            ludi.getAllLists().getWordList(0).add(lobster);
            ludi.getAllLists().getWordList(0).add(spell);
            ludi.getAllLists().getWordList(0).add(walrus);
            ludi.getAllLists().getWordList(0).add(ghost);
            ludi.getAllLists().getWordList(0).add(schizophrenic);
            ludi.getAllLists().getWordList(0).add(but);
            ludi.getAllLists().getWordList(1).add(new Word("DefaultWord1", "asdf", "", "", new String[0]));
            ludi.getAllLists().getWordList(1).add(new Word("DefaultWord2", "asdf", "", "", new String[0]));
            ludi.getAllLists().getWordList(1).add(new Word("DefaultWord3", "asdf", "", "", new String[0]));
            ludi.getAllLists().getWordList(1).add(new Word("DefaultWord4", "asdf", "", "", new String[0]));
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
        }
        JFrame f = new JFrame();
        WordTab words = new WordTab(ludi, f);
        f.getContentPane().add(words.display());
        f.setDefaultCloseOperation(3);
        f.setSize(800, 600);
        f.setVisible(true);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.voidList) {
            this.setEnabled();
            this.wordUI.loadNewList(this.all.getWordList(this.voidList.getSelectedIndex()));
            this.removeListeners();
            this.randomList.clearSelection();
            this.focusedList.clearSelection();
            this.addListeners();
        } else if (e.getSource() == this.randomList) {
            this.setEnabled();
            this.wordUI.loadNewList(this.random.getWordList(this.randomList.getSelectedIndex()));
            this.removeListeners();
            this.focusedList.clearSelection();
            this.voidList.clearSelection();
            this.addListeners();
            this.removeList.setEnabled(false);
            this.focusedButton.setEnabled(false);
            this.removeFocused.setEnabled(false);
            this.randomButton.setEnabled(false);
        } else if (e.getSource() == this.focusedList) {
            this.setEnabled();
            this.wordUI.loadNewList(this.focused.getWordList(this.focusedList.getSelectedIndex()));
            this.removeListeners();
            this.randomList.clearSelection();
            this.voidList.clearSelection();
            this.addListeners();
            this.removeList.setEnabled(false);
            this.randomButton.setEnabled(false);
            this.removeRandom.setEnabled(false);
            this.focusedButton.setEnabled(false);
        }
    }

    private void setEnabled() {
        this.addList.setEnabled(true);
        this.removeList.setEnabled(true);
        this.randomButton.setEnabled(true);
        this.removeRandom.setEnabled(true);
        this.focusedButton.setEnabled(true);
        this.removeFocused.setEnabled(true);
    }

    private int getSelectedList() {
        int ret = this.voidList.getSelectedIndex();
        if (ret != -1) {
            ret = 0;
        } else {
            ret = this.randomList.getSelectedIndex();
            if (ret != -1) {
                ret = 1;
            } else {
                ret = this.focusedList.getSelectedIndex();
                if (ret != -1) {
                    ret = 2;
                }
            }
        }
        return ret;
    }

    private int getSelectedIndex() {
        int ret = this.voidList.getSelectedIndex();
        if (ret == -1) {
            ret = this.randomList.getSelectedIndex();
        }
        if (ret == -1) {
            ret = this.focusedList.getSelectedIndex();
        }
        return ret;
    }

    private void removeListeners() {
        this.voidList.removeListSelectionListener(this);
        this.randomList.removeListSelectionListener(this);
        this.focusedList.removeListSelectionListener(this);
    }

    private void addListeners() {
        this.voidList.addListSelectionListener(this);
        this.randomList.addListSelectionListener(this);
        this.focusedList.addListSelectionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        this.removeListeners();
        if (e.getSource() == this.addList) {
            String inputValue = JOptionPane.showInputDialog("Name of Word List: ");
            this.all.addWordList(new WordList(inputValue));
            this.wordUI.loadNewList(null);
            this.voidList.clearSelection();
        } else if (e.getSource() == this.removeList && this.voidList.getSelectedIndex() >= 0) {
            int ok = JOptionPane.showConfirmDialog(this.frame, "This list will be removed from all lists!", "Warning", 2);
            if (ok == 0) {
                int toRem = this.voidList.getSelectedIndex();
                if (this.random.contains(this.all.getWordList(toRem))) {
                    this.random.getWordLists().remove(this.all.getWordList(this.getSelectedIndex()));
                }
                if (this.focused.contains(this.all.getWordList(toRem))) {
                    this.focused.getWordLists().remove(this.all.getWordList(this.getSelectedIndex()));
                }
                this.all.removeWordList(toRem);
                this.wordUI.loadNewList(null);
                this.removeRandom.setEnabled(false);
                this.removeList.setEnabled(false);
                this.removeFocused.setEnabled(false);
                this.wordList.clearSelection();
            }
        } else if (e.getSource() == this.randomButton) {
            WordList toAdd = this.all.getWordList(this.voidList.getSelectedIndex());
            if (!this.random.contains(toAdd)) {
                this.random.addWordList(toAdd);
            }
        } else if (e.getSource() == this.removeRandom) {
            switch (this.getSelectedList()) {
                case 0: {
                    if (!this.random.contains(this.all.getWordList(this.getSelectedIndex()))) break;
                    this.random.getWordLists().remove(this.all.getWordList(this.getSelectedIndex()));
                    break;
                }
                case 1: {
                    this.random.removeWordList(this.randomList.getSelectedIndex());
                    break;
                }
            }
            this.removeRandom.setEnabled(false);
            this.removeList.setEnabled(false);
            this.removeFocused.setEnabled(false);
            this.randomList.clearSelection();
        } else if (e.getSource() == this.focusedButton) {
            WordList toAdd = this.all.getWordList(this.voidList.getSelectedIndex());
            if (!this.focused.contains(toAdd)) {
                this.focused.addWordList(toAdd);
            }
        } else if (e.getSource() == this.removeFocused) {
            switch (this.getSelectedList()) {
                case 0: {
                    if (!this.focused.contains(this.all.getWordList(this.getSelectedIndex()))) break;
                    this.focused.getWordLists().remove(this.all.getWordList(this.getSelectedIndex()));
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.focused.removeWordList(this.focusedList.getSelectedIndex());
                }
            }
            this.removeRandom.setEnabled(false);
            this.removeList.setEnabled(false);
            this.removeFocused.setEnabled(false);
            this.focusedList.clearSelection();
        }
        this.refreshWordList();
        this.addListeners();
    }
}

