/*
 * Decompiled with CFR 0.152.
 */
import junit.framework.Assert;
import junit.framework.TestCase;

public class WordTest
extends TestCase {
    private String the;
    private String[] testMisspellingArrayThe = new String[]{"teh", "hte", "eht"};
    private String defThe;
    private String picPathThe;
    private String pronunThe;
    private Word word1;

    protected void setUp() {
        this.pronunThe = "the";
        this.defThe = "A word";
        this.picPathThe = "";
        this.the = "the";
        try {
            this.word1 = new Word("the");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void tearDown() {
    }

    public void testAddPicture() {
        try {
            this.word1.setImagePath("images/newexit.JPG");
        }
        catch (ImageNotFoundException e) {
            Assert.assertNotNull(null);
        }
        Assert.assertEquals((String)"images/newexit.JPG", (String)this.word1.getImagePath());
        Assert.assertNotNull((Object)this.word1.getImage());
    }

    public void testChangeSpelling() {
        Assert.assertEquals((String)"the", (String)this.word1.getSpelling());
        try {
            this.word1.setSpelling("teh");
        }
        catch (Exception e) {
            Assert.assertNotNull(null);
        }
        Assert.assertEquals((String)"teh", (String)this.word1.getSpelling());
        boolean nextTestPassed = false;
        try {
            this.word1.setSpelling("");
        }
        catch (Exception e) {
            nextTestPassed = true;
        }
        Assert.assertTrue((boolean)nextTestPassed);
        Assert.assertEquals((String)"teh", (String)this.word1.getSpelling());
    }

    public void testAddSpelling() {
        this.word1.addMistake("hi");
        Assert.assertEquals((int)1, (int)this.word1.numMistakes());
        Object[] object1 = this.word1.getMistakes();
        Assert.assertEquals((Object)object1, (Object)object1);
    }

    public void testRemoveMistake() {
        this.word1.addMistake(this.testMisspellingArrayThe);
        Assert.assertEquals((int)3, (int)this.word1.numMistakes());
        this.word1.removeMistake("often");
        Assert.assertEquals((int)3, (int)this.word1.numMistakes());
        this.word1.removeMistake("teh");
        Assert.assertEquals((int)2, (int)this.word1.numMistakes());
    }

    public void testEmptyMisspelling() {
        Assert.assertEquals((int)0, (int)this.word1.numMistakes());
        Assert.assertNotNull((Object)this.word1.getMistakes());
    }

    public void testChangeSound() {
        Assert.assertEquals((String)"the", (String)this.word1.getAudio());
        this.word1.setAudio("Yay");
        Assert.assertEquals((String)"The new audio should equal Yay", (boolean)true, (boolean)this.word1.getAudio().equals("Yay"));
    }

    public void testBasicConstructor() {
        try {
            Word word2 = new Word("the");
            Assert.assertEquals((String)"the", (String)word2.getAudio());
            Assert.assertEquals((String)"", (String)word2.getDef());
            Assert.assertNull((Object)word2.getImage());
            Assert.assertEquals((String)"", (String)word2.getImagePath());
            Assert.assertNotNull((Object)word2.getMistakes());
            Assert.assertEquals((String)"the", (String)word2.getSpelling());
            Assert.assertEquals((int)0, (int)word2.numMistakes());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertNotNull(null);
        }
    }

    public void testToStringAndCreateWord() {
        Word word2;
        String s;
        Word word;
        try {
            word = new Word("the");
            s = word.toString();
            word2 = Word.readWord(s);
            Assert.assertEquals((String)"the", (String)word2.getAudio());
            Assert.assertEquals((String)"", (String)word2.getDef());
            Assert.assertNull((Object)word2.getImage());
            Assert.assertEquals((String)"", (String)word2.getImagePath());
            Assert.assertNotNull((Object)word2.getMistakes());
            Assert.assertEquals((String)"the", (String)word2.getSpelling());
            Assert.assertEquals((int)0, (int)word2.numMistakes());
        }
        catch (Exception e) {
            Assert.assertNotNull(null);
        }
        try {
            word = new Word("the");
            word.addMistake("hi");
            s = word.toString();
            word2 = Word.readWord(s);
            Assert.assertEquals((String)"the", (String)word2.getAudio());
            Assert.assertEquals((String)"", (String)word2.getDef());
            Assert.assertNull((Object)word2.getImage());
            Assert.assertEquals((String)"", (String)word2.getImagePath());
            Assert.assertNotNull((Object)word2.getMistakes());
            Assert.assertEquals((String)"the", (String)word2.getSpelling());
            Assert.assertEquals((int)1, (int)word2.numMistakes());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertNotNull(null);
        }
    }

    public void testCompareTo() {
        try {
            Word word2 = new Word("a");
            Word word3 = new Word("u");
            Assert.assertEquals((String)"the", (String)this.word1.getAudio());
            Assert.assertEquals((boolean)true, (this.word1.compareTo(word2) > 0 ? 1 : 0) != 0);
            Assert.assertEquals((boolean)true, (this.word1.compareTo(word3) < 0 ? 1 : 0) != 0);
            Assert.assertEquals((int)0, (int)this.word1.compareTo(this.word1));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertNotNull(null);
        }
    }

    public void testCopyConstructor() {
        try {
            Word word2 = new Word(this.word1);
            Assert.assertEquals((boolean)false, (boolean)word2.equals(this.word1));
            Assert.assertEquals((int)0, (int)word2.compareTo(this.word1));
            Assert.assertNull((Object)word2.getImage());
            String string1 = word2.getSpelling();
            String string2 = this.word1.getSpelling();
            Assert.assertEquals((int)0, (int)string1.compareTo(string2));
        }
        catch (InvalidWordException e) {
            e.printStackTrace();
            Assert.assertNotNull(null);
        }
    }

    public void testBadSpelling() {
        String oldSpell = this.word1.getSpelling();
        try {
            this.word1.setSpelling("a~");
        }
        catch (InvalidWordException e) {
            Assert.assertNull(null);
            Assert.assertEquals((int)0, (int)oldSpell.compareTo(this.word1.getSpelling()));
        }
        try {
            this.word1.setSpelling("a ");
        }
        catch (InvalidWordException e) {
            Assert.assertNull(null);
            Assert.assertEquals((int)0, (int)oldSpell.compareTo(this.word1.getSpelling()));
        }
    }
}

