/*
 * Decompiled with CFR 0.152.
 */
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;

public abstract class EmacspeakProtocolHandler
implements Runnable {
    private Socket socket;
    private BufferedReader reader;
    private OutputStream writer;
    protected static final String PARENS_STAR_REGEX = "[.]*\\[\\*\\][.]*";
    private static final int NOT_HANDLED_COMMAND = 1;
    private static final int LETTER_COMMAND = 2;
    private static final int QUEUE_COMMAND = 3;
    private static final int TTS_SAY_COMMAND = 4;
    private static final int STOP_COMMAND = 5;
    private static final int EXIT_COMMAND = 6;
    private static final int RATE_COMMAND = 7;
    private String lastQueuedCommand;
    private String stopQuestionStart = "Active processes exist;";
    private boolean debug = false;
    private boolean stripDECTalk = false;

    public void setSocket(Socket socket) {
        this.socket = socket;
        if (socket != null) {
            try {
                this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.writer = new DataOutputStream(socket.getOutputStream());
                socket.setKeepAlive(true);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new Error();
            }
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private static boolean matches(String start, String end, String input) {
        return input.startsWith(start) && input.endsWith(end);
    }

    private static int getCommandType(String command) {
        int type = 1;
        if (command.startsWith("l ")) {
            type = 2;
        } else if (command.startsWith("q ")) {
            type = 3;
        } else if (command.startsWith("tts_say ")) {
            type = 4;
        } else if (command.startsWith("tts_set_speech_rate ")) {
            type = 7;
        } else if (command.equals("s")) {
            type = 5;
        } else if (command.equals("exit")) {
            type = 6;
        }
        return type;
    }

    public static String textInCurlyBrackets(String input) {
        String result = "";
        if (input.length() > 0) {
            int last;
            int first = input.indexOf(123);
            if (first == -1) {
                first = input.indexOf(32);
            }
            if ((last = input.lastIndexOf(125)) == -1) {
                last = input.length();
            }
            if (first != -1 && last != -1 && first < last) {
                result = input.substring(first + 1, last);
            }
        }
        return result.trim();
    }

    public String stripDECTalkCommands(String content) {
        int endPos;
        int startPos = content.indexOf(91);
        while (startPos != -1 && (endPos = content.indexOf(93)) != -1) {
            if (startPos == 0) {
                content = endPos == content.length() - 1 ? "" : content.substring(endPos + 1);
            } else if (endPos == content.length() - 1) {
                content = content.substring(0, startPos);
            } else {
                String firstPart = content.substring(0, startPos);
                String secondPart = content.substring(endPos + 1);
                content = firstPart + " " + secondPart;
            }
            startPos = content.indexOf(91);
        }
        return content.trim();
    }

    public abstract void speak(String var1);

    public abstract void cancelAll();

    public abstract void setRate(float var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        try {
            String command = "";
            this.stripDECTalk = Utilities.getBoolean("stripDECTalk");
            while (this.isSocketLive()) {
                command = this.reader.readLine();
                if (command == null) continue;
                command = command.trim();
                this.debugPrintln("IN   : " + command);
                int commandType = EmacspeakProtocolHandler.getCommandType(command);
                if (commandType == 6) {
                    this.socket.close();
                    this.notifyAll();
                    continue;
                }
                if (commandType == 5) {
                    this.cancelAll();
                    continue;
                }
                if (commandType == 7) {
                    try {
                        this.setRate(Float.parseFloat(EmacspeakProtocolHandler.textInCurlyBrackets(command)));
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (commandType != 1) {
                    String content = EmacspeakProtocolHandler.textInCurlyBrackets(command);
                    if (this.stripDECTalk) {
                        content = this.stripDECTalkCommands(content);
                    }
                    if (content.length() > 0) {
                        this.speak(content);
                    }
                    this.detectQuitting(commandType, content);
                    continue;
                }
                this.debugPrintln("SPEAK:");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            this.debugPrintln("EmacspeakProtocolHandler: thread terminated");
        }
    }

    private boolean isSocketLive() {
        return this.socket.isBound() && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    private String readLine() throws IOException {
        String command = null;
        boolean repeat = false;
        do {
            try {
                command = this.reader.readLine();
                repeat = false;
            }
            catch (SocketTimeoutException ste) {
                System.out.println("timed out");
                repeat = this.isSocketLive();
            }
        } while (repeat);
        return command;
    }

    private synchronized void detectQuitting(int commandType, String content) throws IOException {
        if (commandType == 3) {
            this.lastQueuedCommand = content;
        } else if (commandType == 4) {
            if (content.equals("no")) {
                this.lastQueuedCommand = "";
            } else if (content.equals("yes") && this.lastQueuedCommand.startsWith(this.stopQuestionStart)) {
                this.socket.close();
                this.notifyAll();
            }
        }
    }

    public void debugPrintln(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }
}

