/*
 * Decompiled with CFR 0.152.
 */
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.Socket;
import java.util.Locale;
import javax.speech.Central;
import javax.speech.EngineModeDesc;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.Voice;

public class EmacspeakServer
extends TTSServer {
    private Synthesizer synthesizer;
    private String voiceName;
    private Voice voice;

    public EmacspeakServer(String voiceName) {
        this.loadSynthesizer(voiceName);
    }

    private void loadSynthesizer(String voiceName) {
        this.voice = new Voice(voiceName, 65535, 65535, null);
        SynthesizerModeDesc modeDesc = new SynthesizerModeDesc(null, "general", Locale.US, null, null);
        try {
            this.synthesizer = Central.createSynthesizer((EngineModeDesc)modeDesc);
            if (this.synthesizer == null) {
                System.err.println(EmacspeakServer.noSynthesizerMessage());
                System.exit(1);
            }
            this.synthesizer.allocate();
            this.synthesizer.resume();
            this.synthesizer.getSynthesizerProperties().setVolume(1.0f);
            this.synthesizer.getSynthesizerProperties().setVoice(this.voice);
        }
        catch (Exception e) {
            System.out.println("Error creating synthesizer");
            System.exit(1);
        }
    }

    private static String noSynthesizerMessage() {
        String message = "No synthesizer created.  This may be the result of any\nnumber of problems.  It's typically due to a missing\n\"speech.properties\" file that should be at either of\nthese locations: \n\n";
        message = message + "user.home    : " + System.getProperty("user.home") + "\n";
        message = message + "java.home/lib: " + System.getProperty("java.home") + File.separator + "lib\n\n" + "Another cause of this problem might be corrupt or missing\n" + "voice jar files in the freetts lib directory.  This problem\n" + "also sometimes arises when the freetts.jar file is corrupt\n" + "or missing.  Sorry about that.  Please check for these\n" + "various conditions and then try again.\n";
        return message;
    }

    protected void spawnProtocolHandler(Socket socket) {
        try {
            JSAPIEmacspeakHandler handler = new JSAPIEmacspeakHandler(socket, this.synthesizer);
            new Thread(handler).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setRate(float wpm) {
        try {
            this.synthesizer.getSynthesizerProperties().setSpeakingRate(wpm);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String voiceName = args.length > 0 ? args[0] : "kevin16";
        System.out.println();
        System.out.println("Using voice: " + voiceName);
        System.out.println();
        EmacspeakServer server = new EmacspeakServer(voiceName);
        if (args.length > 1) {
            float wpm = Float.parseFloat(args[1]);
            server.setRate(wpm);
        }
        new Thread(server).start();
    }
}

