/*
 * Decompiled with CFR 0.152.
 */
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;
import com.sun.speech.freetts.util.Utilities;
import java.net.Socket;

public class Server
extends TTSServer {
    private Voice voice8k;
    private String voice8kName = Utilities.getProperty("voice8kName", "kevin");
    private Voice voice16k;
    private String voice16kName = Utilities.getProperty("voice16kName", "kevin16");

    public Server() {
        this.port = Utilities.getInteger("port", 5555);
        try {
            VoiceManager voiceManager = VoiceManager.getInstance();
            this.voice8k = voiceManager.getVoice(this.voice8kName);
            this.voice16k = voiceManager.getVoice(this.voice16kName);
            this.voice8k.allocate();
            this.voice16k.allocate();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public Voice get8kVoice() {
        return this.voice8k;
    }

    public Voice get16kVoice() {
        return this.voice16k;
    }

    protected void spawnProtocolHandler(Socket socket) {
        try {
            SocketTTSHandler handler = new SocketTTSHandler(socket, this);
            new Thread(handler).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Server server = new Server();
        new Thread(server).start();
    }
}

