/*
 * Decompiled with CFR 0.152.
 */
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.Utilities;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import javax.sound.sampled.AudioFormat;

public class SocketAudioPlayer
implements AudioPlayer {
    private AudioFormat audioFormat;
    private Socket socket;
    private DataOutputStream dataOutputStream;
    private boolean debug = false;
    private int bytesToPlay = 0;
    private int bytesPlayed = 0;
    private boolean firstByteSent = false;
    private long firstByteTime = -1L;

    public SocketAudioPlayer(Socket socket) {
        this.socket = socket;
        try {
            this.dataOutputStream = new DataOutputStream(socket.getOutputStream());
            this.debug = Utilities.getBoolean("debug");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setAudioFormat(AudioFormat format) {
        this.audioFormat = format;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public void pause() {
    }

    public void resume() {
    }

    public void reset() {
    }

    public boolean drain() {
        try {
            this.dataOutputStream.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return true;
    }

    public void begin(int size) {
        try {
            this.bytesToPlay = size;
            this.firstByteSent = false;
            this.dataOutputStream.writeBytes(String.valueOf(size) + "\n");
            this.dataOutputStream.flush();
            if (this.debug) {
                System.out.println("begin: " + size);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void startFirstSampleTimer() {
    }

    public boolean end() {
        if (this.debug) {
            System.out.println("end");
        }
        if (this.bytesPlayed < this.bytesToPlay) {
            int bytesNotPlayed = this.bytesToPlay - this.bytesPlayed;
            this.write(new byte[bytesNotPlayed], 0, bytesNotPlayed);
        }
        this.bytesToPlay = 0;
        this.bytesPlayed = 0;
        return true;
    }

    public void cancel() {
    }

    public void close() {
    }

    public float getVolume() {
        return -1.0f;
    }

    public void setVolume(float volume) {
    }

    public long getTime() {
        return -1L;
    }

    public void resetTime() {
    }

    public boolean write(byte[] audioData) {
        return this.write(audioData, 0, audioData.length);
    }

    public boolean write(byte[] audioData, int offset, int size) {
        try {
            if (!this.firstByteSent) {
                this.firstByteTime = System.currentTimeMillis();
                this.firstByteSent = true;
            }
            this.bytesPlayed += size;
            this.dataOutputStream.write(audioData, offset, size);
            this.dataOutputStream.flush();
            if (this.debug) {
                System.out.println("sent " + size + " bytes " + audioData[0] + " " + audioData[size / 2]);
            }
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    public void showMetrics() {
    }

    public long getFirstByteSentTime() {
        return this.firstByteTime;
    }
}

