/*
 * Decompiled with CFR 0.152.
 */
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

class SocketTTSHandler
implements Runnable {
    private Voice voice;
    private Server server;
    private Socket socket;
    private SocketAudioPlayer socketAudioPlayer;
    private BufferedReader reader;
    private PrintWriter writer;
    private static final int INVALID_SAMPLE_RATE = 1;
    private boolean metrics = Utilities.getBoolean("metrics");
    private long requestReceivedTime;
    private long requestSpeakTime;

    public SocketTTSHandler(Socket socket, Server server) {
        this.setSocket(socket);
        this.server = server;
        this.socketAudioPlayer = new SocketAudioPlayer(socket);
    }

    private void setSocket(Socket socket) {
        this.socket = socket;
        if (socket != null) {
            try {
                this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.writer = new PrintWriter(socket.getOutputStream(), true);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.println("Socket reader/writer not instantiated");
                throw new Error();
            }
        }
    }

    private void sendLine(String line) {
        this.writer.print(line);
        this.writer.print('\n');
        this.writer.flush();
    }

    public void run() {
        try {
            this.sendLine("READY");
            String command = null;
            while ((command = this.reader.readLine()) != null && command.equals("TTS")) {
                this.requestReceivedTime = System.currentTimeMillis();
                int status = this.handleSynthesisRequest();
                if (status == 1) {
                    this.println("Invalid sample rate\nexit.");
                    return;
                }
                if (!this.metrics) continue;
                System.out.println("Time To Sending First Byte: " + (this.socketAudioPlayer.getFirstByteSentTime() - this.requestReceivedTime) + " ms");
            }
            if (command != null) {
                if (command.equals("DONE")) {
                    this.socket.close();
                    this.println("... closed socket connection");
                } else {
                    this.println("invalid command: " + command);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private int handleSynthesisRequest() {
        try {
            String sampleRateLine = this.reader.readLine();
            int sampleRate = Integer.parseInt(sampleRateLine);
            if (sampleRate == 8000) {
                this.voice = this.server.get8kVoice();
            } else if (sampleRate == 16000) {
                this.voice = this.server.get16kVoice();
            } else {
                this.sendLine("-2");
                return 1;
            }
            String text = this.reader.readLine();
            this.voice.setAudioPlayer(this.socketAudioPlayer);
            this.voice.speak(text);
            this.sendLine("-1");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return 0;
    }

    private void println(String message) {
        System.out.println(message);
    }
}

