/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.Voice;
import javax.swing.JFrame;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Player
extends JFrame {
    private PlayerModel playerModel;
    private PlayerPanel playerPanel;
    private PlayerMenuBar playerMenuBar;
    private Font globalFont;
    private String globalFontFace = "Arial";

    public Player(String title) {
        super(title);
        Player.setDefaultLookAndFeelDecorated(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Player.this.playerModel.close();
                System.exit(0);
            }
        });
        this.playerModel = new PlayerModelImpl();
        this.playerPanel = new PlayerPanel(this.playerModel);
        this.setSize(this.playerPanel.getSize());
        this.getContentPane().add((Component)this.playerPanel, "Center");
    }

    public PlayerPanel getView() {
        return this.playerPanel;
    }

    public PlayerModel getModel() {
        return this.playerModel;
    }

    public void setMenuBar(PlayerMenuBar menubar) {
        this.playerMenuBar = menubar;
        this.setJMenuBar(this.playerMenuBar);
    }

    public void showMonitor(boolean show) {
        Monitor monitor = this.playerModel.getMonitor();
        int newHeight = this.getSize().height;
        int monitorHeight = monitor.getSize().height;
        if (show) {
            this.playerPanel.add((Component)monitor, "South");
            newHeight += monitorHeight;
        } else {
            this.playerPanel.remove(monitor);
            newHeight -= monitorHeight;
        }
        Dimension newSize = new Dimension(this.getSize().width, newHeight);
        this.playerPanel.setSize(newSize);
        this.setSize(newSize);
        this.playerModel.setMonitorVisible(show);
        this.repaint();
    }

    public void setGlobalFontSize(int fontSize) {
        if (this.globalFont == null) {
            this.globalFont = this.getFont();
        }
        this.globalFont = new Font(this.globalFontFace, 1, fontSize);
        UIManager.put("Button.font", this.globalFont);
        UIManager.put("ComboBox.font", this.globalFont);
        UIManager.put("Label.font", this.globalFont);
        UIManager.put("List.font", this.globalFont);
        UIManager.put("Menu.font", this.globalFont);
        UIManager.put("MenuItem.font", this.globalFont);
        UIManager.put("TextArea.font", this.globalFont);
        UIManager.put("ToggleButton.font", this.globalFont);
        UIManager.put("ToolTip.font", this.globalFont);
        this.setFont(this.globalFont);
        SwingUtilities.updateComponentTreeUI(this);
        this.repaint();
    }

    public void setLookAndFeel(Object lookAndFeel) {
        try {
            if (lookAndFeel instanceof String) {
                UIManager.setLookAndFeel((String)lookAndFeel);
            } else if (lookAndFeel instanceof LookAndFeel) {
                UIManager.setLookAndFeel((LookAndFeel)lookAndFeel);
            }
            SwingUtilities.updateComponentTreeUI(this);
            this.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setVoice(String voiceName) {
        PlayerModel model = this.getModel();
        ListModel descList = model.getSynthesizerList();
        block0: for (int i = 0; i < descList.getSize(); ++i) {
            SynthesizerModeDesc desc = (SynthesizerModeDesc)descList.getElementAt(i);
            Voice[] voices = desc.getVoices();
            for (int j = 0; j < voices.length; ++j) {
                if (!voices[j].getName().equals(voiceName)) continue;
                model.setSynthesizer(i);
                model.setVoice(j);
                continue block0;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        boolean showMonitor = false;
        String firstVoice = "kevin16";
        Player player = new Player("FreeTTS Player");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-voice")) {
                if (++i >= args.length) continue;
                firstVoice = args[i];
                continue;
            }
            if (args[i].equals("-fontsize")) {
                if (++i >= args.length) continue;
                player.setGlobalFontSize(Integer.parseInt(args[i]));
                continue;
            }
            if (args[i].equals("-monitor")) {
                showMonitor = true;
                continue;
            }
            if (!args[i].equals("-input")) continue;
            PlayerModel model = player.getModel();
            ++i;
            while (i < args.length) {
                int start = args[i].indexOf(58);
                if (start > -1) {
                    String content = args[i].substring(start + 1);
                    System.out.println(content);
                    if (args[i].startsWith("plaintext:")) {
                        model.addPlayable(Playable.createTextPlayable(content));
                    } else if (args[i].startsWith("textfile:")) {
                        model.addPlayable(Playable.createTextFilePlayable(new File(content)));
                    } else if (args[i].startsWith("jsmltext:")) {
                        model.addPlayable(Playable.createJSMLPlayable(content));
                    } else if (args[i].startsWith("jsmlfile:")) {
                        model.addPlayable(Playable.createJSMLFilePlayable(new File(content)));
                    }
                }
                ++i;
            }
        }
        player.setMenuBar(new PlayerMenuBar(player));
        player.getModel().createSynthesizers();
        player.setVoice(firstVoice);
        player.show();
        if (showMonitor) {
            player.showMonitor(showMonitor);
        }
    }
}

