/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class PlayerMenuBar
extends JMenuBar {
    private Player player;
    private PlayerModel playerModel;
    private JFileChooser fileChooser;
    private JMenuItem fileSpeakJSMLMenuItem;
    private JMenuItem fileSpeakTextMenuItem;
    private JMenuItem fileSpeakURLMenuItem;
    private JMenuItem fileExitMenuItem;
    private JMenuItem styleLFCrossPlatformMenuItem;
    private JMenuItem styleLFSystemMenuItem;
    private JMenuItem styleFontSizeLargerMenuItem;
    private JMenuItem styleFontSizeSmallerMenuItem;
    private JMenuItem monitorHideMenuItem;
    private JMenuItem monitorShowMenuItem;
    private static char crossPlatformMnemonic = (char)67;
    private static char exitMnemonic = (char)88;
    private static char fileMnemonic = (char)70;
    private static char hideMonitorMnemonic = (char)72;
    private static char jsmlMnemonic = (char)74;
    private static char monitorMnemonic = (char)77;
    private static char showMonitorMnemonic = (char)83;
    private static char speakMnemonic = (char)83;
    private static char styleMnemonic = (char)69;
    private static char styleLFMnemonic = (char)76;
    private static char systemMnemonic = (char)83;
    private static char textMnemonic = (char)84;
    private static char urlMnemonic = (char)85;

    public PlayerMenuBar(Player player) {
        this.player = player;
        this.playerModel = player.getModel();
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        this.add(this.createFileMenu());
        this.add(this.createStyleMenu());
        this.add(this.createMonitorMenu());
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(fileMnemonic);
        this.add(fileMenu);
        JMenu fileSpeakMenu = new JMenu("Speak");
        fileSpeakMenu.setMnemonic(speakMnemonic);
        this.fileSpeakJSMLMenuItem = new JMenuItem("JSML File ...");
        this.fileSpeakTextMenuItem = new JMenuItem("Text File ...");
        this.fileSpeakURLMenuItem = new JMenuItem("URL ...");
        this.fileSpeakJSMLMenuItem.setMnemonic(jsmlMnemonic);
        this.fileSpeakTextMenuItem.setMnemonic(textMnemonic);
        this.fileSpeakURLMenuItem.setMnemonic(urlMnemonic);
        fileSpeakMenu.add(this.fileSpeakJSMLMenuItem);
        fileSpeakMenu.add(this.fileSpeakTextMenuItem);
        fileSpeakMenu.add(this.fileSpeakURLMenuItem);
        this.fileExitMenuItem = new JMenuItem("Exit");
        this.fileExitMenuItem.setMnemonic(exitMnemonic);
        fileMenu.add(fileSpeakMenu);
        fileMenu.addSeparator();
        fileMenu.add(this.fileExitMenuItem);
        this.addFileMenuListeners();
        return fileMenu;
    }

    private void playPlayable(Playable playable) {
        this.playerModel.addPlayable(playable);
        this.player.getView().getPlayList().setSelectedValue(playable, true);
        this.playerModel.play(playable);
    }

    private void addFileMenuListeners() {
        this.fileExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlayerMenuBar.this.playerModel.close();
                System.exit(0);
            }
        });
        this.fileSpeakJSMLMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file = PlayerMenuBar.this.chooseFile();
                if (file != null) {
                    PlayerMenuBar.this.playPlayable(Playable.createJSMLFilePlayable(file));
                }
            }
        });
        this.fileSpeakTextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file = PlayerMenuBar.this.chooseFile();
                if (file != null) {
                    PlayerMenuBar.this.playPlayable(Playable.createTextFilePlayable(file));
                }
            }
        });
        this.fileSpeakURLMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String url = JOptionPane.showInputDialog(PlayerMenuBar.this.getParent(), "Enter URL:", "Speak URL", 3);
                if (url != null && url.length() > 0) {
                    PlayerMenuBar.this.playPlayable(Playable.createURLPlayable(url));
                }
            }
        });
    }

    private JMenu createStyleMenu() {
        JMenu styleMenu = new JMenu("Style");
        styleMenu.setMnemonic(styleMnemonic);
        JMenu styleLFMenu = new JMenu("Look & Feel");
        styleLFMenu.setMnemonic(styleLFMnemonic);
        this.styleLFCrossPlatformMenuItem = new JMenuItem("Cross Platform");
        this.styleLFCrossPlatformMenuItem.setMnemonic(crossPlatformMnemonic);
        this.styleLFSystemMenuItem = new JMenuItem("System");
        this.styleLFSystemMenuItem.setMnemonic(systemMnemonic);
        styleLFMenu.add(this.styleLFCrossPlatformMenuItem);
        styleLFMenu.add(this.styleLFSystemMenuItem);
        styleMenu.add(styleLFMenu);
        this.addStyleMenuListeners();
        return styleMenu;
    }

    private void addStyleMenuListeners() {
        this.styleLFCrossPlatformMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlayerMenuBar.this.player.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        });
        this.styleLFSystemMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlayerMenuBar.this.player.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        });
    }

    private JMenu createMonitorMenu() {
        JMenu monitorMenu = new JMenu("Monitor");
        monitorMenu.setMnemonic(monitorMnemonic);
        this.monitorShowMenuItem = new JMenuItem("Show");
        this.monitorShowMenuItem.setMnemonic(showMonitorMnemonic);
        this.monitorShowMenuItem.setEnabled(!this.playerModel.isMonitorVisible());
        this.monitorHideMenuItem = new JMenuItem("Hide");
        this.monitorHideMenuItem.setMnemonic(hideMonitorMnemonic);
        this.monitorHideMenuItem.setEnabled(this.playerModel.isMonitorVisible());
        monitorMenu.add(this.monitorShowMenuItem);
        monitorMenu.add(this.monitorHideMenuItem);
        this.addMonitorMenuListeners();
        return monitorMenu;
    }

    private void addMonitorMenuListeners() {
        this.monitorShowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlayerMenuBar.this.monitorShowMenuItem.setEnabled(false);
                PlayerMenuBar.this.monitorHideMenuItem.setEnabled(true);
                PlayerMenuBar.this.player.showMonitor(true);
            }
        });
        this.monitorHideMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlayerMenuBar.this.monitorShowMenuItem.setEnabled(true);
                PlayerMenuBar.this.monitorHideMenuItem.setEnabled(false);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        PlayerMenuBar.access$300(8.access$600(this.this$1)).showMonitor(false);
                    }
                });
            }

            static /* synthetic */ PlayerMenuBar access$600(8 x0) {
                return x0.PlayerMenuBar.this;
            }
        });
    }

    private JFrame getFrame() {
        return this.player;
    }

    private File chooseFile() {
        int option = this.fileChooser.showOpenDialog(this.getParent());
        if (option == 0) {
            return this.fileChooser.getSelectedFile();
        }
        return null;
    }
}

