/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.DefaultFolder;
import com.sun.mail.pop3.POP3Message;
import com.sun.mail.pop3.POP3Store;
import com.sun.mail.pop3.Protocol;
import com.sun.mail.pop3.Status;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Store;
import javax.mail.UIDFolder;

public class POP3Folder
extends Folder {
    private String name;
    private Protocol port;
    private int total;
    private int size;
    private boolean exists = false;
    private boolean opened = false;
    private Vector message_cache;
    private boolean doneUidl = false;

    POP3Folder(POP3Store pOP3Store, String string) {
        super((Store)pOP3Store);
        this.name = string;
        if (string.equalsIgnoreCase("INBOX")) {
            this.exists = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.name;
    }

    public Folder getParent() {
        return new DefaultFolder((POP3Store)this.store);
    }

    public boolean exists() {
        return this.exists;
    }

    public Folder[] list(String string) throws MessagingException {
        throw new MessagingException("not a directory");
    }

    public char getSeparator() {
        return '\u0000';
    }

    public int getType() {
        return 1;
    }

    public boolean create(int n) throws MessagingException {
        return false;
    }

    public boolean hasNewMessages() throws MessagingException {
        return false;
    }

    public Folder getFolder(String string) throws MessagingException {
        throw new MessagingException("not a directory");
    }

    public boolean delete(boolean bl) throws MessagingException {
        throw new MethodNotSupportedException("delete");
    }

    public boolean renameTo(Folder folder) throws MessagingException {
        throw new MethodNotSupportedException("renameTo");
    }

    public synchronized void open(int n) throws MessagingException {
        this.checkClosed();
        if (!this.exists) {
            throw new FolderNotFoundException((Folder)this, "folder is not INBOX");
        }
        try {
            this.port = ((POP3Store)this.store).getPort(this);
            Status status = this.port.stat();
            this.total = status.total;
            this.size = status.size;
            this.mode = n;
            this.opened = true;
        }
        catch (IOException iOException) {
            try {
                try {
                    if (this.port != null) {
                        this.port.quit();
                    }
                }
                catch (IOException iOException2) {
                }
                Object var4_4 = null;
                this.port = null;
                ((POP3Store)this.store).closePort(this);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.port = null;
                ((POP3Store)this.store).closePort(this);
                throw throwable;
            }
            throw new MessagingException("Open failed", (Exception)iOException);
        }
        this.message_cache = new Vector(this.total);
        this.message_cache.setSize(this.total);
        this.doneUidl = false;
        this.notifyConnectionListeners(1);
    }

    public synchronized void close(boolean bl) throws MessagingException {
        this.checkOpen();
        try {
            try {
                if (((POP3Store)this.store).rsetBeforeQuit) {
                    this.port.rset();
                }
                if (bl && this.mode == 2) {
                    int n = 0;
                    while (n < this.message_cache.size()) {
                        POP3Message pOP3Message = (POP3Message)((Object)this.message_cache.elementAt(n));
                        if (pOP3Message != null && pOP3Message.isSet(Flags.Flag.DELETED)) {
                            try {
                                this.port.dele(n + 1);
                            }
                            catch (IOException iOException) {
                                throw new MessagingException("Exception deleting messages during close", (Exception)iOException);
                            }
                        }
                        ++n;
                    }
                }
                this.port.quit();
            }
            catch (IOException iOException) {
            }
            Object var3_5 = null;
            this.port = null;
            ((POP3Store)this.store).closePort(this);
            this.message_cache = null;
            this.opened = false;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.port = null;
            ((POP3Store)this.store).closePort(this);
            this.message_cache = null;
            this.opened = false;
            this.notifyConnectionListeners(3);
            throw throwable;
        }
        this.notifyConnectionListeners(3);
    }

    public boolean isOpen() {
        if (!this.opened) {
            return false;
        }
        if (this.store.isConnected()) {
            return true;
        }
        try {
            this.close(false);
        }
        catch (MessagingException messagingException) {}
        return false;
    }

    public Flags getPermanentFlags() {
        return new Flags();
    }

    public int getMessageCount() throws MessagingException {
        if (!this.opened) {
            return -1;
        }
        this.checkReadable();
        return this.total;
    }

    public synchronized Message getMessage(int n) throws MessagingException {
        this.checkOpen();
        POP3Message pOP3Message = (POP3Message)((Object)this.message_cache.elementAt(n - 1));
        if (pOP3Message == null) {
            pOP3Message = this.createMessage(this, n);
            this.message_cache.setElementAt(pOP3Message, n - 1);
        }
        return pOP3Message;
    }

    protected POP3Message createMessage(Folder folder, int n) throws MessagingException {
        POP3Message pOP3Message = null;
        Constructor constructor = ((POP3Store)this.store).messageConstructor;
        if (constructor != null) {
            try {
                Object[] objectArray = new Object[]{this, new Integer(n)};
                pOP3Message = (POP3Message)((Object)constructor.newInstance(objectArray));
            }
            catch (Exception exception) {}
        }
        if (pOP3Message == null) {
            pOP3Message = new POP3Message(this, n);
        }
        return pOP3Message;
    }

    public void appendMessages(Message[] messageArray) throws MessagingException {
        throw new MethodNotSupportedException("Append not supported");
    }

    public Message[] expunge() throws MessagingException {
        throw new MethodNotSupportedException("Expunge not supported");
    }

    public synchronized void fetch(Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
        this.checkReadable();
        if (!this.doneUidl && fetchProfile.contains((FetchProfile.Item)UIDFolder.FetchProfileItem.UID)) {
            String[] stringArray = new String[this.message_cache.size()];
            try {
                if (!this.port.uidl(stringArray)) {
                    return;
                }
            }
            catch (EOFException eOFException) {
                this.close(false);
                throw new FolderClosedException((Folder)this, eOFException.toString());
            }
            catch (IOException iOException) {
                throw new MessagingException("error getting UIDL", (Exception)iOException);
            }
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    POP3Message pOP3Message = (POP3Message)this.getMessage(n + 1);
                    pOP3Message.uid = stringArray[n];
                }
                ++n;
            }
            this.doneUidl = true;
        }
        if (fetchProfile.contains(FetchProfile.Item.ENVELOPE)) {
            int n = 0;
            while (n < messageArray.length) {
                try {
                    POP3Message pOP3Message = (POP3Message)messageArray[n];
                    pOP3Message.getHeader("");
                    pOP3Message.getSize();
                }
                catch (MessageRemovedException messageRemovedException) {}
                ++n;
            }
        }
    }

    public synchronized String getUID(Message message) throws MessagingException {
        this.checkOpen();
        POP3Message pOP3Message = (POP3Message)message;
        try {
            if (pOP3Message.uid == "UNKNOWN") {
                pOP3Message.uid = this.port.uidl(pOP3Message.getMessageNumber());
            }
            return pOP3Message.uid;
        }
        catch (EOFException eOFException) {
            this.close(false);
            throw new FolderClosedException((Folder)this, eOFException.toString());
        }
        catch (IOException iOException) {
            throw new MessagingException("error getting UIDL", (Exception)iOException);
        }
    }

    public int getSize() throws MessagingException {
        this.checkOpen();
        return this.size;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close(false);
    }

    void checkOpen() throws IllegalStateException {
        if (!this.opened) {
            throw new IllegalStateException("Folder is not Open");
        }
    }

    void checkClosed() throws IllegalStateException {
        if (this.opened) {
            throw new IllegalStateException("Folder is Open");
        }
    }

    void checkReadable() throws IllegalStateException {
        if (!this.opened || this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Folder is not Readable");
        }
    }

    void checkWritable() throws IllegalStateException {
        if (!this.opened || this.mode != 2) {
            throw new IllegalStateException("Folder is not Writable");
        }
    }

    Protocol getProtocol() throws MessagingException {
        this.checkOpen();
        return this.port;
    }

    protected void notifyMessageChangedListeners(int n, Message message) {
        super.notifyMessageChangedListeners(n, message);
    }
}

